/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The decoding information for a specific message which support higher order data types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageSignal implements SdkPojo, Serializable, ToCopyableBuilder<MessageSignal.Builder, MessageSignal> {
    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("topicName").getter(getter(MessageSignal::topicName)).setter(setter(Builder::topicName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicName").build()).build();

    private static final SdkField<StructuredMessage> STRUCTURED_MESSAGE_FIELD = SdkField
            .<StructuredMessage> builder(MarshallingType.SDK_POJO).memberName("structuredMessage")
            .getter(getter(MessageSignal::structuredMessage)).setter(setter(Builder::structuredMessage))
            .constructor(StructuredMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("structuredMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_NAME_FIELD,
            STRUCTURED_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String topicName;

    private final StructuredMessage structuredMessage;

    private MessageSignal(BuilderImpl builder) {
        this.topicName = builder.topicName;
        this.structuredMessage = builder.structuredMessage;
    }

    /**
     * <p>
     * The topic name for the message signal. It corresponds to topics in ROS 2.
     * </p>
     * 
     * @return The topic name for the message signal. It corresponds to topics in ROS 2.
     */
    public final String topicName() {
        return topicName;
    }

    /**
     * <p>
     * The structured message for the message signal. It can be defined with either a
     * <code>primitiveMessageDefinition</code>, <code>structuredMessageListDefinition</code>, or
     * <code>structuredMessageDefinition</code> recursively.
     * </p>
     * 
     * @return The structured message for the message signal. It can be defined with either a
     *         <code>primitiveMessageDefinition</code>, <code>structuredMessageListDefinition</code>, or
     *         <code>structuredMessageDefinition</code> recursively.
     */
    public final StructuredMessage structuredMessage() {
        return structuredMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicName());
        hashCode = 31 * hashCode + Objects.hashCode(structuredMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageSignal)) {
            return false;
        }
        MessageSignal other = (MessageSignal) obj;
        return Objects.equals(topicName(), other.topicName()) && Objects.equals(structuredMessage(), other.structuredMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageSignal").add("TopicName", topicName()).add("StructuredMessage", structuredMessage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "topicName":
            return Optional.ofNullable(clazz.cast(topicName()));
        case "structuredMessage":
            return Optional.ofNullable(clazz.cast(structuredMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MessageSignal, T> g) {
        return obj -> g.apply((MessageSignal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageSignal> {
        /**
         * <p>
         * The topic name for the message signal. It corresponds to topics in ROS 2.
         * </p>
         * 
         * @param topicName
         *        The topic name for the message signal. It corresponds to topics in ROS 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicName(String topicName);

        /**
         * <p>
         * The structured message for the message signal. It can be defined with either a
         * <code>primitiveMessageDefinition</code>, <code>structuredMessageListDefinition</code>, or
         * <code>structuredMessageDefinition</code> recursively.
         * </p>
         * 
         * @param structuredMessage
         *        The structured message for the message signal. It can be defined with either a
         *        <code>primitiveMessageDefinition</code>, <code>structuredMessageListDefinition</code>, or
         *        <code>structuredMessageDefinition</code> recursively.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder structuredMessage(StructuredMessage structuredMessage);

        /**
         * <p>
         * The structured message for the message signal. It can be defined with either a
         * <code>primitiveMessageDefinition</code>, <code>structuredMessageListDefinition</code>, or
         * <code>structuredMessageDefinition</code> recursively.
         * </p>
         * This is a convenience method that creates an instance of the {@link StructuredMessage.Builder} avoiding the
         * need to create one manually via {@link StructuredMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StructuredMessage.Builder#build()} is called immediately and its
         * result is passed to {@link #structuredMessage(StructuredMessage)}.
         * 
         * @param structuredMessage
         *        a consumer that will call methods on {@link StructuredMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #structuredMessage(StructuredMessage)
         */
        default Builder structuredMessage(Consumer<StructuredMessage.Builder> structuredMessage) {
            return structuredMessage(StructuredMessage.builder().applyMutation(structuredMessage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String topicName;

        private StructuredMessage structuredMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageSignal model) {
            topicName(model.topicName);
            structuredMessage(model.structuredMessage);
        }

        public final String getTopicName() {
            return topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final StructuredMessage.Builder getStructuredMessage() {
            return structuredMessage != null ? structuredMessage.toBuilder() : null;
        }

        public final void setStructuredMessage(StructuredMessage.BuilderImpl structuredMessage) {
            this.structuredMessage = structuredMessage != null ? structuredMessage.build() : null;
        }

        @Override
        public final Builder structuredMessage(StructuredMessage structuredMessage) {
            this.structuredMessage = structuredMessage;
            return this;
        }

        @Override
        public MessageSignal build() {
            return new MessageSignal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
