/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A general abstraction of a signal. A node can be specified as an actuator, attribute, branch, or sensor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Node implements SdkPojo, Serializable, ToCopyableBuilder<Node.Builder, Node> {
    private static final SdkField<Branch> BRANCH_FIELD = SdkField.<Branch> builder(MarshallingType.SDK_POJO).memberName("branch")
            .getter(getter(Node::branch)).setter(setter(Builder::branch)).constructor(Branch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branch").build()).build();

    private static final SdkField<Sensor> SENSOR_FIELD = SdkField.<Sensor> builder(MarshallingType.SDK_POJO).memberName("sensor")
            .getter(getter(Node::sensor)).setter(setter(Builder::sensor)).constructor(Sensor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensor").build()).build();

    private static final SdkField<Actuator> ACTUATOR_FIELD = SdkField.<Actuator> builder(MarshallingType.SDK_POJO)
            .memberName("actuator").getter(getter(Node::actuator)).setter(setter(Builder::actuator))
            .constructor(Actuator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actuator").build()).build();

    private static final SdkField<Attribute> ATTRIBUTE_FIELD = SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
            .memberName("attribute").getter(getter(Node::attribute)).setter(setter(Builder::attribute))
            .constructor(Attribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribute").build()).build();

    private static final SdkField<CustomStruct> STRUCT_FIELD = SdkField.<CustomStruct> builder(MarshallingType.SDK_POJO)
            .memberName("struct").getter(getter(Node::struct)).setter(setter(Builder::struct)).constructor(CustomStruct::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("struct").build()).build();

    private static final SdkField<CustomProperty> PROPERTY_FIELD = SdkField.<CustomProperty> builder(MarshallingType.SDK_POJO)
            .memberName("property").getter(getter(Node::property)).setter(setter(Builder::property))
            .constructor(CustomProperty::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("property").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD, SENSOR_FIELD,
            ACTUATOR_FIELD, ATTRIBUTE_FIELD, STRUCT_FIELD, PROPERTY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Branch branch;

    private final Sensor sensor;

    private final Actuator actuator;

    private final Attribute attribute;

    private final CustomStruct struct;

    private final CustomProperty property;

    private final Type type;

    private Node(BuilderImpl builder) {
        this.branch = builder.branch;
        this.sensor = builder.sensor;
        this.actuator = builder.actuator;
        this.attribute = builder.attribute;
        this.struct = builder.struct;
        this.property = builder.property;
        this.type = builder.type;
    }

    /**
     * <p>
     * Information about a node specified as a branch.
     * </p>
     * <note>
     * <p>
     * A group of signals that are defined in a hierarchical structure.
     * </p>
     * </note>
     * 
     * @return Information about a node specified as a branch.</p> <note>
     *         <p>
     *         A group of signals that are defined in a hierarchical structure.
     *         </p>
     */
    public final Branch branch() {
        return branch;
    }

    /**
     * Returns the value of the Sensor property for this object.
     * 
     * @return The value of the Sensor property for this object.
     */
    public final Sensor sensor() {
        return sensor;
    }

    /**
     * <p>
     * Information about a node specified as an actuator.
     * </p>
     * <note>
     * <p>
     * An actuator is a digital representation of a vehicle device.
     * </p>
     * </note>
     * 
     * @return Information about a node specified as an actuator.</p> <note>
     *         <p>
     *         An actuator is a digital representation of a vehicle device.
     *         </p>
     */
    public final Actuator actuator() {
        return actuator;
    }

    /**
     * <p>
     * Information about a node specified as an attribute.
     * </p>
     * <note>
     * <p>
     * An attribute represents static information about a vehicle.
     * </p>
     * </note>
     * 
     * @return Information about a node specified as an attribute.</p> <note>
     *         <p>
     *         An attribute represents static information about a vehicle.
     *         </p>
     */
    public final Attribute attribute() {
        return attribute;
    }

    /**
     * <p>
     * Represents a complex or higher-order data structure.
     * </p>
     * 
     * @return Represents a complex or higher-order data structure.
     */
    public final CustomStruct struct() {
        return struct;
    }

    /**
     * <p>
     * Represents a member of the complex data structure. The <code>datatype</code> of the property can be either
     * primitive or another <code>struct</code>.
     * </p>
     * 
     * @return Represents a member of the complex data structure. The <code>datatype</code> of the property can be
     *         either primitive or another <code>struct</code>.
     */
    public final CustomProperty property() {
        return property;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(branch());
        hashCode = 31 * hashCode + Objects.hashCode(sensor());
        hashCode = 31 * hashCode + Objects.hashCode(actuator());
        hashCode = 31 * hashCode + Objects.hashCode(attribute());
        hashCode = 31 * hashCode + Objects.hashCode(struct());
        hashCode = 31 * hashCode + Objects.hashCode(property());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node) obj;
        return Objects.equals(branch(), other.branch()) && Objects.equals(sensor(), other.sensor())
                && Objects.equals(actuator(), other.actuator()) && Objects.equals(attribute(), other.attribute())
                && Objects.equals(struct(), other.struct()) && Objects.equals(property(), other.property());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Node").add("Branch", branch()).add("Sensor", sensor()).add("Actuator", actuator())
                .add("Attribute", attribute()).add("Struct", struct()).add("Property", property()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "branch":
            return Optional.ofNullable(clazz.cast(branch()));
        case "sensor":
            return Optional.ofNullable(clazz.cast(sensor()));
        case "actuator":
            return Optional.ofNullable(clazz.cast(actuator()));
        case "attribute":
            return Optional.ofNullable(clazz.cast(attribute()));
        case "struct":
            return Optional.ofNullable(clazz.cast(struct()));
        case "property":
            return Optional.ofNullable(clazz.cast(property()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #branch()} initialized to the given value.
     *
     * <p>
     * Information about a node specified as a branch.
     * </p>
     * <note>
     * <p>
     * A group of signals that are defined in a hierarchical structure.
     * </p>
     * </note>
     * 
     * @param branch
     *        Information about a node specified as a branch.</p> <note>
     *        <p>
     *        A group of signals that are defined in a hierarchical structure.
     *        </p>
     */
    public static Node fromBranch(Branch branch) {
        return builder().branch(branch).build();
    }

    /**
     * Create an instance of this class with {@link #branch()} initialized to the given value.
     *
     * <p>
     * Information about a node specified as a branch.
     * </p>
     * <note>
     * <p>
     * A group of signals that are defined in a hierarchical structure.
     * </p>
     * </note>
     * 
     * @param branch
     *        Information about a node specified as a branch.</p> <note>
     *        <p>
     *        A group of signals that are defined in a hierarchical structure.
     *        </p>
     */
    public static Node fromBranch(Consumer<Branch.Builder> branch) {
        Branch.Builder builder = Branch.builder();
        branch.accept(builder);
        return fromBranch(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sensor()} initialized to the given value.
     *
     * Sets the value of the Sensor property for this object.
     *
     * @param sensor
     *        The new value for the Sensor property for this object.
     */
    public static Node fromSensor(Sensor sensor) {
        return builder().sensor(sensor).build();
    }

    /**
     * Create an instance of this class with {@link #sensor()} initialized to the given value.
     *
     * Sets the value of the Sensor property for this object.
     *
     * @param sensor
     *        The new value for the Sensor property for this object.
     */
    public static Node fromSensor(Consumer<Sensor.Builder> sensor) {
        Sensor.Builder builder = Sensor.builder();
        sensor.accept(builder);
        return fromSensor(builder.build());
    }

    /**
     * Create an instance of this class with {@link #actuator()} initialized to the given value.
     *
     * <p>
     * Information about a node specified as an actuator.
     * </p>
     * <note>
     * <p>
     * An actuator is a digital representation of a vehicle device.
     * </p>
     * </note>
     * 
     * @param actuator
     *        Information about a node specified as an actuator.</p> <note>
     *        <p>
     *        An actuator is a digital representation of a vehicle device.
     *        </p>
     */
    public static Node fromActuator(Actuator actuator) {
        return builder().actuator(actuator).build();
    }

    /**
     * Create an instance of this class with {@link #actuator()} initialized to the given value.
     *
     * <p>
     * Information about a node specified as an actuator.
     * </p>
     * <note>
     * <p>
     * An actuator is a digital representation of a vehicle device.
     * </p>
     * </note>
     * 
     * @param actuator
     *        Information about a node specified as an actuator.</p> <note>
     *        <p>
     *        An actuator is a digital representation of a vehicle device.
     *        </p>
     */
    public static Node fromActuator(Consumer<Actuator.Builder> actuator) {
        Actuator.Builder builder = Actuator.builder();
        actuator.accept(builder);
        return fromActuator(builder.build());
    }

    /**
     * Create an instance of this class with {@link #attribute()} initialized to the given value.
     *
     * <p>
     * Information about a node specified as an attribute.
     * </p>
     * <note>
     * <p>
     * An attribute represents static information about a vehicle.
     * </p>
     * </note>
     * 
     * @param attribute
     *        Information about a node specified as an attribute.</p> <note>
     *        <p>
     *        An attribute represents static information about a vehicle.
     *        </p>
     */
    public static Node fromAttribute(Attribute attribute) {
        return builder().attribute(attribute).build();
    }

    /**
     * Create an instance of this class with {@link #attribute()} initialized to the given value.
     *
     * <p>
     * Information about a node specified as an attribute.
     * </p>
     * <note>
     * <p>
     * An attribute represents static information about a vehicle.
     * </p>
     * </note>
     * 
     * @param attribute
     *        Information about a node specified as an attribute.</p> <note>
     *        <p>
     *        An attribute represents static information about a vehicle.
     *        </p>
     */
    public static Node fromAttribute(Consumer<Attribute.Builder> attribute) {
        Attribute.Builder builder = Attribute.builder();
        attribute.accept(builder);
        return fromAttribute(builder.build());
    }

    /**
     * Create an instance of this class with {@link #struct()} initialized to the given value.
     *
     * <p>
     * Represents a complex or higher-order data structure.
     * </p>
     * 
     * @param struct
     *        Represents a complex or higher-order data structure.
     */
    public static Node fromStruct(CustomStruct struct) {
        return builder().struct(struct).build();
    }

    /**
     * Create an instance of this class with {@link #struct()} initialized to the given value.
     *
     * <p>
     * Represents a complex or higher-order data structure.
     * </p>
     * 
     * @param struct
     *        Represents a complex or higher-order data structure.
     */
    public static Node fromStruct(Consumer<CustomStruct.Builder> struct) {
        CustomStruct.Builder builder = CustomStruct.builder();
        struct.accept(builder);
        return fromStruct(builder.build());
    }

    /**
     * Create an instance of this class with {@link #property()} initialized to the given value.
     *
     * <p>
     * Represents a member of the complex data structure. The <code>datatype</code> of the property can be either
     * primitive or another <code>struct</code>.
     * </p>
     * 
     * @param property
     *        Represents a member of the complex data structure. The <code>datatype</code> of the property can be either
     *        primitive or another <code>struct</code>.
     */
    public static Node fromProperty(CustomProperty property) {
        return builder().property(property).build();
    }

    /**
     * Create an instance of this class with {@link #property()} initialized to the given value.
     *
     * <p>
     * Represents a member of the complex data structure. The <code>datatype</code> of the property can be either
     * primitive or another <code>struct</code>.
     * </p>
     * 
     * @param property
     *        Represents a member of the complex data structure. The <code>datatype</code> of the property can be either
     *        primitive or another <code>struct</code>.
     */
    public static Node fromProperty(Consumer<CustomProperty.Builder> property) {
        CustomProperty.Builder builder = CustomProperty.builder();
        property.accept(builder);
        return fromProperty(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Node, T> g) {
        return obj -> g.apply((Node) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Node> {
        /**
         * <p>
         * Information about a node specified as a branch.
         * </p>
         * <note>
         * <p>
         * A group of signals that are defined in a hierarchical structure.
         * </p>
         * </note>
         * 
         * @param branch
         *        Information about a node specified as a branch.</p> <note>
         *        <p>
         *        A group of signals that are defined in a hierarchical structure.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branch(Branch branch);

        /**
         * <p>
         * Information about a node specified as a branch.
         * </p>
         * <note>
         * <p>
         * A group of signals that are defined in a hierarchical structure.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link Branch.Builder} avoiding the need
         * to create one manually via {@link Branch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Branch.Builder#build()} is called immediately and its result is
         * passed to {@link #branch(Branch)}.
         * 
         * @param branch
         *        a consumer that will call methods on {@link Branch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #branch(Branch)
         */
        default Builder branch(Consumer<Branch.Builder> branch) {
            return branch(Branch.builder().applyMutation(branch).build());
        }

        /**
         * Sets the value of the Sensor property for this object.
         *
         * @param sensor
         *        The new value for the Sensor property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensor(Sensor sensor);

        /**
         * Sets the value of the Sensor property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Sensor.Builder} avoiding the need to
         * create one manually via {@link Sensor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Sensor.Builder#build()} is called immediately and its result is
         * passed to {@link #sensor(Sensor)}.
         * 
         * @param sensor
         *        a consumer that will call methods on {@link Sensor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sensor(Sensor)
         */
        default Builder sensor(Consumer<Sensor.Builder> sensor) {
            return sensor(Sensor.builder().applyMutation(sensor).build());
        }

        /**
         * <p>
         * Information about a node specified as an actuator.
         * </p>
         * <note>
         * <p>
         * An actuator is a digital representation of a vehicle device.
         * </p>
         * </note>
         * 
         * @param actuator
         *        Information about a node specified as an actuator.</p> <note>
         *        <p>
         *        An actuator is a digital representation of a vehicle device.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actuator(Actuator actuator);

        /**
         * <p>
         * Information about a node specified as an actuator.
         * </p>
         * <note>
         * <p>
         * An actuator is a digital representation of a vehicle device.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link Actuator.Builder} avoiding the
         * need to create one manually via {@link Actuator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Actuator.Builder#build()} is called immediately and its result is
         * passed to {@link #actuator(Actuator)}.
         * 
         * @param actuator
         *        a consumer that will call methods on {@link Actuator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actuator(Actuator)
         */
        default Builder actuator(Consumer<Actuator.Builder> actuator) {
            return actuator(Actuator.builder().applyMutation(actuator).build());
        }

        /**
         * <p>
         * Information about a node specified as an attribute.
         * </p>
         * <note>
         * <p>
         * An attribute represents static information about a vehicle.
         * </p>
         * </note>
         * 
         * @param attribute
         *        Information about a node specified as an attribute.</p> <note>
         *        <p>
         *        An attribute represents static information about a vehicle.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attribute(Attribute attribute);

        /**
         * <p>
         * Information about a node specified as an attribute.
         * </p>
         * <note>
         * <p>
         * An attribute represents static information about a vehicle.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link Attribute.Builder} avoiding the
         * need to create one manually via {@link Attribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Attribute.Builder#build()} is called immediately and its result
         * is passed to {@link #attribute(Attribute)}.
         * 
         * @param attribute
         *        a consumer that will call methods on {@link Attribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attribute(Attribute)
         */
        default Builder attribute(Consumer<Attribute.Builder> attribute) {
            return attribute(Attribute.builder().applyMutation(attribute).build());
        }

        /**
         * <p>
         * Represents a complex or higher-order data structure.
         * </p>
         * 
         * @param struct
         *        Represents a complex or higher-order data structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder struct(CustomStruct struct);

        /**
         * <p>
         * Represents a complex or higher-order data structure.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomStruct.Builder} avoiding the need
         * to create one manually via {@link CustomStruct#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomStruct.Builder#build()} is called immediately and its
         * result is passed to {@link #struct(CustomStruct)}.
         * 
         * @param struct
         *        a consumer that will call methods on {@link CustomStruct.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #struct(CustomStruct)
         */
        default Builder struct(Consumer<CustomStruct.Builder> struct) {
            return struct(CustomStruct.builder().applyMutation(struct).build());
        }

        /**
         * <p>
         * Represents a member of the complex data structure. The <code>datatype</code> of the property can be either
         * primitive or another <code>struct</code>.
         * </p>
         * 
         * @param property
         *        Represents a member of the complex data structure. The <code>datatype</code> of the property can be
         *        either primitive or another <code>struct</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder property(CustomProperty property);

        /**
         * <p>
         * Represents a member of the complex data structure. The <code>datatype</code> of the property can be either
         * primitive or another <code>struct</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomProperty.Builder} avoiding the need
         * to create one manually via {@link CustomProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomProperty.Builder#build()} is called immediately and its
         * result is passed to {@link #property(CustomProperty)}.
         * 
         * @param property
         *        a consumer that will call methods on {@link CustomProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #property(CustomProperty)
         */
        default Builder property(Consumer<CustomProperty.Builder> property) {
            return property(CustomProperty.builder().applyMutation(property).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Branch branch;

        private Sensor sensor;

        private Actuator actuator;

        private Attribute attribute;

        private CustomStruct struct;

        private CustomProperty property;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Node model) {
            branch(model.branch);
            sensor(model.sensor);
            actuator(model.actuator);
            attribute(model.attribute);
            struct(model.struct);
            property(model.property);
        }

        public final Branch.Builder getBranch() {
            return branch != null ? branch.toBuilder() : null;
        }

        public final void setBranch(Branch.BuilderImpl branch) {
            Object oldValue = this.branch;
            this.branch = branch != null ? branch.build() : null;
            handleUnionValueChange(Type.BRANCH, oldValue, this.branch);
        }

        @Override
        public final Builder branch(Branch branch) {
            Object oldValue = this.branch;
            this.branch = branch;
            handleUnionValueChange(Type.BRANCH, oldValue, this.branch);
            return this;
        }

        public final Sensor.Builder getSensor() {
            return sensor != null ? sensor.toBuilder() : null;
        }

        public final void setSensor(Sensor.BuilderImpl sensor) {
            Object oldValue = this.sensor;
            this.sensor = sensor != null ? sensor.build() : null;
            handleUnionValueChange(Type.SENSOR, oldValue, this.sensor);
        }

        @Override
        public final Builder sensor(Sensor sensor) {
            Object oldValue = this.sensor;
            this.sensor = sensor;
            handleUnionValueChange(Type.SENSOR, oldValue, this.sensor);
            return this;
        }

        public final Actuator.Builder getActuator() {
            return actuator != null ? actuator.toBuilder() : null;
        }

        public final void setActuator(Actuator.BuilderImpl actuator) {
            Object oldValue = this.actuator;
            this.actuator = actuator != null ? actuator.build() : null;
            handleUnionValueChange(Type.ACTUATOR, oldValue, this.actuator);
        }

        @Override
        public final Builder actuator(Actuator actuator) {
            Object oldValue = this.actuator;
            this.actuator = actuator;
            handleUnionValueChange(Type.ACTUATOR, oldValue, this.actuator);
            return this;
        }

        public final Attribute.Builder getAttribute() {
            return attribute != null ? attribute.toBuilder() : null;
        }

        public final void setAttribute(Attribute.BuilderImpl attribute) {
            Object oldValue = this.attribute;
            this.attribute = attribute != null ? attribute.build() : null;
            handleUnionValueChange(Type.ATTRIBUTE, oldValue, this.attribute);
        }

        @Override
        public final Builder attribute(Attribute attribute) {
            Object oldValue = this.attribute;
            this.attribute = attribute;
            handleUnionValueChange(Type.ATTRIBUTE, oldValue, this.attribute);
            return this;
        }

        public final CustomStruct.Builder getStruct() {
            return struct != null ? struct.toBuilder() : null;
        }

        public final void setStruct(CustomStruct.BuilderImpl struct) {
            Object oldValue = this.struct;
            this.struct = struct != null ? struct.build() : null;
            handleUnionValueChange(Type.STRUCT, oldValue, this.struct);
        }

        @Override
        public final Builder struct(CustomStruct struct) {
            Object oldValue = this.struct;
            this.struct = struct;
            handleUnionValueChange(Type.STRUCT, oldValue, this.struct);
            return this;
        }

        public final CustomProperty.Builder getProperty() {
            return property != null ? property.toBuilder() : null;
        }

        public final void setProperty(CustomProperty.BuilderImpl property) {
            Object oldValue = this.property;
            this.property = property != null ? property.build() : null;
            handleUnionValueChange(Type.PROPERTY, oldValue, this.property);
        }

        @Override
        public final Builder property(CustomProperty property) {
            Object oldValue = this.property;
            this.property = property;
            handleUnionValueChange(Type.PROPERTY, oldValue, this.property);
            return this;
        }

        @Override
        public Node build() {
            return new Node(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Node#type()
     */
    public enum Type {
        BRANCH,

        SENSOR,

        ACTUATOR,

        ATTRIBUTE,

        STRUCT,

        PROPERTY,

        UNKNOWN_TO_SDK_VERSION
    }
}
