/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum NodeDataType {
    INT8("INT8"),

    UINT8("UINT8"),

    INT16("INT16"),

    UINT16("UINT16"),

    INT32("INT32"),

    UINT32("UINT32"),

    INT64("INT64"),

    UINT64("UINT64"),

    BOOLEAN("BOOLEAN"),

    FLOAT("FLOAT"),

    DOUBLE("DOUBLE"),

    STRING("STRING"),

    UNIX_TIMESTAMP("UNIX_TIMESTAMP"),

    INT8_ARRAY("INT8_ARRAY"),

    UINT8_ARRAY("UINT8_ARRAY"),

    INT16_ARRAY("INT16_ARRAY"),

    UINT16_ARRAY("UINT16_ARRAY"),

    INT32_ARRAY("INT32_ARRAY"),

    UINT32_ARRAY("UINT32_ARRAY"),

    INT64_ARRAY("INT64_ARRAY"),

    UINT64_ARRAY("UINT64_ARRAY"),

    BOOLEAN_ARRAY("BOOLEAN_ARRAY"),

    FLOAT_ARRAY("FLOAT_ARRAY"),

    DOUBLE_ARRAY("DOUBLE_ARRAY"),

    STRING_ARRAY("STRING_ARRAY"),

    UNIX_TIMESTAMP_ARRAY("UNIX_TIMESTAMP_ARRAY"),

    UNKNOWN("UNKNOWN"),

    STRUCT("STRUCT"),

    STRUCT_ARRAY("STRUCT_ARRAY"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeDataType> VALUE_MAP = EnumUtils.uniqueIndex(NodeDataType.class, NodeDataType::toString);

    private final String value;

    private NodeDataType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return NodeDataType corresponding to the value
     */
    public static NodeDataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link NodeDataType}s
     */
    public static Set<NodeDataType> knownValues() {
        Set<NodeDataType> knownValues = EnumSet.allOf(NodeDataType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
