/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ROS2PrimitiveType {
    BOOL("BOOL"),

    BYTE("BYTE"),

    CHAR("CHAR"),

    FLOAT32("FLOAT32"),

    FLOAT64("FLOAT64"),

    INT8("INT8"),

    UINT8("UINT8"),

    INT16("INT16"),

    UINT16("UINT16"),

    INT32("INT32"),

    UINT32("UINT32"),

    INT64("INT64"),

    UINT64("UINT64"),

    STRING("STRING"),

    WSTRING("WSTRING"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ROS2PrimitiveType> VALUE_MAP = EnumUtils.uniqueIndex(ROS2PrimitiveType.class,
            ROS2PrimitiveType::toString);

    private final String value;

    private ROS2PrimitiveType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ROS2PrimitiveType corresponding to the value
     */
    public static ROS2PrimitiveType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ROS2PrimitiveType}s
     */
    public static Set<ROS2PrimitiveType> knownValues() {
        Set<ROS2PrimitiveType> knownValues = EnumSet.allOf(ROS2PrimitiveType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
