/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The vehicle middleware defined as a type of network interface. Examples of vehicle middleware include
 * <code>ROS2</code> and <code>SOME/IP</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VehicleMiddleware implements SdkPojo, Serializable,
        ToCopyableBuilder<VehicleMiddleware.Builder, VehicleMiddleware> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(VehicleMiddleware::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROTOCOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocolName").getter(getter(VehicleMiddleware::protocolNameAsString))
            .setter(setter(Builder::protocolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            PROTOCOL_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String protocolName;

    private VehicleMiddleware(BuilderImpl builder) {
        this.name = builder.name;
        this.protocolName = builder.protocolName;
    }

    /**
     * <p>
     * The name of the vehicle middleware.
     * </p>
     * 
     * @return The name of the vehicle middleware.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The protocol name of the vehicle middleware.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolName} will
     * return {@link VehicleMiddlewareProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolNameAsString}.
     * </p>
     * 
     * @return The protocol name of the vehicle middleware.
     * @see VehicleMiddlewareProtocol
     */
    public final VehicleMiddlewareProtocol protocolName() {
        return VehicleMiddlewareProtocol.fromValue(protocolName);
    }

    /**
     * <p>
     * The protocol name of the vehicle middleware.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocolName} will
     * return {@link VehicleMiddlewareProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolNameAsString}.
     * </p>
     * 
     * @return The protocol name of the vehicle middleware.
     * @see VehicleMiddlewareProtocol
     */
    public final String protocolNameAsString() {
        return protocolName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(protocolNameAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VehicleMiddleware)) {
            return false;
        }
        VehicleMiddleware other = (VehicleMiddleware) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(protocolNameAsString(), other.protocolNameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VehicleMiddleware").add("Name", name()).add("ProtocolName", protocolNameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "protocolName":
            return Optional.ofNullable(clazz.cast(protocolNameAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VehicleMiddleware, T> g) {
        return obj -> g.apply((VehicleMiddleware) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VehicleMiddleware> {
        /**
         * <p>
         * The name of the vehicle middleware.
         * </p>
         * 
         * @param name
         *        The name of the vehicle middleware.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The protocol name of the vehicle middleware.
         * </p>
         * 
         * @param protocolName
         *        The protocol name of the vehicle middleware.
         * @see VehicleMiddlewareProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VehicleMiddlewareProtocol
         */
        Builder protocolName(String protocolName);

        /**
         * <p>
         * The protocol name of the vehicle middleware.
         * </p>
         * 
         * @param protocolName
         *        The protocol name of the vehicle middleware.
         * @see VehicleMiddlewareProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VehicleMiddlewareProtocol
         */
        Builder protocolName(VehicleMiddlewareProtocol protocolName);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String protocolName;

        private BuilderImpl() {
        }

        private BuilderImpl(VehicleMiddleware model) {
            name(model.name);
            protocolName(model.protocolName);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProtocolName() {
            return protocolName;
        }

        public final void setProtocolName(String protocolName) {
            this.protocolName = protocolName;
        }

        @Override
        public final Builder protocolName(String protocolName) {
            this.protocolName = protocolName;
            return this;
        }

        @Override
        public final Builder protocolName(VehicleMiddlewareProtocol protocolName) {
            this.protocolName(protocolName == null ? null : protocolName.toString());
            return this;
        }

        @Override
        public VehicleMiddleware build() {
            return new VehicleMiddleware(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
