/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsecuretunneling;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.iotsecuretunneling.model.CloseTunnelRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.CloseTunnelResponse;
import software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelResponse;
import software.amazon.awssdk.services.iotsecuretunneling.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsResponse;
import software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelResponse;
import software.amazon.awssdk.services.iotsecuretunneling.model.RotateTunnelAccessTokenRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.RotateTunnelAccessTokenResponse;
import software.amazon.awssdk.services.iotsecuretunneling.model.TagResourceRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.TagResourceResponse;
import software.amazon.awssdk.services.iotsecuretunneling.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotsecuretunneling.paginators.ListTunnelsPublisher;

/**
 * Service client for accessing AWS IoT Secure Tunneling asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <fullname>IoT Secure Tunneling</fullname>
 * <p>
 * IoT Secure Tunneling creates remote connections to devices deployed in the field.
 * </p>
 * <p>
 * For more information about how IoT Secure Tunneling works, see <a
 * href="https://docs.aws.amazon.com/iot/latest/developerguide/secure-tunneling.html">IoT Secure Tunneling</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IoTSecureTunnelingAsyncClient extends SdkClient {
    String SERVICE_NAME = "IoTSecuredTunneling";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.tunneling.iot";

    /**
     * Create a {@link IoTSecureTunnelingAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IoTSecureTunnelingAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IoTSecureTunnelingAsyncClient}.
     */
    static IoTSecureTunnelingAsyncClientBuilder builder() {
        return new DefaultIoTSecureTunnelingAsyncClientBuilder();
    }

    /**
     * <p>
     * Closes a tunnel identified by the unique tunnel id. When a <code>CloseTunnel</code> request is received, we close
     * the WebSocket connections between the client and proxy server so no data can be transmitted.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CloseTunnel</a> action.
     * </p>
     *
     * @param closeTunnelRequest
     * @return A Java Future containing the result of the CloseTunnel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Thrown when an operation is attempted on a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.CloseTunnel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/CloseTunnel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CloseTunnelResponse> closeTunnel(CloseTunnelRequest closeTunnelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Closes a tunnel identified by the unique tunnel id. When a <code>CloseTunnel</code> request is received, we close
     * the WebSocket connections between the client and proxy server so no data can be transmitted.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CloseTunnel</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CloseTunnelRequest.Builder} avoiding the need to
     * create one manually via {@link CloseTunnelRequest#builder()}
     * </p>
     *
     * @param closeTunnelRequest
     *        A {@link Consumer} that will call methods on {@link CloseTunnelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CloseTunnel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Thrown when an operation is attempted on a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.CloseTunnel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/CloseTunnel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CloseTunnelResponse> closeTunnel(Consumer<CloseTunnelRequest.Builder> closeTunnelRequest) {
        return closeTunnel(CloseTunnelRequest.builder().applyMutation(closeTunnelRequest).build());
    }

    /**
     * <p>
     * Gets information about a tunnel identified by the unique tunnel id.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeTunnel</a> action.
     * </p>
     *
     * @param describeTunnelRequest
     * @return A Java Future containing the result of the DescribeTunnel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Thrown when an operation is attempted on a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.DescribeTunnel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/DescribeTunnel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTunnelResponse> describeTunnel(DescribeTunnelRequest describeTunnelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a tunnel identified by the unique tunnel id.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeTunnel</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTunnelRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTunnelRequest#builder()}
     * </p>
     *
     * @param describeTunnelRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTunnelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeTunnel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Thrown when an operation is attempted on a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.DescribeTunnel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/DescribeTunnel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTunnelResponse> describeTunnel(Consumer<DescribeTunnelRequest.Builder> describeTunnelRequest) {
        return describeTunnel(DescribeTunnelRequest.builder().applyMutation(describeTunnelRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Thrown when an operation is attempted on a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Thrown when an operation is attempted on a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * List all tunnels for an Amazon Web Services account. Tunnels are listed by creation time in descending order,
     * newer tunnels will be listed before older tunnels.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListTunnels</a> action.
     * </p>
     *
     * @param listTunnelsRequest
     * @return A Java Future containing the result of the ListTunnels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.ListTunnels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/ListTunnels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTunnelsResponse> listTunnels(ListTunnelsRequest listTunnelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tunnels for an Amazon Web Services account. Tunnels are listed by creation time in descending order,
     * newer tunnels will be listed before older tunnels.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListTunnels</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTunnelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTunnelsRequest#builder()}
     * </p>
     *
     * @param listTunnelsRequest
     *        A {@link Consumer} that will call methods on {@link ListTunnelsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTunnels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.ListTunnels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/ListTunnels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTunnelsResponse> listTunnels(Consumer<ListTunnelsRequest.Builder> listTunnelsRequest) {
        return listTunnels(ListTunnelsRequest.builder().applyMutation(listTunnelsRequest).build());
    }

    /**
     * <p>
     * List all tunnels for an Amazon Web Services account. Tunnels are listed by creation time in descending order,
     * newer tunnels will be listed before older tunnels.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListTunnels</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTunnels(software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsecuretunneling.paginators.ListTunnelsPublisher publisher = client.listTunnelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsecuretunneling.paginators.ListTunnelsPublisher publisher = client.listTunnelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTunnels(software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest)} operation.</b>
     * </p>
     *
     * @param listTunnelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.ListTunnels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/ListTunnels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTunnelsPublisher listTunnelsPaginator(ListTunnelsRequest listTunnelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tunnels for an Amazon Web Services account. Tunnels are listed by creation time in descending order,
     * newer tunnels will be listed before older tunnels.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListTunnels</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTunnels(software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsecuretunneling.paginators.ListTunnelsPublisher publisher = client.listTunnelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotsecuretunneling.paginators.ListTunnelsPublisher publisher = client.listTunnelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTunnels(software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTunnelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTunnelsRequest#builder()}
     * </p>
     *
     * @param listTunnelsRequest
     *        A {@link Consumer} that will call methods on {@link ListTunnelsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.ListTunnels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/ListTunnels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTunnelsPublisher listTunnelsPaginator(Consumer<ListTunnelsRequest.Builder> listTunnelsRequest) {
        return listTunnelsPaginator(ListTunnelsRequest.builder().applyMutation(listTunnelsRequest).build());
    }

    /**
     * <p>
     * Creates a new tunnel, and returns two client access tokens for clients to use to connect to the IoT Secure
     * Tunneling proxy server.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >OpenTunnel</a> action.
     * </p>
     *
     * @param openTunnelRequest
     * @return A Java Future containing the result of the OpenTunnel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Thrown when a tunnel limit is exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.OpenTunnel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/OpenTunnel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<OpenTunnelResponse> openTunnel(OpenTunnelRequest openTunnelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new tunnel, and returns two client access tokens for clients to use to connect to the IoT Secure
     * Tunneling proxy server.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >OpenTunnel</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OpenTunnelRequest.Builder} avoiding the need to
     * create one manually via {@link OpenTunnelRequest#builder()}
     * </p>
     *
     * @param openTunnelRequest
     *        A {@link Consumer} that will call methods on {@link OpenTunnelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the OpenTunnel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException Thrown when a tunnel limit is exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.OpenTunnel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/OpenTunnel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<OpenTunnelResponse> openTunnel(Consumer<OpenTunnelRequest.Builder> openTunnelRequest) {
        return openTunnel(OpenTunnelRequest.builder().applyMutation(openTunnelRequest).build());
    }

    /**
     * <p>
     * Revokes the current client access token (CAT) and returns new CAT for clients to use when reconnecting to secure
     * tunneling to access the same tunnel.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >RotateTunnelAccessToken</a> action.
     * </p>
     * <note>
     * <p>
     * Rotating the CAT doesn't extend the tunnel duration. For example, say the tunnel duration is 12 hours and the
     * tunnel has already been open for 4 hours. When you rotate the access tokens, the new tokens that are generated
     * can only be used for the remaining 8 hours.
     * </p>
     * </note>
     *
     * @param rotateTunnelAccessTokenRequest
     * @return A Java Future containing the result of the RotateTunnelAccessToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Thrown when an operation is attempted on a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.RotateTunnelAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/RotateTunnelAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RotateTunnelAccessTokenResponse> rotateTunnelAccessToken(
            RotateTunnelAccessTokenRequest rotateTunnelAccessTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes the current client access token (CAT) and returns new CAT for clients to use when reconnecting to secure
     * tunneling to access the same tunnel.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >RotateTunnelAccessToken</a> action.
     * </p>
     * <note>
     * <p>
     * Rotating the CAT doesn't extend the tunnel duration. For example, say the tunnel duration is 12 hours and the
     * tunnel has already been open for 4 hours. When you rotate the access tokens, the new tokens that are generated
     * can only be used for the remaining 8 hours.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RotateTunnelAccessTokenRequest.Builder} avoiding
     * the need to create one manually via {@link RotateTunnelAccessTokenRequest#builder()}
     * </p>
     *
     * @param rotateTunnelAccessTokenRequest
     *        A {@link Consumer} that will call methods on {@link RotateTunnelAccessTokenRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RotateTunnelAccessToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Thrown when an operation is attempted on a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.RotateTunnelAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/RotateTunnelAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RotateTunnelAccessTokenResponse> rotateTunnelAccessToken(
            Consumer<RotateTunnelAccessTokenRequest.Builder> rotateTunnelAccessTokenRequest) {
        return rotateTunnelAccessToken(RotateTunnelAccessTokenRequest.builder().applyMutation(rotateTunnelAccessTokenRequest)
                .build());
    }

    /**
     * <p>
     * A resource tag.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Thrown when an operation is attempted on a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A resource tag.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Thrown when an operation is attempted on a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Thrown when an operation is attempted on a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Thrown when an operation is attempted on a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTSecureTunnelingException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample IoTSecureTunnelingAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotsecuretunneling-2018-10-05/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }
}
