/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the tunnel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TunnelSummary implements SdkPojo, Serializable, ToCopyableBuilder<TunnelSummary.Builder, TunnelSummary> {
    private static final SdkField<String> TUNNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tunnelId").getter(getter(TunnelSummary::tunnelId)).setter(setter(Builder::tunnelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelId").build()).build();

    private static final SdkField<String> TUNNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tunnelArn").getter(getter(TunnelSummary::tunnelArn)).setter(setter(Builder::tunnelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TunnelSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(TunnelSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(TunnelSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(TunnelSummary::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TUNNEL_ID_FIELD,
            TUNNEL_ARN_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tunnelId;

    private final String tunnelArn;

    private final String status;

    private final String description;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private TunnelSummary(BuilderImpl builder) {
        this.tunnelId = builder.tunnelId;
        this.tunnelArn = builder.tunnelArn;
        this.status = builder.status;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The unique alpha-numeric identifier for the tunnel.
     * </p>
     * 
     * @return The unique alpha-numeric identifier for the tunnel.
     */
    public final String tunnelId() {
        return tunnelId;
    }

    /**
     * <p>
     * The Amazon Resource Name of the tunnel.
     * </p>
     * 
     * @return The Amazon Resource Name of the tunnel.
     */
    public final String tunnelArn() {
        return tunnelArn;
    }

    /**
     * <p>
     * The status of a tunnel. Valid values are: Open and Closed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TunnelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a tunnel. Valid values are: Open and Closed.
     * @see TunnelStatus
     */
    public final TunnelStatus status() {
        return TunnelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a tunnel. Valid values are: Open and Closed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TunnelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a tunnel. Valid values are: Open and Closed.
     * @see TunnelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A description of the tunnel.
     * </p>
     * 
     * @return A description of the tunnel.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time the tunnel was created.
     * </p>
     * 
     * @return The time the tunnel was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time the tunnel was last updated.
     * </p>
     * 
     * @return The time the tunnel was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tunnelId());
        hashCode = 31 * hashCode + Objects.hashCode(tunnelArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TunnelSummary)) {
            return false;
        }
        TunnelSummary other = (TunnelSummary) obj;
        return Objects.equals(tunnelId(), other.tunnelId()) && Objects.equals(tunnelArn(), other.tunnelArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TunnelSummary").add("TunnelId", tunnelId()).add("TunnelArn", tunnelArn())
                .add("Status", statusAsString()).add("Description", description()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tunnelId":
            return Optional.ofNullable(clazz.cast(tunnelId()));
        case "tunnelArn":
            return Optional.ofNullable(clazz.cast(tunnelArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TunnelSummary, T> g) {
        return obj -> g.apply((TunnelSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TunnelSummary> {
        /**
         * <p>
         * The unique alpha-numeric identifier for the tunnel.
         * </p>
         * 
         * @param tunnelId
         *        The unique alpha-numeric identifier for the tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelId(String tunnelId);

        /**
         * <p>
         * The Amazon Resource Name of the tunnel.
         * </p>
         * 
         * @param tunnelArn
         *        The Amazon Resource Name of the tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelArn(String tunnelArn);

        /**
         * <p>
         * The status of a tunnel. Valid values are: Open and Closed.
         * </p>
         * 
         * @param status
         *        The status of a tunnel. Valid values are: Open and Closed.
         * @see TunnelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TunnelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a tunnel. Valid values are: Open and Closed.
         * </p>
         * 
         * @param status
         *        The status of a tunnel. Valid values are: Open and Closed.
         * @see TunnelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TunnelStatus
         */
        Builder status(TunnelStatus status);

        /**
         * <p>
         * A description of the tunnel.
         * </p>
         * 
         * @param description
         *        A description of the tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time the tunnel was created.
         * </p>
         * 
         * @param createdAt
         *        The time the tunnel was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time the tunnel was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time the tunnel was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String tunnelId;

        private String tunnelArn;

        private String status;

        private String description;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(TunnelSummary model) {
            tunnelId(model.tunnelId);
            tunnelArn(model.tunnelArn);
            status(model.status);
            description(model.description);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getTunnelId() {
            return tunnelId;
        }

        public final void setTunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
        }

        @Override
        public final Builder tunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
            return this;
        }

        public final String getTunnelArn() {
            return tunnelArn;
        }

        public final void setTunnelArn(String tunnelArn) {
            this.tunnelArn = tunnelArn;
        }

        @Override
        public final Builder tunnelArn(String tunnelArn) {
            this.tunnelArn = tunnelArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TunnelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public TunnelSummary build() {
            return new TunnelSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
