/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a summary of a property associated with an asset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetPropertySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetPropertySummary.Builder, AssetPropertySummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AssetPropertySummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("alias")
            .getter(getter(AssetPropertySummary::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(AssetPropertySummary::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<PropertyNotification> NOTIFICATION_FIELD = SdkField
            .<PropertyNotification> builder(MarshallingType.SDK_POJO).memberName("notification")
            .getter(getter(AssetPropertySummary::notification)).setter(setter(Builder::notification))
            .constructor(PropertyNotification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notification").build()).build();

    private static final SdkField<String> ASSET_COMPOSITE_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetCompositeModelId").getter(getter(AssetPropertySummary::assetCompositeModelId))
            .setter(setter(Builder::assetCompositeModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ALIAS_FIELD,
            UNIT_FIELD, NOTIFICATION_FIELD, ASSET_COMPOSITE_MODEL_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String alias;

    private final String unit;

    private final PropertyNotification notification;

    private final String assetCompositeModelId;

    private AssetPropertySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.alias = builder.alias;
        this.unit = builder.unit;
        this.notification = builder.notification;
        this.assetCompositeModelId = builder.assetCompositeModelId;
    }

    /**
     * <p>
     * The ID of the property.
     * </p>
     * 
     * @return The ID of the property.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The alias that identifies the property, such as an OPC-UA server data stream path (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial
     * data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The alias that identifies the property, such as an OPC-UA server data stream path (for example,
     *         <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping
     *         industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The unit of measure (such as Newtons or RPM) of the asset property.
     * </p>
     * 
     * @return The unit of measure (such as Newtons or RPM) of the asset property.
     */
    public final String unit() {
        return unit;
    }

    /**
     * Returns the value of the Notification property for this object.
     * 
     * @return The value of the Notification property for this object.
     */
    public final PropertyNotification notification() {
        return notification;
    }

    /**
     * <p>
     * The ID of the composite model that contains the asset property.
     * </p>
     * 
     * @return The ID of the composite model that contains the asset property.
     */
    public final String assetCompositeModelId() {
        return assetCompositeModelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(notification());
        hashCode = 31 * hashCode + Objects.hashCode(assetCompositeModelId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetPropertySummary)) {
            return false;
        }
        AssetPropertySummary other = (AssetPropertySummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(alias(), other.alias()) && Objects.equals(unit(), other.unit())
                && Objects.equals(notification(), other.notification())
                && Objects.equals(assetCompositeModelId(), other.assetCompositeModelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetPropertySummary").add("Id", id()).add("Alias", alias()).add("Unit", unit())
                .add("Notification", notification()).add("AssetCompositeModelId", assetCompositeModelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "notification":
            return Optional.ofNullable(clazz.cast(notification()));
        case "assetCompositeModelId":
            return Optional.ofNullable(clazz.cast(assetCompositeModelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetPropertySummary, T> g) {
        return obj -> g.apply((AssetPropertySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetPropertySummary> {
        /**
         * <p>
         * The ID of the property.
         * </p>
         * 
         * @param id
         *        The ID of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The alias that identifies the property, such as an OPC-UA server data stream path (for example,
         * <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping industrial
         * data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param alias
         *        The alias that identifies the property, such as an OPC-UA server data stream path (for example,
         *        <code>/company/windfarm/3/turbine/7/temperature</code>). For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html">Mapping
         *        industrial data streams to asset properties</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The unit of measure (such as Newtons or RPM) of the asset property.
         * </p>
         * 
         * @param unit
         *        The unit of measure (such as Newtons or RPM) of the asset property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * Sets the value of the Notification property for this object.
         *
         * @param notification
         *        The new value for the Notification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(PropertyNotification notification);

        /**
         * Sets the value of the Notification property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PropertyNotification.Builder} avoiding
         * the need to create one manually via {@link PropertyNotification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PropertyNotification.Builder#build()} is called immediately and
         * its result is passed to {@link #notification(PropertyNotification)}.
         * 
         * @param notification
         *        a consumer that will call methods on {@link PropertyNotification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notification(PropertyNotification)
         */
        default Builder notification(Consumer<PropertyNotification.Builder> notification) {
            return notification(PropertyNotification.builder().applyMutation(notification).build());
        }

        /**
         * <p>
         * The ID of the composite model that contains the asset property.
         * </p>
         * 
         * @param assetCompositeModelId
         *        The ID of the composite model that contains the asset property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetCompositeModelId(String assetCompositeModelId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String alias;

        private String unit;

        private PropertyNotification notification;

        private String assetCompositeModelId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetPropertySummary model) {
            id(model.id);
            alias(model.alias);
            unit(model.unit);
            notification(model.notification);
            assetCompositeModelId(model.assetCompositeModelId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final PropertyNotification.Builder getNotification() {
            return notification != null ? notification.toBuilder() : null;
        }

        public final void setNotification(PropertyNotification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        @Override
        public final Builder notification(PropertyNotification notification) {
            this.notification = notification;
            return this;
        }

        public final String getAssetCompositeModelId() {
            return assetCompositeModelId;
        }

        public final void setAssetCompositeModelId(String assetCompositeModelId) {
            this.assetCompositeModelId = assetCompositeModelId;
        }

        @Override
        public final Builder assetCompositeModelId(String assetCompositeModelId) {
            this.assetCompositeModelId = assetCompositeModelId;
            return this;
        }

        @Override
        public AssetPropertySummary build() {
            return new AssetPropertySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
