/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A description of the column in the query results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnInfo implements SdkPojo, Serializable, ToCopyableBuilder<ColumnInfo.Builder, ColumnInfo> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ColumnInfo::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ColumnType> TYPE_FIELD = SdkField.<ColumnType> builder(MarshallingType.SDK_POJO)
            .memberName("type").getter(getter(ColumnInfo::type)).setter(setter(Builder::type)).constructor(ColumnType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final ColumnType type;

    private ColumnInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the column description.
     * </p>
     * 
     * @return The name of the column description.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the column description.
     * </p>
     * 
     * @return The type of the column description.
     */
    public final ColumnType type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnInfo)) {
            return false;
        }
        ColumnInfo other = (ColumnInfo) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnInfo").add("Name", name()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnInfo, T> g) {
        return obj -> g.apply((ColumnInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnInfo> {
        /**
         * <p>
         * The name of the column description.
         * </p>
         * 
         * @param name
         *        The name of the column description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the column description.
         * </p>
         * 
         * @param type
         *        The type of the column description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(ColumnType type);

        /**
         * <p>
         * The type of the column description.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnType.Builder} avoiding the need to
         * create one manually via {@link ColumnType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnType.Builder#build()} is called immediately and its result
         * is passed to {@link #type(ColumnType)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link ColumnType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(ColumnType)
         */
        default Builder type(Consumer<ColumnType.Builder> type) {
            return type(ColumnType.builder().applyMutation(type).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private ColumnType type;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnInfo model) {
            name(model.name);
            type(model.type);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ColumnType.Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        public final void setType(ColumnType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(ColumnType type) {
            this.type = type;
            return this;
        }

        @Override
        public ColumnInfo build() {
            return new ColumnInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
