/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssetRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<DescribeAssetRequest.Builder, DescribeAssetRequest> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(DescribeAssetRequest::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetId").build()).build();

    private static final SdkField<Boolean> EXCLUDE_PROPERTIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("excludeProperties").getter(getter(DescribeAssetRequest::excludeProperties))
            .setter(setter(Builder::excludeProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("excludeProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            EXCLUDE_PROPERTIES_FIELD));

    private final String assetId;

    private final Boolean excludeProperties;

    private DescribeAssetRequest(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.excludeProperties = builder.excludeProperties;
    }

    /**
     * <p>
     * The ID of the asset. This can be either the actual ID in UUID format, or else <code>externalId:</code> followed
     * by the external ID, if it has one. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The ID of the asset. This can be either the actual ID in UUID format, or else <code>externalId:</code>
     *         followed by the external ID, if it has one. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     *         >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * Whether or not to exclude asset properties from the response.
     * </p>
     * 
     * @return Whether or not to exclude asset properties from the response.
     */
    public final Boolean excludeProperties() {
        return excludeProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(excludeProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetRequest)) {
            return false;
        }
        DescribeAssetRequest other = (DescribeAssetRequest) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(excludeProperties(), other.excludeProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAssetRequest").add("AssetId", assetId()).add("ExcludeProperties", excludeProperties())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "excludeProperties":
            return Optional.ofNullable(clazz.cast(excludeProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetRequest, T> g) {
        return obj -> g.apply((DescribeAssetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAssetRequest> {
        /**
         * <p>
         * The ID of the asset. This can be either the actual ID in UUID format, or else <code>externalId:</code>
         * followed by the external ID, if it has one. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetId
         *        The ID of the asset. This can be either the actual ID in UUID format, or else <code>externalId:</code>
         *        followed by the external ID, if it has one. For more information, see <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         *        >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * Whether or not to exclude asset properties from the response.
         * </p>
         * 
         * @param excludeProperties
         *        Whether or not to exclude asset properties from the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeProperties(Boolean excludeProperties);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String assetId;

        private Boolean excludeProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetRequest model) {
            super(model);
            assetId(model.assetId);
            excludeProperties(model.excludeProperties);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final Boolean getExcludeProperties() {
            return excludeProperties;
        }

        public final void setExcludeProperties(Boolean excludeProperties) {
            this.excludeProperties = excludeProperties;
        }

        @Override
        public final Builder excludeProperties(Boolean excludeProperties) {
            this.excludeProperties = excludeProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAssetRequest build() {
            return new DescribeAssetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
