/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssetModelsRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<ListAssetModelsRequest.Builder, ListAssetModelsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAssetModelsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListAssetModelsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<List<String>> ASSET_MODEL_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("assetModelTypes")
            .getter(getter(ListAssetModelsRequest::assetModelTypesAsStrings))
            .setter(setter(Builder::assetModelTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assetModelTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, ASSET_MODEL_TYPES_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final List<String> assetModelTypes;

    private ListAssetModelsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.assetModelTypes = builder.assetModelTypes;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return for each paginated request.
     * </p>
     * <p>
     * Default: 50
     * </p>
     * 
     * @return The maximum number of results to return for each paginated request.</p>
     *         <p>
     *         Default: 50
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The type of asset model.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a component
     * in another asset model.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset models.
     * You can't create assets directly from this type of asset model.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetModelTypes} method.
     * </p>
     * 
     * @return The type of asset model.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a
     *         component in another asset model.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset
     *         models. You can't create assets directly from this type of asset model.
     *         </p>
     *         </li>
     */
    public final List<AssetModelType> assetModelTypes() {
        return ListAssetModelsTypeFilterCopier.copyStringToEnum(assetModelTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetModelTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssetModelTypes() {
        return assetModelTypes != null && !(assetModelTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of asset model.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a component
     * in another asset model.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset models.
     * You can't create assets directly from this type of asset model.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetModelTypes} method.
     * </p>
     * 
     * @return The type of asset model.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a
     *         component in another asset model.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset
     *         models. You can't create assets directly from this type of asset model.
     *         </p>
     *         </li>
     */
    public final List<String> assetModelTypesAsStrings() {
        return assetModelTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetModelTypes() ? assetModelTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetModelsRequest)) {
            return false;
        }
        ListAssetModelsRequest other = (ListAssetModelsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasAssetModelTypes() == other.hasAssetModelTypes()
                && Objects.equals(assetModelTypesAsStrings(), other.assetModelTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssetModelsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("AssetModelTypes", hasAssetModelTypes() ? assetModelTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "assetModelTypes":
            return Optional.ofNullable(clazz.cast(assetModelTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssetModelsRequest, T> g) {
        return obj -> g.apply((ListAssetModelsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAssetModelsRequest> {
        /**
         * <p>
         * The token to be used for the next set of paginated results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return for each paginated request.
         * </p>
         * <p>
         * Default: 50
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for each paginated request.</p>
         *        <p>
         *        Default: 50
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The type of asset model.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a
         * component in another asset model.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset
         * models. You can't create assets directly from this type of asset model.
         * </p>
         * </li>
         * </ul>
         * 
         * @param assetModelTypes
         *        The type of asset model.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as
         *        a component in another asset model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other
         *        asset models. You can't create assets directly from this type of asset model.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelTypesWithStrings(Collection<String> assetModelTypes);

        /**
         * <p>
         * The type of asset model.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a
         * component in another asset model.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset
         * models. You can't create assets directly from this type of asset model.
         * </p>
         * </li>
         * </ul>
         * 
         * @param assetModelTypes
         *        The type of asset model.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as
         *        a component in another asset model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other
         *        asset models. You can't create assets directly from this type of asset model.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelTypesWithStrings(String... assetModelTypes);

        /**
         * <p>
         * The type of asset model.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a
         * component in another asset model.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset
         * models. You can't create assets directly from this type of asset model.
         * </p>
         * </li>
         * </ul>
         * 
         * @param assetModelTypes
         *        The type of asset model.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as
         *        a component in another asset model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other
         *        asset models. You can't create assets directly from this type of asset model.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelTypes(Collection<AssetModelType> assetModelTypes);

        /**
         * <p>
         * The type of asset model.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a
         * component in another asset model.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset
         * models. You can't create assets directly from this type of asset model.
         * </p>
         * </li>
         * </ul>
         * 
         * @param assetModelTypes
         *        The type of asset model.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as
         *        a component in another asset model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other
         *        asset models. You can't create assets directly from this type of asset model.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelTypes(AssetModelType... assetModelTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private List<String> assetModelTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetModelsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            assetModelTypesWithStrings(model.assetModelTypes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getAssetModelTypes() {
            if (assetModelTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return assetModelTypes;
        }

        public final void setAssetModelTypes(Collection<String> assetModelTypes) {
            this.assetModelTypes = ListAssetModelsTypeFilterCopier.copy(assetModelTypes);
        }

        @Override
        public final Builder assetModelTypesWithStrings(Collection<String> assetModelTypes) {
            this.assetModelTypes = ListAssetModelsTypeFilterCopier.copy(assetModelTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelTypesWithStrings(String... assetModelTypes) {
            assetModelTypesWithStrings(Arrays.asList(assetModelTypes));
            return this;
        }

        @Override
        public final Builder assetModelTypes(Collection<AssetModelType> assetModelTypes) {
            this.assetModelTypes = ListAssetModelsTypeFilterCopier.copyEnumToString(assetModelTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelTypes(AssetModelType... assetModelTypes) {
            assetModelTypes(Arrays.asList(assetModelTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssetModelsRequest build() {
            return new ListAssetModelsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
