/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEntitiesRequest extends IoTThingsGraphRequest implements
        ToCopyableBuilder<GetEntitiesRequest.Builder, GetEntitiesRequest> {
    private static final SdkField<List<String>> IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ids")
            .getter(getter(GetEntitiesRequest::ids))
            .setter(setter(Builder::ids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> NAMESPACE_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("namespaceVersion").getter(getter(GetEntitiesRequest::namespaceVersion))
            .setter(setter(Builder::namespaceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDS_FIELD,
            NAMESPACE_VERSION_FIELD));

    private final List<String> ids;

    private final Long namespaceVersion;

    private GetEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.ids = builder.ids;
        this.namespaceVersion = builder.namespaceVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ids property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasIds() {
        return ids != null && !(ids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of entity IDs.
     * </p>
     * <p>
     * The IDs should be in the following format.
     * </p>
     * <p>
     * <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIds} method.
     * </p>
     * 
     * @return An array of entity IDs.</p>
     *         <p>
     *         The IDs should be in the following format.
     *         </p>
     *         <p>
     *         <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
     */
    public final List<String> ids() {
        return ids;
    }

    /**
     * <p>
     * The version of the user's namespace. Defaults to the latest version of the user's namespace.
     * </p>
     * 
     * @return The version of the user's namespace. Defaults to the latest version of the user's namespace.
     */
    public final Long namespaceVersion() {
        return namespaceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIds() ? ids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(namespaceVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEntitiesRequest)) {
            return false;
        }
        GetEntitiesRequest other = (GetEntitiesRequest) obj;
        return hasIds() == other.hasIds() && Objects.equals(ids(), other.ids())
                && Objects.equals(namespaceVersion(), other.namespaceVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEntitiesRequest").add("Ids", hasIds() ? ids() : null)
                .add("NamespaceVersion", namespaceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ids":
            return Optional.ofNullable(clazz.cast(ids()));
        case "namespaceVersion":
            return Optional.ofNullable(clazz.cast(namespaceVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEntitiesRequest, T> g) {
        return obj -> g.apply((GetEntitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetEntitiesRequest> {
        /**
         * <p>
         * An array of entity IDs.
         * </p>
         * <p>
         * The IDs should be in the following format.
         * </p>
         * <p>
         * <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
         * </p>
         * 
         * @param ids
         *        An array of entity IDs.</p>
         *        <p>
         *        The IDs should be in the following format.
         *        </p>
         *        <p>
         *        <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(Collection<String> ids);

        /**
         * <p>
         * An array of entity IDs.
         * </p>
         * <p>
         * The IDs should be in the following format.
         * </p>
         * <p>
         * <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
         * </p>
         * 
         * @param ids
         *        An array of entity IDs.</p>
         *        <p>
         *        The IDs should be in the following format.
         *        </p>
         *        <p>
         *        <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(String... ids);

        /**
         * <p>
         * The version of the user's namespace. Defaults to the latest version of the user's namespace.
         * </p>
         * 
         * @param namespaceVersion
         *        The version of the user's namespace. Defaults to the latest version of the user's namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceVersion(Long namespaceVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTThingsGraphRequest.BuilderImpl implements Builder {
        private List<String> ids = DefaultSdkAutoConstructList.getInstance();

        private Long namespaceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEntitiesRequest model) {
            super(model);
            ids(model.ids);
            namespaceVersion(model.namespaceVersion);
        }

        public final Collection<String> getIds() {
            if (ids instanceof SdkAutoConstructList) {
                return null;
            }
            return ids;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = UrnsCopier.copy(ids);
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = UrnsCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String... ids) {
            ids(Arrays.asList(ids));
            return this;
        }

        public final Long getNamespaceVersion() {
            return namespaceVersion;
        }

        public final void setNamespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
        }

        @Override
        public final Builder namespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEntitiesRequest build() {
            return new GetEntitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
