/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetComponentTypeResponse extends IoTTwinMakerResponse implements
        ToCopyableBuilder<GetComponentTypeResponse.Builder, GetComponentTypeResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetComponentTypeResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentTypeId").getter(getter(GetComponentTypeResponse::componentTypeId))
            .setter(setter(Builder::componentTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(GetComponentTypeResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetComponentTypeResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> EXTENDS_FROM_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("extendsFrom")
            .getter(getter(GetComponentTypeResponse::extendsFrom))
            .setter(setter(Builder::extendsFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extendsFrom").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, FunctionResponse>> FUNCTIONS_FIELD = SdkField
            .<Map<String, FunctionResponse>> builder(MarshallingType.MAP)
            .memberName("functions")
            .getter(getter(GetComponentTypeResponse::functions))
            .setter(setter(Builder::functions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FunctionResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(FunctionResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_ABSTRACT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isAbstract").getter(getter(GetComponentTypeResponse::isAbstract)).setter(setter(Builder::isAbstract))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAbstract").build()).build();

    private static final SdkField<Boolean> IS_SCHEMA_INITIALIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isSchemaInitialized").getter(getter(GetComponentTypeResponse::isSchemaInitialized))
            .setter(setter(Builder::isSchemaInitialized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSchemaInitialized").build())
            .build();

    private static final SdkField<Boolean> IS_SINGLETON_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isSingleton").getter(getter(GetComponentTypeResponse::isSingleton)).setter(setter(Builder::isSingleton))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSingleton").build()).build();

    private static final SdkField<Map<String, PropertyDefinitionResponse>> PROPERTY_DEFINITIONS_FIELD = SdkField
            .<Map<String, PropertyDefinitionResponse>> builder(MarshallingType.MAP)
            .memberName("propertyDefinitions")
            .getter(getter(GetComponentTypeResponse::propertyDefinitions))
            .setter(setter(Builder::propertyDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyDefinitions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PropertyDefinitionResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyDefinitionResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Status> STATUS_FIELD = SdkField.<Status> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(GetComponentTypeResponse::status)).setter(setter(Builder::status)).constructor(Status::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateDateTime").getter(getter(GetComponentTypeResponse::updateDateTime))
            .setter(setter(Builder::updateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(GetComponentTypeResponse::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            COMPONENT_TYPE_ID_FIELD, CREATION_DATE_TIME_FIELD, DESCRIPTION_FIELD, EXTENDS_FROM_FIELD, FUNCTIONS_FIELD,
            IS_ABSTRACT_FIELD, IS_SCHEMA_INITIALIZED_FIELD, IS_SINGLETON_FIELD, PROPERTY_DEFINITIONS_FIELD, STATUS_FIELD,
            UPDATE_DATE_TIME_FIELD, WORKSPACE_ID_FIELD));

    private final String arn;

    private final String componentTypeId;

    private final Instant creationDateTime;

    private final String description;

    private final List<String> extendsFrom;

    private final Map<String, FunctionResponse> functions;

    private final Boolean isAbstract;

    private final Boolean isSchemaInitialized;

    private final Boolean isSingleton;

    private final Map<String, PropertyDefinitionResponse> propertyDefinitions;

    private final Status status;

    private final Instant updateDateTime;

    private final String workspaceId;

    private GetComponentTypeResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.componentTypeId = builder.componentTypeId;
        this.creationDateTime = builder.creationDateTime;
        this.description = builder.description;
        this.extendsFrom = builder.extendsFrom;
        this.functions = builder.functions;
        this.isAbstract = builder.isAbstract;
        this.isSchemaInitialized = builder.isSchemaInitialized;
        this.isSingleton = builder.isSingleton;
        this.propertyDefinitions = builder.propertyDefinitions;
        this.status = builder.status;
        this.updateDateTime = builder.updateDateTime;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * The ARN of the component type.
     * </p>
     * 
     * @return The ARN of the component type.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the component type.
     * </p>
     * 
     * @return The ID of the component type.
     */
    public final String componentTypeId() {
        return componentTypeId;
    }

    /**
     * <p>
     * The date and time when the component type was created.
     * </p>
     * 
     * @return The date and time when the component type was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The description of the component type.
     * </p>
     * 
     * @return The description of the component type.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExtendsFrom property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExtendsFrom() {
        return extendsFrom != null && !(extendsFrom instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the parent component type that this component type extends.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExtendsFrom} method.
     * </p>
     * 
     * @return The name of the parent component type that this component type extends.
     */
    public final List<String> extendsFrom() {
        return extendsFrom;
    }

    /**
     * For responses, this returns true if the service returned a value for the Functions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFunctions() {
        return functions != null && !(functions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that maps strings to the functions in the component type. Each string in the mapping must be unique to
     * this object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctions} method.
     * </p>
     * 
     * @return An object that maps strings to the functions in the component type. Each string in the mapping must be
     *         unique to this object.
     */
    public final Map<String, FunctionResponse> functions() {
        return functions;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the component type is abstract.
     * </p>
     * 
     * @return A Boolean value that specifies whether the component type is abstract.
     */
    public final Boolean isAbstract() {
        return isAbstract;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the component type has a schema initializer and that the schema
     * initializer has run.
     * </p>
     * 
     * @return A Boolean value that specifies whether the component type has a schema initializer and that the schema
     *         initializer has run.
     */
    public final Boolean isSchemaInitialized() {
        return isSchemaInitialized;
    }

    /**
     * <p>
     * A Boolean value that specifies whether an entity can have more than one component of this type.
     * </p>
     * 
     * @return A Boolean value that specifies whether an entity can have more than one component of this type.
     */
    public final Boolean isSingleton() {
        return isSingleton;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyDefinitions() {
        return propertyDefinitions != null && !(propertyDefinitions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that maps strings to the property definitions in the component type. Each string in the mapping must be
     * unique to this object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyDefinitions} method.
     * </p>
     * 
     * @return An object that maps strings to the property definitions in the component type. Each string in the mapping
     *         must be unique to this object.
     */
    public final Map<String, PropertyDefinitionResponse> propertyDefinitions() {
        return propertyDefinitions;
    }

    /**
     * <p>
     * The current status of the component type.
     * </p>
     * 
     * @return The current status of the component type.
     */
    public final Status status() {
        return status;
    }

    /**
     * <p>
     * The date and time when the component was last updated.
     * </p>
     * 
     * @return The date and time when the component was last updated.
     */
    public final Instant updateDateTime() {
        return updateDateTime;
    }

    /**
     * <p>
     * The ID of the workspace that contains the component type.
     * </p>
     * 
     * @return The ID of the workspace that contains the component type.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasExtendsFrom() ? extendsFrom() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctions() ? functions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isAbstract());
        hashCode = 31 * hashCode + Objects.hashCode(isSchemaInitialized());
        hashCode = 31 * hashCode + Objects.hashCode(isSingleton());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyDefinitions() ? propertyDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComponentTypeResponse)) {
            return false;
        }
        GetComponentTypeResponse other = (GetComponentTypeResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(componentTypeId(), other.componentTypeId())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(description(), other.description()) && hasExtendsFrom() == other.hasExtendsFrom()
                && Objects.equals(extendsFrom(), other.extendsFrom()) && hasFunctions() == other.hasFunctions()
                && Objects.equals(functions(), other.functions()) && Objects.equals(isAbstract(), other.isAbstract())
                && Objects.equals(isSchemaInitialized(), other.isSchemaInitialized())
                && Objects.equals(isSingleton(), other.isSingleton())
                && hasPropertyDefinitions() == other.hasPropertyDefinitions()
                && Objects.equals(propertyDefinitions(), other.propertyDefinitions()) && Objects.equals(status(), other.status())
                && Objects.equals(updateDateTime(), other.updateDateTime()) && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetComponentTypeResponse").add("Arn", arn()).add("ComponentTypeId", componentTypeId())
                .add("CreationDateTime", creationDateTime()).add("Description", description())
                .add("ExtendsFrom", hasExtendsFrom() ? extendsFrom() : null)
                .add("Functions", hasFunctions() ? functions() : null).add("IsAbstract", isAbstract())
                .add("IsSchemaInitialized", isSchemaInitialized()).add("IsSingleton", isSingleton())
                .add("PropertyDefinitions", hasPropertyDefinitions() ? propertyDefinitions() : null).add("Status", status())
                .add("UpdateDateTime", updateDateTime()).add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "componentTypeId":
            return Optional.ofNullable(clazz.cast(componentTypeId()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "extendsFrom":
            return Optional.ofNullable(clazz.cast(extendsFrom()));
        case "functions":
            return Optional.ofNullable(clazz.cast(functions()));
        case "isAbstract":
            return Optional.ofNullable(clazz.cast(isAbstract()));
        case "isSchemaInitialized":
            return Optional.ofNullable(clazz.cast(isSchemaInitialized()));
        case "isSingleton":
            return Optional.ofNullable(clazz.cast(isSingleton()));
        case "propertyDefinitions":
            return Optional.ofNullable(clazz.cast(propertyDefinitions()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "updateDateTime":
            return Optional.ofNullable(clazz.cast(updateDateTime()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComponentTypeResponse, T> g) {
        return obj -> g.apply((GetComponentTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetComponentTypeResponse> {
        /**
         * <p>
         * The ARN of the component type.
         * </p>
         * 
         * @param arn
         *        The ARN of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the component type.
         * </p>
         * 
         * @param componentTypeId
         *        The ID of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTypeId(String componentTypeId);

        /**
         * <p>
         * The date and time when the component type was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time when the component type was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The description of the component type.
         * </p>
         * 
         * @param description
         *        The description of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the parent component type that this component type extends.
         * </p>
         * 
         * @param extendsFrom
         *        The name of the parent component type that this component type extends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendsFrom(Collection<String> extendsFrom);

        /**
         * <p>
         * The name of the parent component type that this component type extends.
         * </p>
         * 
         * @param extendsFrom
         *        The name of the parent component type that this component type extends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendsFrom(String... extendsFrom);

        /**
         * <p>
         * An object that maps strings to the functions in the component type. Each string in the mapping must be unique
         * to this object.
         * </p>
         * 
         * @param functions
         *        An object that maps strings to the functions in the component type. Each string in the mapping must be
         *        unique to this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functions(Map<String, FunctionResponse> functions);

        /**
         * <p>
         * A Boolean value that specifies whether the component type is abstract.
         * </p>
         * 
         * @param isAbstract
         *        A Boolean value that specifies whether the component type is abstract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAbstract(Boolean isAbstract);

        /**
         * <p>
         * A Boolean value that specifies whether the component type has a schema initializer and that the schema
         * initializer has run.
         * </p>
         * 
         * @param isSchemaInitialized
         *        A Boolean value that specifies whether the component type has a schema initializer and that the schema
         *        initializer has run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSchemaInitialized(Boolean isSchemaInitialized);

        /**
         * <p>
         * A Boolean value that specifies whether an entity can have more than one component of this type.
         * </p>
         * 
         * @param isSingleton
         *        A Boolean value that specifies whether an entity can have more than one component of this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSingleton(Boolean isSingleton);

        /**
         * <p>
         * An object that maps strings to the property definitions in the component type. Each string in the mapping
         * must be unique to this object.
         * </p>
         * 
         * @param propertyDefinitions
         *        An object that maps strings to the property definitions in the component type. Each string in the
         *        mapping must be unique to this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyDefinitions(Map<String, PropertyDefinitionResponse> propertyDefinitions);

        /**
         * <p>
         * The current status of the component type.
         * </p>
         * 
         * @param status
         *        The current status of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Status status);

        /**
         * <p>
         * The current status of the component type.
         * </p>
         * This is a convenience method that creates an instance of the {@link Status.Builder} avoiding the need to
         * create one manually via {@link Status#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Status.Builder#build()} is called immediately and its result is
         * passed to {@link #status(Status)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link Status.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(Status)
         */
        default Builder status(Consumer<Status.Builder> status) {
            return status(Status.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The date and time when the component was last updated.
         * </p>
         * 
         * @param updateDateTime
         *        The date and time when the component was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDateTime(Instant updateDateTime);

        /**
         * <p>
         * The ID of the workspace that contains the component type.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace that contains the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);
    }

    static final class BuilderImpl extends IoTTwinMakerResponse.BuilderImpl implements Builder {
        private String arn;

        private String componentTypeId;

        private Instant creationDateTime;

        private String description;

        private List<String> extendsFrom = DefaultSdkAutoConstructList.getInstance();

        private Map<String, FunctionResponse> functions = DefaultSdkAutoConstructMap.getInstance();

        private Boolean isAbstract;

        private Boolean isSchemaInitialized;

        private Boolean isSingleton;

        private Map<String, PropertyDefinitionResponse> propertyDefinitions = DefaultSdkAutoConstructMap.getInstance();

        private Status status;

        private Instant updateDateTime;

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComponentTypeResponse model) {
            super(model);
            arn(model.arn);
            componentTypeId(model.componentTypeId);
            creationDateTime(model.creationDateTime);
            description(model.description);
            extendsFrom(model.extendsFrom);
            functions(model.functions);
            isAbstract(model.isAbstract);
            isSchemaInitialized(model.isSchemaInitialized);
            isSingleton(model.isSingleton);
            propertyDefinitions(model.propertyDefinitions);
            status(model.status);
            updateDateTime(model.updateDateTime);
            workspaceId(model.workspaceId);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getComponentTypeId() {
            return componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getExtendsFrom() {
            if (extendsFrom instanceof SdkAutoConstructList) {
                return null;
            }
            return extendsFrom;
        }

        public final void setExtendsFrom(Collection<String> extendsFrom) {
            this.extendsFrom = ExtendsFromCopier.copy(extendsFrom);
        }

        @Override
        public final Builder extendsFrom(Collection<String> extendsFrom) {
            this.extendsFrom = ExtendsFromCopier.copy(extendsFrom);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendsFrom(String... extendsFrom) {
            extendsFrom(Arrays.asList(extendsFrom));
            return this;
        }

        public final Map<String, FunctionResponse.Builder> getFunctions() {
            Map<String, FunctionResponse.Builder> result = FunctionsResponseCopier.copyToBuilder(this.functions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFunctions(Map<String, FunctionResponse.BuilderImpl> functions) {
            this.functions = FunctionsResponseCopier.copyFromBuilder(functions);
        }

        @Override
        public final Builder functions(Map<String, FunctionResponse> functions) {
            this.functions = FunctionsResponseCopier.copy(functions);
            return this;
        }

        public final Boolean getIsAbstract() {
            return isAbstract;
        }

        public final void setIsAbstract(Boolean isAbstract) {
            this.isAbstract = isAbstract;
        }

        @Override
        public final Builder isAbstract(Boolean isAbstract) {
            this.isAbstract = isAbstract;
            return this;
        }

        public final Boolean getIsSchemaInitialized() {
            return isSchemaInitialized;
        }

        public final void setIsSchemaInitialized(Boolean isSchemaInitialized) {
            this.isSchemaInitialized = isSchemaInitialized;
        }

        @Override
        public final Builder isSchemaInitialized(Boolean isSchemaInitialized) {
            this.isSchemaInitialized = isSchemaInitialized;
            return this;
        }

        public final Boolean getIsSingleton() {
            return isSingleton;
        }

        public final void setIsSingleton(Boolean isSingleton) {
            this.isSingleton = isSingleton;
        }

        @Override
        public final Builder isSingleton(Boolean isSingleton) {
            this.isSingleton = isSingleton;
            return this;
        }

        public final Map<String, PropertyDefinitionResponse.Builder> getPropertyDefinitions() {
            Map<String, PropertyDefinitionResponse.Builder> result = PropertyDefinitionsResponseCopier
                    .copyToBuilder(this.propertyDefinitions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyDefinitions(Map<String, PropertyDefinitionResponse.BuilderImpl> propertyDefinitions) {
            this.propertyDefinitions = PropertyDefinitionsResponseCopier.copyFromBuilder(propertyDefinitions);
        }

        @Override
        public final Builder propertyDefinitions(Map<String, PropertyDefinitionResponse> propertyDefinitions) {
            this.propertyDefinitions = PropertyDefinitionsResponseCopier.copy(propertyDefinitions);
            return this;
        }

        public final Status.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(Status.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(Status status) {
            this.status = status;
            return this;
        }

        public final Instant getUpdateDateTime() {
            return updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public GetComponentTypeResponse build() {
            return new GetComponentTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
