/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPropertyValueHistoryRequest extends IoTTwinMakerRequest implements
        ToCopyableBuilder<GetPropertyValueHistoryRequest.Builder, GetPropertyValueHistoryRequest> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentName").getter(getter(GetPropertyValueHistoryRequest::componentName))
            .setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()).build();

    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentTypeId").getter(getter(GetPropertyValueHistoryRequest::componentTypeId))
            .setter(setter(Builder::componentTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()).build();

    private static final SdkField<Instant> END_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endDateTime").getter(getter(GetPropertyValueHistoryRequest::endDateTime))
            .setter(setter(Builder::endDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateTime").build()).build();

    private static final SdkField<String> END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endTime").getter(getter(GetPropertyValueHistoryRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(GetPropertyValueHistoryRequest::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<InterpolationParameters> INTERPOLATION_FIELD = SdkField
            .<InterpolationParameters> builder(MarshallingType.SDK_POJO).memberName("interpolation")
            .getter(getter(GetPropertyValueHistoryRequest::interpolation)).setter(setter(Builder::interpolation))
            .constructor(InterpolationParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interpolation").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(GetPropertyValueHistoryRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetPropertyValueHistoryRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> ORDER_BY_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orderByTime").getter(getter(GetPropertyValueHistoryRequest::orderByTimeAsString))
            .setter(setter(Builder::orderByTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderByTime").build()).build();

    private static final SdkField<List<PropertyFilter>> PROPERTY_FILTERS_FIELD = SdkField
            .<List<PropertyFilter>> builder(MarshallingType.LIST)
            .memberName("propertyFilters")
            .getter(getter(GetPropertyValueHistoryRequest::propertyFilters))
            .setter(setter(Builder::propertyFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PropertyFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SELECTED_PROPERTIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("selectedProperties")
            .getter(getter(GetPropertyValueHistoryRequest::selectedProperties))
            .setter(setter(Builder::selectedProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectedProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startDateTime").getter(getter(GetPropertyValueHistoryRequest::startDateTime))
            .setter(setter(Builder::startDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDateTime").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startTime").getter(getter(GetPropertyValueHistoryRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(GetPropertyValueHistoryRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD,
            COMPONENT_TYPE_ID_FIELD, END_DATE_TIME_FIELD, END_TIME_FIELD, ENTITY_ID_FIELD, INTERPOLATION_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ORDER_BY_TIME_FIELD, PROPERTY_FILTERS_FIELD, SELECTED_PROPERTIES_FIELD,
            START_DATE_TIME_FIELD, START_TIME_FIELD, WORKSPACE_ID_FIELD));

    private final String componentName;

    private final String componentTypeId;

    private final Instant endDateTime;

    private final String endTime;

    private final String entityId;

    private final InterpolationParameters interpolation;

    private final Integer maxResults;

    private final String nextToken;

    private final String orderByTime;

    private final List<PropertyFilter> propertyFilters;

    private final List<String> selectedProperties;

    private final Instant startDateTime;

    private final String startTime;

    private final String workspaceId;

    private GetPropertyValueHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.componentName = builder.componentName;
        this.componentTypeId = builder.componentTypeId;
        this.endDateTime = builder.endDateTime;
        this.endTime = builder.endTime;
        this.entityId = builder.entityId;
        this.interpolation = builder.interpolation;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.orderByTime = builder.orderByTime;
        this.propertyFilters = builder.propertyFilters;
        this.selectedProperties = builder.selectedProperties;
        this.startDateTime = builder.startDateTime;
        this.startTime = builder.startTime;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The ID of the component type.
     * </p>
     * 
     * @return The ID of the component type.
     */
    public final String componentTypeId() {
        return componentTypeId;
    }

    /**
     * <p>
     * The date and time of the latest property value to return.
     * </p>
     * 
     * @return The date and time of the latest property value to return.
     * @deprecated This field is deprecated and will throw an error in the future. Use endTime instead.
     */
    @Deprecated
    public final Instant endDateTime() {
        return endDateTime;
    }

    /**
     * <p>
     * The ISO8601 DateTime of the latest property value to return.
     * </p>
     * <p>
     * For more information about the ISO8601 DateTime format, see the data type <a
     * href="https://docs.aws.amazon.com/roci/latest/roci-api/API_PropertyValue.html">PropertyValue</a>.
     * </p>
     * 
     * @return The ISO8601 DateTime of the latest property value to return.</p>
     *         <p>
     *         For more information about the ISO8601 DateTime format, see the data type <a
     *         href="https://docs.aws.amazon.com/roci/latest/roci-api/API_PropertyValue.html">PropertyValue</a>.
     */
    public final String endTime() {
        return endTime;
    }

    /**
     * <p>
     * The ID of the entity.
     * </p>
     * 
     * @return The ID of the entity.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * An object that specifies the interpolation type and the interval over which to interpolate data.
     * </p>
     * 
     * @return An object that specifies the interpolation type and the interval over which to interpolate data.
     */
    public final InterpolationParameters interpolation() {
        return interpolation;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The string that specifies the next page of results.
     * </p>
     * 
     * @return The string that specifies the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The time direction to use in the result order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderByTime} will
     * return {@link OrderByTime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderByTimeAsString}.
     * </p>
     * 
     * @return The time direction to use in the result order.
     * @see OrderByTime
     */
    public final OrderByTime orderByTime() {
        return OrderByTime.fromValue(orderByTime);
    }

    /**
     * <p>
     * The time direction to use in the result order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderByTime} will
     * return {@link OrderByTime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderByTimeAsString}.
     * </p>
     * 
     * @return The time direction to use in the result order.
     * @see OrderByTime
     */
    public final String orderByTimeAsString() {
        return orderByTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyFilters() {
        return propertyFilters != null && !(propertyFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects that filter the property value history request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyFilters} method.
     * </p>
     * 
     * @return A list of objects that filter the property value history request.
     */
    public final List<PropertyFilter> propertyFilters() {
        return propertyFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectedProperties() {
        return selectedProperties != null && !(selectedProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of properties whose value histories the request retrieves.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedProperties} method.
     * </p>
     * 
     * @return A list of properties whose value histories the request retrieves.
     */
    public final List<String> selectedProperties() {
        return selectedProperties;
    }

    /**
     * <p>
     * The date and time of the earliest property value to return.
     * </p>
     * 
     * @return The date and time of the earliest property value to return.
     * @deprecated This field is deprecated and will throw an error in the future. Use startTime instead.
     */
    @Deprecated
    public final Instant startDateTime() {
        return startDateTime;
    }

    /**
     * <p>
     * The ISO8601 DateTime of the earliest property value to return.
     * </p>
     * <p>
     * For more information about the ISO8601 DateTime format, see the data type <a
     * href="https://docs.aws.amazon.com/roci/latest/roci-api/API_PropertyValue.html">PropertyValue</a>.
     * </p>
     * 
     * @return The ISO8601 DateTime of the earliest property value to return.</p>
     *         <p>
     *         For more information about the ISO8601 DateTime format, see the data type <a
     *         href="https://docs.aws.amazon.com/roci/latest/roci-api/API_PropertyValue.html">PropertyValue</a>.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * The ID of the workspace.
     * </p>
     * 
     * @return The ID of the workspace.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(interpolation());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(orderByTimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyFilters() ? propertyFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedProperties() ? selectedProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPropertyValueHistoryRequest)) {
            return false;
        }
        GetPropertyValueHistoryRequest other = (GetPropertyValueHistoryRequest) obj;
        return Objects.equals(componentName(), other.componentName())
                && Objects.equals(componentTypeId(), other.componentTypeId())
                && Objects.equals(endDateTime(), other.endDateTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(entityId(), other.entityId()) && Objects.equals(interpolation(), other.interpolation())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(orderByTimeAsString(), other.orderByTimeAsString())
                && hasPropertyFilters() == other.hasPropertyFilters()
                && Objects.equals(propertyFilters(), other.propertyFilters())
                && hasSelectedProperties() == other.hasSelectedProperties()
                && Objects.equals(selectedProperties(), other.selectedProperties())
                && Objects.equals(startDateTime(), other.startDateTime()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPropertyValueHistoryRequest").add("ComponentName", componentName())
                .add("ComponentTypeId", componentTypeId()).add("EndDateTime", endDateTime()).add("EndTime", endTime())
                .add("EntityId", entityId()).add("Interpolation", interpolation()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("OrderByTime", orderByTimeAsString())
                .add("PropertyFilters", hasPropertyFilters() ? propertyFilters() : null)
                .add("SelectedProperties", hasSelectedProperties() ? selectedProperties() : null)
                .add("StartDateTime", startDateTime()).add("StartTime", startTime()).add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "componentTypeId":
            return Optional.ofNullable(clazz.cast(componentTypeId()));
        case "endDateTime":
            return Optional.ofNullable(clazz.cast(endDateTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "interpolation":
            return Optional.ofNullable(clazz.cast(interpolation()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "orderByTime":
            return Optional.ofNullable(clazz.cast(orderByTimeAsString()));
        case "propertyFilters":
            return Optional.ofNullable(clazz.cast(propertyFilters()));
        case "selectedProperties":
            return Optional.ofNullable(clazz.cast(selectedProperties()));
        case "startDateTime":
            return Optional.ofNullable(clazz.cast(startDateTime()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPropertyValueHistoryRequest, T> g) {
        return obj -> g.apply((GetPropertyValueHistoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPropertyValueHistoryRequest> {
        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param componentName
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The ID of the component type.
         * </p>
         * 
         * @param componentTypeId
         *        The ID of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTypeId(String componentTypeId);

        /**
         * <p>
         * The date and time of the latest property value to return.
         * </p>
         * 
         * @param endDateTime
         *        The date and time of the latest property value to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This field is deprecated and will throw an error in the future. Use endTime instead.
         */
        @Deprecated
        Builder endDateTime(Instant endDateTime);

        /**
         * <p>
         * The ISO8601 DateTime of the latest property value to return.
         * </p>
         * <p>
         * For more information about the ISO8601 DateTime format, see the data type <a
         * href="https://docs.aws.amazon.com/roci/latest/roci-api/API_PropertyValue.html">PropertyValue</a>.
         * </p>
         * 
         * @param endTime
         *        The ISO8601 DateTime of the latest property value to return.</p>
         *        <p>
         *        For more information about the ISO8601 DateTime format, see the data type <a
         *        href="https://docs.aws.amazon.com/roci/latest/roci-api/API_PropertyValue.html">PropertyValue</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(String endTime);

        /**
         * <p>
         * The ID of the entity.
         * </p>
         * 
         * @param entityId
         *        The ID of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * An object that specifies the interpolation type and the interval over which to interpolate data.
         * </p>
         * 
         * @param interpolation
         *        An object that specifies the interpolation type and the interval over which to interpolate data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interpolation(InterpolationParameters interpolation);

        /**
         * <p>
         * An object that specifies the interpolation type and the interval over which to interpolate data.
         * </p>
         * This is a convenience method that creates an instance of the {@link InterpolationParameters.Builder} avoiding
         * the need to create one manually via {@link InterpolationParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InterpolationParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #interpolation(InterpolationParameters)}.
         * 
         * @param interpolation
         *        a consumer that will call methods on {@link InterpolationParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interpolation(InterpolationParameters)
         */
        default Builder interpolation(Consumer<InterpolationParameters.Builder> interpolation) {
            return interpolation(InterpolationParameters.builder().applyMutation(interpolation).build());
        }

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The string that specifies the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The string that specifies the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The time direction to use in the result order.
         * </p>
         * 
         * @param orderByTime
         *        The time direction to use in the result order.
         * @see OrderByTime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderByTime
         */
        Builder orderByTime(String orderByTime);

        /**
         * <p>
         * The time direction to use in the result order.
         * </p>
         * 
         * @param orderByTime
         *        The time direction to use in the result order.
         * @see OrderByTime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderByTime
         */
        Builder orderByTime(OrderByTime orderByTime);

        /**
         * <p>
         * A list of objects that filter the property value history request.
         * </p>
         * 
         * @param propertyFilters
         *        A list of objects that filter the property value history request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyFilters(Collection<PropertyFilter> propertyFilters);

        /**
         * <p>
         * A list of objects that filter the property value history request.
         * </p>
         * 
         * @param propertyFilters
         *        A list of objects that filter the property value history request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyFilters(PropertyFilter... propertyFilters);

        /**
         * <p>
         * A list of objects that filter the property value history request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iottwinmaker.model.PropertyFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iottwinmaker.model.PropertyFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iottwinmaker.model.PropertyFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #propertyFilters(List<PropertyFilter>)}.
         * 
         * @param propertyFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iottwinmaker.model.PropertyFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyFilters(java.util.Collection<PropertyFilter>)
         */
        Builder propertyFilters(Consumer<PropertyFilter.Builder>... propertyFilters);

        /**
         * <p>
         * A list of properties whose value histories the request retrieves.
         * </p>
         * 
         * @param selectedProperties
         *        A list of properties whose value histories the request retrieves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedProperties(Collection<String> selectedProperties);

        /**
         * <p>
         * A list of properties whose value histories the request retrieves.
         * </p>
         * 
         * @param selectedProperties
         *        A list of properties whose value histories the request retrieves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedProperties(String... selectedProperties);

        /**
         * <p>
         * The date and time of the earliest property value to return.
         * </p>
         * 
         * @param startDateTime
         *        The date and time of the earliest property value to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This field is deprecated and will throw an error in the future. Use startTime instead.
         */
        @Deprecated
        Builder startDateTime(Instant startDateTime);

        /**
         * <p>
         * The ISO8601 DateTime of the earliest property value to return.
         * </p>
         * <p>
         * For more information about the ISO8601 DateTime format, see the data type <a
         * href="https://docs.aws.amazon.com/roci/latest/roci-api/API_PropertyValue.html">PropertyValue</a>.
         * </p>
         * 
         * @param startTime
         *        The ISO8601 DateTime of the earliest property value to return.</p>
         *        <p>
         *        For more information about the ISO8601 DateTime format, see the data type <a
         *        href="https://docs.aws.amazon.com/roci/latest/roci-api/API_PropertyValue.html">PropertyValue</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * The ID of the workspace.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTTwinMakerRequest.BuilderImpl implements Builder {
        private String componentName;

        private String componentTypeId;

        private Instant endDateTime;

        private String endTime;

        private String entityId;

        private InterpolationParameters interpolation;

        private Integer maxResults;

        private String nextToken;

        private String orderByTime;

        private List<PropertyFilter> propertyFilters = DefaultSdkAutoConstructList.getInstance();

        private List<String> selectedProperties = DefaultSdkAutoConstructList.getInstance();

        private Instant startDateTime;

        private String startTime;

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPropertyValueHistoryRequest model) {
            super(model);
            componentName(model.componentName);
            componentTypeId(model.componentTypeId);
            endDateTime(model.endDateTime);
            endTime(model.endTime);
            entityId(model.entityId);
            interpolation(model.interpolation);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            orderByTime(model.orderByTime);
            propertyFilters(model.propertyFilters);
            selectedProperties(model.selectedProperties);
            startDateTime(model.startDateTime);
            startTime(model.startTime);
            workspaceId(model.workspaceId);
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentTypeId() {
            return componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        @Deprecated
        public final Instant getEndDateTime() {
            return endDateTime;
        }

        @Deprecated
        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        @Deprecated
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final String getEndTime() {
            return endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final InterpolationParameters.Builder getInterpolation() {
            return interpolation != null ? interpolation.toBuilder() : null;
        }

        public final void setInterpolation(InterpolationParameters.BuilderImpl interpolation) {
            this.interpolation = interpolation != null ? interpolation.build() : null;
        }

        @Override
        public final Builder interpolation(InterpolationParameters interpolation) {
            this.interpolation = interpolation;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOrderByTime() {
            return orderByTime;
        }

        public final void setOrderByTime(String orderByTime) {
            this.orderByTime = orderByTime;
        }

        @Override
        public final Builder orderByTime(String orderByTime) {
            this.orderByTime = orderByTime;
            return this;
        }

        @Override
        public final Builder orderByTime(OrderByTime orderByTime) {
            this.orderByTime(orderByTime == null ? null : orderByTime.toString());
            return this;
        }

        public final List<PropertyFilter.Builder> getPropertyFilters() {
            List<PropertyFilter.Builder> result = PropertyFiltersCopier.copyToBuilder(this.propertyFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertyFilters(Collection<PropertyFilter.BuilderImpl> propertyFilters) {
            this.propertyFilters = PropertyFiltersCopier.copyFromBuilder(propertyFilters);
        }

        @Override
        public final Builder propertyFilters(Collection<PropertyFilter> propertyFilters) {
            this.propertyFilters = PropertyFiltersCopier.copy(propertyFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyFilters(PropertyFilter... propertyFilters) {
            propertyFilters(Arrays.asList(propertyFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyFilters(Consumer<PropertyFilter.Builder>... propertyFilters) {
            propertyFilters(Stream.of(propertyFilters).map(c -> PropertyFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSelectedProperties() {
            if (selectedProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return selectedProperties;
        }

        public final void setSelectedProperties(Collection<String> selectedProperties) {
            this.selectedProperties = SelectedPropertyListCopier.copy(selectedProperties);
        }

        @Override
        public final Builder selectedProperties(Collection<String> selectedProperties) {
            this.selectedProperties = SelectedPropertyListCopier.copy(selectedProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedProperties(String... selectedProperties) {
            selectedProperties(Arrays.asList(selectedProperties));
            return this;
        }

        @Deprecated
        public final Instant getStartDateTime() {
            return startDateTime;
        }

        @Deprecated
        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        @Deprecated
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final String getStartTime() {
            return startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPropertyValueHistoryRequest build() {
            return new GetPropertyValueHistoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
