/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPropertyValueRequest extends IoTTwinMakerRequest implements
        ToCopyableBuilder<GetPropertyValueRequest.Builder, GetPropertyValueRequest> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentName").getter(getter(GetPropertyValueRequest::componentName))
            .setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()).build();

    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentTypeId").getter(getter(GetPropertyValueRequest::componentTypeId))
            .setter(setter(Builder::componentTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(GetPropertyValueRequest::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<List<String>> SELECTED_PROPERTIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("selectedProperties")
            .getter(getter(GetPropertyValueRequest::selectedProperties))
            .setter(setter(Builder::selectedProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectedProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(GetPropertyValueRequest::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD,
            COMPONENT_TYPE_ID_FIELD, ENTITY_ID_FIELD, SELECTED_PROPERTIES_FIELD, WORKSPACE_ID_FIELD));

    private final String componentName;

    private final String componentTypeId;

    private final String entityId;

    private final List<String> selectedProperties;

    private final String workspaceId;

    private GetPropertyValueRequest(BuilderImpl builder) {
        super(builder);
        this.componentName = builder.componentName;
        this.componentTypeId = builder.componentTypeId;
        this.entityId = builder.entityId;
        this.selectedProperties = builder.selectedProperties;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * <p>
     * The name of the component whose property values the operation returns.
     * </p>
     * 
     * @return The name of the component whose property values the operation returns.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The ID of the component type whose property values the operation returns.
     * </p>
     * 
     * @return The ID of the component type whose property values the operation returns.
     */
    public final String componentTypeId() {
        return componentTypeId;
    }

    /**
     * <p>
     * The ID of the entity whose property values the operation returns.
     * </p>
     * 
     * @return The ID of the entity whose property values the operation returns.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectedProperties() {
        return selectedProperties != null && !(selectedProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The properties whose values the operation returns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedProperties} method.
     * </p>
     * 
     * @return The properties whose values the operation returns.
     */
    public final List<String> selectedProperties() {
        return selectedProperties;
    }

    /**
     * <p>
     * The ID of the workspace whose values the operation returns.
     * </p>
     * 
     * @return The ID of the workspace whose values the operation returns.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedProperties() ? selectedProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPropertyValueRequest)) {
            return false;
        }
        GetPropertyValueRequest other = (GetPropertyValueRequest) obj;
        return Objects.equals(componentName(), other.componentName())
                && Objects.equals(componentTypeId(), other.componentTypeId()) && Objects.equals(entityId(), other.entityId())
                && hasSelectedProperties() == other.hasSelectedProperties()
                && Objects.equals(selectedProperties(), other.selectedProperties())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPropertyValueRequest").add("ComponentName", componentName())
                .add("ComponentTypeId", componentTypeId()).add("EntityId", entityId())
                .add("SelectedProperties", hasSelectedProperties() ? selectedProperties() : null)
                .add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "componentTypeId":
            return Optional.ofNullable(clazz.cast(componentTypeId()));
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "selectedProperties":
            return Optional.ofNullable(clazz.cast(selectedProperties()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPropertyValueRequest, T> g) {
        return obj -> g.apply((GetPropertyValueRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetPropertyValueRequest> {
        /**
         * <p>
         * The name of the component whose property values the operation returns.
         * </p>
         * 
         * @param componentName
         *        The name of the component whose property values the operation returns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The ID of the component type whose property values the operation returns.
         * </p>
         * 
         * @param componentTypeId
         *        The ID of the component type whose property values the operation returns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTypeId(String componentTypeId);

        /**
         * <p>
         * The ID of the entity whose property values the operation returns.
         * </p>
         * 
         * @param entityId
         *        The ID of the entity whose property values the operation returns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The properties whose values the operation returns.
         * </p>
         * 
         * @param selectedProperties
         *        The properties whose values the operation returns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedProperties(Collection<String> selectedProperties);

        /**
         * <p>
         * The properties whose values the operation returns.
         * </p>
         * 
         * @param selectedProperties
         *        The properties whose values the operation returns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedProperties(String... selectedProperties);

        /**
         * <p>
         * The ID of the workspace whose values the operation returns.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace whose values the operation returns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTTwinMakerRequest.BuilderImpl implements Builder {
        private String componentName;

        private String componentTypeId;

        private String entityId;

        private List<String> selectedProperties = DefaultSdkAutoConstructList.getInstance();

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPropertyValueRequest model) {
            super(model);
            componentName(model.componentName);
            componentTypeId(model.componentTypeId);
            entityId(model.entityId);
            selectedProperties(model.selectedProperties);
            workspaceId(model.workspaceId);
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentTypeId() {
            return componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final Collection<String> getSelectedProperties() {
            if (selectedProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return selectedProperties;
        }

        public final void setSelectedProperties(Collection<String> selectedProperties) {
            this.selectedProperties = SelectedPropertyListCopier.copy(selectedProperties);
        }

        @Override
        public final Builder selectedProperties(Collection<String> selectedProperties) {
            this.selectedProperties = SelectedPropertyListCopier.copy(selectedProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedProperties(String... selectedProperties) {
            selectedProperties(Arrays.asList(selectedProperties));
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPropertyValueRequest build() {
            return new GetPropertyValueRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
