/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that filters items in a list of component types.
 * </p>
 * <note>
 * <p>
 * Only one object is accepted as a valid input.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListComponentTypesFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListComponentTypesFilter.Builder, ListComponentTypesFilter> {
    private static final SdkField<String> EXTENDS_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("extendsFrom").getter(getter(ListComponentTypesFilter::extendsFrom)).setter(setter(Builder::extendsFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extendsFrom").build()).build();

    private static final SdkField<Boolean> IS_ABSTRACT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isAbstract").getter(getter(ListComponentTypesFilter::isAbstract)).setter(setter(Builder::isAbstract))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAbstract").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(ListComponentTypesFilter::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENDS_FROM_FIELD,
            IS_ABSTRACT_FIELD, NAMESPACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String extendsFrom;

    private final Boolean isAbstract;

    private final String namespace;

    private final Type type;

    private ListComponentTypesFilter(BuilderImpl builder) {
        this.extendsFrom = builder.extendsFrom;
        this.isAbstract = builder.isAbstract;
        this.namespace = builder.namespace;
        this.type = builder.type;
    }

    /**
     * <p>
     * The component type that the component types in the list extend.
     * </p>
     * 
     * @return The component type that the component types in the list extend.
     */
    public final String extendsFrom() {
        return extendsFrom;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the component types in the list are abstract.
     * </p>
     * 
     * @return A Boolean value that specifies whether the component types in the list are abstract.
     */
    public final Boolean isAbstract() {
        return isAbstract;
    }

    /**
     * <p>
     * The namespace to which the component types in the list belong.
     * </p>
     * 
     * @return The namespace to which the component types in the list belong.
     */
    public final String namespace() {
        return namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(extendsFrom());
        hashCode = 31 * hashCode + Objects.hashCode(isAbstract());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentTypesFilter)) {
            return false;
        }
        ListComponentTypesFilter other = (ListComponentTypesFilter) obj;
        return Objects.equals(extendsFrom(), other.extendsFrom()) && Objects.equals(isAbstract(), other.isAbstract())
                && Objects.equals(namespace(), other.namespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListComponentTypesFilter").add("ExtendsFrom", extendsFrom()).add("IsAbstract", isAbstract())
                .add("Namespace", namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "extendsFrom":
            return Optional.ofNullable(clazz.cast(extendsFrom()));
        case "isAbstract":
            return Optional.ofNullable(clazz.cast(isAbstract()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #extendsFrom()} initialized to the given value.
     *
     * <p>
     * The component type that the component types in the list extend.
     * </p>
     * 
     * @param extendsFrom
     *        The component type that the component types in the list extend.
     */
    public static ListComponentTypesFilter fromExtendsFrom(String extendsFrom) {
        return builder().extendsFrom(extendsFrom).build();
    }

    /**
     * Create an instance of this class with {@link #isAbstract()} initialized to the given value.
     *
     * <p>
     * A Boolean value that specifies whether the component types in the list are abstract.
     * </p>
     * 
     * @param isAbstract
     *        A Boolean value that specifies whether the component types in the list are abstract.
     */
    public static ListComponentTypesFilter fromIsAbstract(Boolean isAbstract) {
        return builder().isAbstract(isAbstract).build();
    }

    /**
     * Create an instance of this class with {@link #namespace()} initialized to the given value.
     *
     * <p>
     * The namespace to which the component types in the list belong.
     * </p>
     * 
     * @param namespace
     *        The namespace to which the component types in the list belong.
     */
    public static ListComponentTypesFilter fromNamespace(String namespace) {
        return builder().namespace(namespace).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListComponentTypesFilter, T> g) {
        return obj -> g.apply((ListComponentTypesFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListComponentTypesFilter> {
        /**
         * <p>
         * The component type that the component types in the list extend.
         * </p>
         * 
         * @param extendsFrom
         *        The component type that the component types in the list extend.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendsFrom(String extendsFrom);

        /**
         * <p>
         * A Boolean value that specifies whether the component types in the list are abstract.
         * </p>
         * 
         * @param isAbstract
         *        A Boolean value that specifies whether the component types in the list are abstract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAbstract(Boolean isAbstract);

        /**
         * <p>
         * The namespace to which the component types in the list belong.
         * </p>
         * 
         * @param namespace
         *        The namespace to which the component types in the list belong.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);
    }

    static final class BuilderImpl implements Builder {
        private String extendsFrom;

        private Boolean isAbstract;

        private String namespace;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ListComponentTypesFilter model) {
            extendsFrom(model.extendsFrom);
            isAbstract(model.isAbstract);
            namespace(model.namespace);
        }

        public final String getExtendsFrom() {
            return extendsFrom;
        }

        public final void setExtendsFrom(String extendsFrom) {
            Object oldValue = this.extendsFrom;
            this.extendsFrom = extendsFrom;
            handleUnionValueChange(Type.EXTENDS_FROM, oldValue, this.extendsFrom);
        }

        @Override
        public final Builder extendsFrom(String extendsFrom) {
            Object oldValue = this.extendsFrom;
            this.extendsFrom = extendsFrom;
            handleUnionValueChange(Type.EXTENDS_FROM, oldValue, this.extendsFrom);
            return this;
        }

        public final Boolean getIsAbstract() {
            return isAbstract;
        }

        public final void setIsAbstract(Boolean isAbstract) {
            Object oldValue = this.isAbstract;
            this.isAbstract = isAbstract;
            handleUnionValueChange(Type.IS_ABSTRACT, oldValue, this.isAbstract);
        }

        @Override
        public final Builder isAbstract(Boolean isAbstract) {
            Object oldValue = this.isAbstract;
            this.isAbstract = isAbstract;
            handleUnionValueChange(Type.IS_ABSTRACT, oldValue, this.isAbstract);
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            Object oldValue = this.namespace;
            this.namespace = namespace;
            handleUnionValueChange(Type.NAMESPACE, oldValue, this.namespace);
        }

        @Override
        public final Builder namespace(String namespace) {
            Object oldValue = this.namespace;
            this.namespace = namespace;
            handleUnionValueChange(Type.NAMESPACE, oldValue, this.namespace);
            return this;
        }

        @Override
        public ListComponentTypesFilter build() {
            return new ListComponentTypesFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ListComponentTypesFilter#type()
     */
    public enum Type {
        EXTENDS_FROM,

        IS_ABSTRACT,

        NAMESPACE,

        UNKNOWN_TO_SDK_VERSION
    }
}
