/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListScenesResponse extends IoTTwinMakerResponse implements
        ToCopyableBuilder<ListScenesResponse.Builder, ListScenesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListScenesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<SceneSummary>> SCENE_SUMMARIES_FIELD = SdkField
            .<List<SceneSummary>> builder(MarshallingType.LIST)
            .memberName("sceneSummaries")
            .getter(getter(ListScenesResponse::sceneSummaries))
            .setter(setter(Builder::sceneSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SceneSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SceneSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SCENE_SUMMARIES_FIELD));

    private final String nextToken;

    private final List<SceneSummary> sceneSummaries;

    private ListScenesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.sceneSummaries = builder.sceneSummaries;
    }

    /**
     * <p>
     * The string that specifies the next page of results.
     * </p>
     * 
     * @return The string that specifies the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SceneSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSceneSummaries() {
        return sceneSummaries != null && !(sceneSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects that contain information about the scenes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSceneSummaries} method.
     * </p>
     * 
     * @return A list of objects that contain information about the scenes.
     */
    public final List<SceneSummary> sceneSummaries() {
        return sceneSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSceneSummaries() ? sceneSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScenesResponse)) {
            return false;
        }
        ListScenesResponse other = (ListScenesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSceneSummaries() == other.hasSceneSummaries()
                && Objects.equals(sceneSummaries(), other.sceneSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListScenesResponse").add("NextToken", nextToken())
                .add("SceneSummaries", hasSceneSummaries() ? sceneSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sceneSummaries":
            return Optional.ofNullable(clazz.cast(sceneSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListScenesResponse, T> g) {
        return obj -> g.apply((ListScenesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListScenesResponse> {
        /**
         * <p>
         * The string that specifies the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The string that specifies the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of objects that contain information about the scenes.
         * </p>
         * 
         * @param sceneSummaries
         *        A list of objects that contain information about the scenes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sceneSummaries(Collection<SceneSummary> sceneSummaries);

        /**
         * <p>
         * A list of objects that contain information about the scenes.
         * </p>
         * 
         * @param sceneSummaries
         *        A list of objects that contain information about the scenes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sceneSummaries(SceneSummary... sceneSummaries);

        /**
         * <p>
         * A list of objects that contain information about the scenes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iottwinmaker.model.SceneSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iottwinmaker.model.SceneSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iottwinmaker.model.SceneSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #sceneSummaries(List<SceneSummary>)}.
         * 
         * @param sceneSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iottwinmaker.model.SceneSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sceneSummaries(java.util.Collection<SceneSummary>)
         */
        Builder sceneSummaries(Consumer<SceneSummary.Builder>... sceneSummaries);
    }

    static final class BuilderImpl extends IoTTwinMakerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SceneSummary> sceneSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListScenesResponse model) {
            super(model);
            nextToken(model.nextToken);
            sceneSummaries(model.sceneSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SceneSummary.Builder> getSceneSummaries() {
            List<SceneSummary.Builder> result = SceneSummariesCopier.copyToBuilder(this.sceneSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSceneSummaries(Collection<SceneSummary.BuilderImpl> sceneSummaries) {
            this.sceneSummaries = SceneSummariesCopier.copyFromBuilder(sceneSummaries);
        }

        @Override
        public final Builder sceneSummaries(Collection<SceneSummary> sceneSummaries) {
            this.sceneSummaries = SceneSummariesCopier.copy(sceneSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sceneSummaries(SceneSummary... sceneSummaries) {
            sceneSummaries(Arrays.asList(sceneSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sceneSummaries(Consumer<SceneSummary.Builder>... sceneSummaries) {
            sceneSummaries(Stream.of(sceneSummaries).map(c -> SceneSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListScenesResponse build() {
            return new ListScenesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
