/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains response data from a property definition request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyDefinitionResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<PropertyDefinitionResponse.Builder, PropertyDefinitionResponse> {
    private static final SdkField<Map<String, String>> CONFIGURATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("configuration")
            .getter(getter(PropertyDefinitionResponse::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<DataType> DATA_TYPE_FIELD = SdkField.<DataType> builder(MarshallingType.SDK_POJO)
            .memberName("dataType").getter(getter(PropertyDefinitionResponse::dataType)).setter(setter(Builder::dataType))
            .constructor(DataType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()).build();

    private static final SdkField<DataValue> DEFAULT_VALUE_FIELD = SdkField.<DataValue> builder(MarshallingType.SDK_POJO)
            .memberName("defaultValue").getter(getter(PropertyDefinitionResponse::defaultValue))
            .setter(setter(Builder::defaultValue)).constructor(DataValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final SdkField<Boolean> IS_EXTERNAL_ID_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isExternalId").getter(getter(PropertyDefinitionResponse::isExternalId))
            .setter(setter(Builder::isExternalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isExternalId").build()).build();

    private static final SdkField<Boolean> IS_FINAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isFinal").getter(getter(PropertyDefinitionResponse::isFinal)).setter(setter(Builder::isFinal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isFinal").build()).build();

    private static final SdkField<Boolean> IS_IMPORTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isImported").getter(getter(PropertyDefinitionResponse::isImported)).setter(setter(Builder::isImported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isImported").build()).build();

    private static final SdkField<Boolean> IS_INHERITED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isInherited").getter(getter(PropertyDefinitionResponse::isInherited))
            .setter(setter(Builder::isInherited))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isInherited").build()).build();

    private static final SdkField<Boolean> IS_REQUIRED_IN_ENTITY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isRequiredInEntity").getter(getter(PropertyDefinitionResponse::isRequiredInEntity))
            .setter(setter(Builder::isRequiredInEntity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRequiredInEntity").build())
            .build();

    private static final SdkField<Boolean> IS_STORED_EXTERNALLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isStoredExternally").getter(getter(PropertyDefinitionResponse::isStoredExternally))
            .setter(setter(Builder::isStoredExternally))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isStoredExternally").build())
            .build();

    private static final SdkField<Boolean> IS_TIME_SERIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isTimeSeries").getter(getter(PropertyDefinitionResponse::isTimeSeries))
            .setter(setter(Builder::isTimeSeries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isTimeSeries").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD,
            DATA_TYPE_FIELD, DEFAULT_VALUE_FIELD, IS_EXTERNAL_ID_FIELD, IS_FINAL_FIELD, IS_IMPORTED_FIELD, IS_INHERITED_FIELD,
            IS_REQUIRED_IN_ENTITY_FIELD, IS_STORED_EXTERNALLY_FIELD, IS_TIME_SERIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> configuration;

    private final DataType dataType;

    private final DataValue defaultValue;

    private final Boolean isExternalId;

    private final Boolean isFinal;

    private final Boolean isImported;

    private final Boolean isInherited;

    private final Boolean isRequiredInEntity;

    private final Boolean isStoredExternally;

    private final Boolean isTimeSeries;

    private PropertyDefinitionResponse(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.dataType = builder.dataType;
        this.defaultValue = builder.defaultValue;
        this.isExternalId = builder.isExternalId;
        this.isFinal = builder.isFinal;
        this.isImported = builder.isImported;
        this.isInherited = builder.isInherited;
        this.isRequiredInEntity = builder.isRequiredInEntity;
        this.isStoredExternally = builder.isStoredExternally;
        this.isTimeSeries = builder.isTimeSeries;
    }

    /**
     * For responses, this returns true if the service returned a value for the Configuration property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfiguration() {
        return configuration != null && !(configuration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A mapping that specifies configuration information about the property.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfiguration} method.
     * </p>
     * 
     * @return A mapping that specifies configuration information about the property.
     */
    public final Map<String, String> configuration() {
        return configuration;
    }

    /**
     * <p>
     * An object that contains information about the data type.
     * </p>
     * 
     * @return An object that contains information about the data type.
     */
    public final DataType dataType() {
        return dataType;
    }

    /**
     * <p>
     * An object that contains the default value.
     * </p>
     * 
     * @return An object that contains the default value.
     */
    public final DataValue defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the property ID comes from an external data store.
     * </p>
     * 
     * @return A Boolean value that specifies whether the property ID comes from an external data store.
     */
    public final Boolean isExternalId() {
        return isExternalId;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the property definition can be updated.
     * </p>
     * 
     * @return A Boolean value that specifies whether the property definition can be updated.
     */
    public final Boolean isFinal() {
        return isFinal;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the property definition is imported from an external data store.
     * </p>
     * 
     * @return A Boolean value that specifies whether the property definition is imported from an external data store.
     */
    public final Boolean isImported() {
        return isImported;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the property definition is inherited from a parent entity.
     * </p>
     * 
     * @return A Boolean value that specifies whether the property definition is inherited from a parent entity.
     */
    public final Boolean isInherited() {
        return isInherited;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the property is required in an entity.
     * </p>
     * 
     * @return A Boolean value that specifies whether the property is required in an entity.
     */
    public final Boolean isRequiredInEntity() {
        return isRequiredInEntity;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the property is stored externally.
     * </p>
     * 
     * @return A Boolean value that specifies whether the property is stored externally.
     */
    public final Boolean isStoredExternally() {
        return isStoredExternally;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the property consists of time series data.
     * </p>
     * 
     * @return A Boolean value that specifies whether the property consists of time series data.
     */
    public final Boolean isTimeSeries() {
        return isTimeSeries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasConfiguration() ? configuration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataType());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(isExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(isFinal());
        hashCode = 31 * hashCode + Objects.hashCode(isImported());
        hashCode = 31 * hashCode + Objects.hashCode(isInherited());
        hashCode = 31 * hashCode + Objects.hashCode(isRequiredInEntity());
        hashCode = 31 * hashCode + Objects.hashCode(isStoredExternally());
        hashCode = 31 * hashCode + Objects.hashCode(isTimeSeries());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyDefinitionResponse)) {
            return false;
        }
        PropertyDefinitionResponse other = (PropertyDefinitionResponse) obj;
        return hasConfiguration() == other.hasConfiguration() && Objects.equals(configuration(), other.configuration())
                && Objects.equals(dataType(), other.dataType()) && Objects.equals(defaultValue(), other.defaultValue())
                && Objects.equals(isExternalId(), other.isExternalId()) && Objects.equals(isFinal(), other.isFinal())
                && Objects.equals(isImported(), other.isImported()) && Objects.equals(isInherited(), other.isInherited())
                && Objects.equals(isRequiredInEntity(), other.isRequiredInEntity())
                && Objects.equals(isStoredExternally(), other.isStoredExternally())
                && Objects.equals(isTimeSeries(), other.isTimeSeries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertyDefinitionResponse").add("Configuration", hasConfiguration() ? configuration() : null)
                .add("DataType", dataType()).add("DefaultValue", defaultValue()).add("IsExternalId", isExternalId())
                .add("IsFinal", isFinal()).add("IsImported", isImported()).add("IsInherited", isInherited())
                .add("IsRequiredInEntity", isRequiredInEntity()).add("IsStoredExternally", isStoredExternally())
                .add("IsTimeSeries", isTimeSeries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "dataType":
            return Optional.ofNullable(clazz.cast(dataType()));
        case "defaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "isExternalId":
            return Optional.ofNullable(clazz.cast(isExternalId()));
        case "isFinal":
            return Optional.ofNullable(clazz.cast(isFinal()));
        case "isImported":
            return Optional.ofNullable(clazz.cast(isImported()));
        case "isInherited":
            return Optional.ofNullable(clazz.cast(isInherited()));
        case "isRequiredInEntity":
            return Optional.ofNullable(clazz.cast(isRequiredInEntity()));
        case "isStoredExternally":
            return Optional.ofNullable(clazz.cast(isStoredExternally()));
        case "isTimeSeries":
            return Optional.ofNullable(clazz.cast(isTimeSeries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyDefinitionResponse, T> g) {
        return obj -> g.apply((PropertyDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyDefinitionResponse> {
        /**
         * <p>
         * A mapping that specifies configuration information about the property.
         * </p>
         * 
         * @param configuration
         *        A mapping that specifies configuration information about the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Map<String, String> configuration);

        /**
         * <p>
         * An object that contains information about the data type.
         * </p>
         * 
         * @param dataType
         *        An object that contains information about the data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataType(DataType dataType);

        /**
         * <p>
         * An object that contains information about the data type.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataType.Builder} avoiding the need to
         * create one manually via {@link DataType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataType.Builder#build()} is called immediately and its result is
         * passed to {@link #dataType(DataType)}.
         * 
         * @param dataType
         *        a consumer that will call methods on {@link DataType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataType(DataType)
         */
        default Builder dataType(Consumer<DataType.Builder> dataType) {
            return dataType(DataType.builder().applyMutation(dataType).build());
        }

        /**
         * <p>
         * An object that contains the default value.
         * </p>
         * 
         * @param defaultValue
         *        An object that contains the default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(DataValue defaultValue);

        /**
         * <p>
         * An object that contains the default value.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataValue.Builder} avoiding the need to
         * create one manually via {@link DataValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataValue.Builder#build()} is called immediately and its result
         * is passed to {@link #defaultValue(DataValue)}.
         * 
         * @param defaultValue
         *        a consumer that will call methods on {@link DataValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultValue(DataValue)
         */
        default Builder defaultValue(Consumer<DataValue.Builder> defaultValue) {
            return defaultValue(DataValue.builder().applyMutation(defaultValue).build());
        }

        /**
         * <p>
         * A Boolean value that specifies whether the property ID comes from an external data store.
         * </p>
         * 
         * @param isExternalId
         *        A Boolean value that specifies whether the property ID comes from an external data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isExternalId(Boolean isExternalId);

        /**
         * <p>
         * A Boolean value that specifies whether the property definition can be updated.
         * </p>
         * 
         * @param isFinal
         *        A Boolean value that specifies whether the property definition can be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isFinal(Boolean isFinal);

        /**
         * <p>
         * A Boolean value that specifies whether the property definition is imported from an external data store.
         * </p>
         * 
         * @param isImported
         *        A Boolean value that specifies whether the property definition is imported from an external data
         *        store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isImported(Boolean isImported);

        /**
         * <p>
         * A Boolean value that specifies whether the property definition is inherited from a parent entity.
         * </p>
         * 
         * @param isInherited
         *        A Boolean value that specifies whether the property definition is inherited from a parent entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isInherited(Boolean isInherited);

        /**
         * <p>
         * A Boolean value that specifies whether the property is required in an entity.
         * </p>
         * 
         * @param isRequiredInEntity
         *        A Boolean value that specifies whether the property is required in an entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRequiredInEntity(Boolean isRequiredInEntity);

        /**
         * <p>
         * A Boolean value that specifies whether the property is stored externally.
         * </p>
         * 
         * @param isStoredExternally
         *        A Boolean value that specifies whether the property is stored externally.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isStoredExternally(Boolean isStoredExternally);

        /**
         * <p>
         * A Boolean value that specifies whether the property consists of time series data.
         * </p>
         * 
         * @param isTimeSeries
         *        A Boolean value that specifies whether the property consists of time series data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTimeSeries(Boolean isTimeSeries);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> configuration = DefaultSdkAutoConstructMap.getInstance();

        private DataType dataType;

        private DataValue defaultValue;

        private Boolean isExternalId;

        private Boolean isFinal;

        private Boolean isImported;

        private Boolean isInherited;

        private Boolean isRequiredInEntity;

        private Boolean isStoredExternally;

        private Boolean isTimeSeries;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyDefinitionResponse model) {
            configuration(model.configuration);
            dataType(model.dataType);
            defaultValue(model.defaultValue);
            isExternalId(model.isExternalId);
            isFinal(model.isFinal);
            isImported(model.isImported);
            isInherited(model.isInherited);
            isRequiredInEntity(model.isRequiredInEntity);
            isStoredExternally(model.isStoredExternally);
            isTimeSeries(model.isTimeSeries);
        }

        public final Map<String, String> getConfiguration() {
            if (configuration instanceof SdkAutoConstructMap) {
                return null;
            }
            return configuration;
        }

        public final void setConfiguration(Map<String, String> configuration) {
            this.configuration = ConfigurationCopier.copy(configuration);
        }

        @Override
        public final Builder configuration(Map<String, String> configuration) {
            this.configuration = ConfigurationCopier.copy(configuration);
            return this;
        }

        public final DataType.Builder getDataType() {
            return dataType != null ? dataType.toBuilder() : null;
        }

        public final void setDataType(DataType.BuilderImpl dataType) {
            this.dataType = dataType != null ? dataType.build() : null;
        }

        @Override
        public final Builder dataType(DataType dataType) {
            this.dataType = dataType;
            return this;
        }

        public final DataValue.Builder getDefaultValue() {
            return defaultValue != null ? defaultValue.toBuilder() : null;
        }

        public final void setDefaultValue(DataValue.BuilderImpl defaultValue) {
            this.defaultValue = defaultValue != null ? defaultValue.build() : null;
        }

        @Override
        public final Builder defaultValue(DataValue defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Boolean getIsExternalId() {
            return isExternalId;
        }

        public final void setIsExternalId(Boolean isExternalId) {
            this.isExternalId = isExternalId;
        }

        @Override
        public final Builder isExternalId(Boolean isExternalId) {
            this.isExternalId = isExternalId;
            return this;
        }

        public final Boolean getIsFinal() {
            return isFinal;
        }

        public final void setIsFinal(Boolean isFinal) {
            this.isFinal = isFinal;
        }

        @Override
        public final Builder isFinal(Boolean isFinal) {
            this.isFinal = isFinal;
            return this;
        }

        public final Boolean getIsImported() {
            return isImported;
        }

        public final void setIsImported(Boolean isImported) {
            this.isImported = isImported;
        }

        @Override
        public final Builder isImported(Boolean isImported) {
            this.isImported = isImported;
            return this;
        }

        public final Boolean getIsInherited() {
            return isInherited;
        }

        public final void setIsInherited(Boolean isInherited) {
            this.isInherited = isInherited;
        }

        @Override
        public final Builder isInherited(Boolean isInherited) {
            this.isInherited = isInherited;
            return this;
        }

        public final Boolean getIsRequiredInEntity() {
            return isRequiredInEntity;
        }

        public final void setIsRequiredInEntity(Boolean isRequiredInEntity) {
            this.isRequiredInEntity = isRequiredInEntity;
        }

        @Override
        public final Builder isRequiredInEntity(Boolean isRequiredInEntity) {
            this.isRequiredInEntity = isRequiredInEntity;
            return this;
        }

        public final Boolean getIsStoredExternally() {
            return isStoredExternally;
        }

        public final void setIsStoredExternally(Boolean isStoredExternally) {
            this.isStoredExternally = isStoredExternally;
        }

        @Override
        public final Builder isStoredExternally(Boolean isStoredExternally) {
            this.isStoredExternally = isStoredExternally;
            return this;
        }

        public final Boolean getIsTimeSeries() {
            return isTimeSeries;
        }

        public final void setIsTimeSeries(Boolean isTimeSeries) {
            this.isTimeSeries = isTimeSeries;
        }

        @Override
        public final Builder isTimeSeries(Boolean isTimeSeries) {
            this.isTimeSeries = isTimeSeries;
            return this;
        }

        @Override
        public PropertyDefinitionResponse build() {
            return new PropertyDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
