/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that filters items returned by a property request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyFilter implements SdkPojo, Serializable, ToCopyableBuilder<PropertyFilter.Builder, PropertyFilter> {
    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operator").getter(getter(PropertyFilter::operator)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()).build();

    private static final SdkField<String> PROPERTY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propertyName").getter(getter(PropertyFilter::propertyName)).setter(setter(Builder::propertyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyName").build()).build();

    private static final SdkField<DataValue> VALUE_FIELD = SdkField.<DataValue> builder(MarshallingType.SDK_POJO)
            .memberName("value").getter(getter(PropertyFilter::value)).setter(setter(Builder::value))
            .constructor(DataValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATOR_FIELD,
            PROPERTY_NAME_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String operator;

    private final String propertyName;

    private final DataValue value;

    private PropertyFilter(BuilderImpl builder) {
        this.operator = builder.operator;
        this.propertyName = builder.propertyName;
        this.value = builder.value;
    }

    /**
     * <p>
     * The operator associated with this property filter.
     * </p>
     * 
     * @return The operator associated with this property filter.
     */
    public final String operator() {
        return operator;
    }

    /**
     * <p>
     * The property name associated with this property filter.
     * </p>
     * 
     * @return The property name associated with this property filter.
     */
    public final String propertyName() {
        return propertyName;
    }

    /**
     * <p>
     * The value associated with this property filter.
     * </p>
     * 
     * @return The value associated with this property filter.
     */
    public final DataValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operator());
        hashCode = 31 * hashCode + Objects.hashCode(propertyName());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyFilter)) {
            return false;
        }
        PropertyFilter other = (PropertyFilter) obj;
        return Objects.equals(operator(), other.operator()) && Objects.equals(propertyName(), other.propertyName())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertyFilter").add("Operator", operator()).add("PropertyName", propertyName())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operator":
            return Optional.ofNullable(clazz.cast(operator()));
        case "propertyName":
            return Optional.ofNullable(clazz.cast(propertyName()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyFilter, T> g) {
        return obj -> g.apply((PropertyFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyFilter> {
        /**
         * <p>
         * The operator associated with this property filter.
         * </p>
         * 
         * @param operator
         *        The operator associated with this property filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operator(String operator);

        /**
         * <p>
         * The property name associated with this property filter.
         * </p>
         * 
         * @param propertyName
         *        The property name associated with this property filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyName(String propertyName);

        /**
         * <p>
         * The value associated with this property filter.
         * </p>
         * 
         * @param value
         *        The value associated with this property filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(DataValue value);

        /**
         * <p>
         * The value associated with this property filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataValue.Builder} avoiding the need to
         * create one manually via {@link DataValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataValue.Builder#build()} is called immediately and its result
         * is passed to {@link #value(DataValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link DataValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(DataValue)
         */
        default Builder value(Consumer<DataValue.Builder> value) {
            return value(DataValue.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String operator;

        private String propertyName;

        private DataValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyFilter model) {
            operator(model.operator);
            propertyName(model.propertyName);
            value(model.value);
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        public final String getPropertyName() {
            return propertyName;
        }

        public final void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public final Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public final DataValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(DataValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(DataValue value) {
            this.value = value;
            return this;
        }

        @Override
        public PropertyFilter build() {
            return new PropertyFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
