/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEntityResponse extends IoTTwinMakerResponse implements
        ToCopyableBuilder<UpdateEntityResponse.Builder, UpdateEntityResponse> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(UpdateEntityResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateDateTime").getter(getter(UpdateEntityResponse::updateDateTime))
            .setter(setter(Builder::updateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            UPDATE_DATE_TIME_FIELD));

    private final String state;

    private final Instant updateDateTime;

    private UpdateEntityResponse(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
        this.updateDateTime = builder.updateDateTime;
    }

    /**
     * <p>
     * The current state of the entity update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the entity update.
     * @see State
     */
    public final State state() {
        return State.fromValue(state);
    }

    /**
     * <p>
     * The current state of the entity update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the entity update.
     * @see State
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date and time when the entity was last updated.
     * </p>
     * 
     * @return The date and time when the entity was last updated.
     */
    public final Instant updateDateTime() {
        return updateDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEntityResponse)) {
            return false;
        }
        UpdateEntityResponse other = (UpdateEntityResponse) obj;
        return Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(updateDateTime(), other.updateDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEntityResponse").add("State", stateAsString()).add("UpdateDateTime", updateDateTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "updateDateTime":
            return Optional.ofNullable(clazz.cast(updateDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEntityResponse, T> g) {
        return obj -> g.apply((UpdateEntityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEntityResponse> {
        /**
         * <p>
         * The current state of the entity update.
         * </p>
         * 
         * @param state
         *        The current state of the entity update.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the entity update.
         * </p>
         * 
         * @param state
         *        The current state of the entity update.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(State state);

        /**
         * <p>
         * The date and time when the entity was last updated.
         * </p>
         * 
         * @param updateDateTime
         *        The date and time when the entity was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDateTime(Instant updateDateTime);
    }

    static final class BuilderImpl extends IoTTwinMakerResponse.BuilderImpl implements Builder {
        private String state;

        private Instant updateDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEntityResponse model) {
            super(model);
            state(model.state);
            updateDateTime(model.updateDateTime);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getUpdateDateTime() {
            return updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        @Override
        public UpdateEntityResponse build() {
            return new UpdateEntityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
