/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that sets information about the composite component update request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompositeComponentRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<CompositeComponentRequest.Builder, CompositeComponentRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CompositeComponentRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, PropertyRequest>> PROPERTIES_FIELD = SdkField
            .<Map<String, PropertyRequest>> builder(MarshallingType.MAP)
            .memberName("properties")
            .getter(getter(CompositeComponentRequest::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PropertyRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ComponentPropertyGroupRequest>> PROPERTY_GROUPS_FIELD = SdkField
            .<Map<String, ComponentPropertyGroupRequest>> builder(MarshallingType.MAP)
            .memberName("propertyGroups")
            .getter(getter(CompositeComponentRequest::propertyGroups))
            .setter(setter(Builder::propertyGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyGroups").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentPropertyGroupRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentPropertyGroupRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            PROPERTIES_FIELD, PROPERTY_GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final Map<String, PropertyRequest> properties;

    private final Map<String, ComponentPropertyGroupRequest> propertyGroups;

    private CompositeComponentRequest(BuilderImpl builder) {
        this.description = builder.description;
        this.properties = builder.properties;
        this.propertyGroups = builder.propertyGroups;
    }

    /**
     * <p>
     * The description of the component type.
     * </p>
     * 
     * @return The description of the component type.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This is an object that maps strings to the properties to set in the component type. Each string in the mapping
     * must be unique to this object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return This is an object that maps strings to the properties to set in the component type. Each string in the
     *         mapping must be unique to this object.
     */
    public final Map<String, PropertyRequest> properties() {
        return properties;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyGroups() {
        return propertyGroups != null && !(propertyGroups instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The property groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyGroups} method.
     * </p>
     * 
     * @return The property groups.
     */
    public final Map<String, ComponentPropertyGroupRequest> propertyGroups() {
        return propertyGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyGroups() ? propertyGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositeComponentRequest)) {
            return false;
        }
        CompositeComponentRequest other = (CompositeComponentRequest) obj;
        return Objects.equals(description(), other.description()) && hasProperties() == other.hasProperties()
                && Objects.equals(properties(), other.properties()) && hasPropertyGroups() == other.hasPropertyGroups()
                && Objects.equals(propertyGroups(), other.propertyGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompositeComponentRequest").add("Description", description())
                .add("Properties", hasProperties() ? properties() : null)
                .add("PropertyGroups", hasPropertyGroups() ? propertyGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "propertyGroups":
            return Optional.ofNullable(clazz.cast(propertyGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompositeComponentRequest, T> g) {
        return obj -> g.apply((CompositeComponentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompositeComponentRequest> {
        /**
         * <p>
         * The description of the component type.
         * </p>
         * 
         * @param description
         *        The description of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * This is an object that maps strings to the properties to set in the component type. Each string in the
         * mapping must be unique to this object.
         * </p>
         * 
         * @param properties
         *        This is an object that maps strings to the properties to set in the component type. Each string in the
         *        mapping must be unique to this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, PropertyRequest> properties);

        /**
         * <p>
         * The property groups.
         * </p>
         * 
         * @param propertyGroups
         *        The property groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyGroups(Map<String, ComponentPropertyGroupRequest> propertyGroups);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private Map<String, PropertyRequest> properties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ComponentPropertyGroupRequest> propertyGroups = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CompositeComponentRequest model) {
            description(model.description);
            properties(model.properties);
            propertyGroups(model.propertyGroups);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, PropertyRequest.Builder> getProperties() {
            Map<String, PropertyRequest.Builder> result = PropertyRequestsCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setProperties(Map<String, PropertyRequest.BuilderImpl> properties) {
            this.properties = PropertyRequestsCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Map<String, PropertyRequest> properties) {
            this.properties = PropertyRequestsCopier.copy(properties);
            return this;
        }

        public final Map<String, ComponentPropertyGroupRequest.Builder> getPropertyGroups() {
            Map<String, ComponentPropertyGroupRequest.Builder> result = ComponentPropertyGroupRequestsCopier
                    .copyToBuilder(this.propertyGroups);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyGroups(Map<String, ComponentPropertyGroupRequest.BuilderImpl> propertyGroups) {
            this.propertyGroups = ComponentPropertyGroupRequestsCopier.copyFromBuilder(propertyGroups);
        }

        @Override
        public final Builder propertyGroups(Map<String, ComponentPropertyGroupRequest> propertyGroups) {
            this.propertyGroups = ComponentPropertyGroupRequestsCopier.copy(propertyGroups);
            return this;
        }

        @Override
        public CompositeComponentRequest build() {
            return new CompositeComponentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
