/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that returns information about a component summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentSummary.Builder, ComponentSummary> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentName").getter(getter(ComponentSummary::componentName)).setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()).build();

    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentTypeId").getter(getter(ComponentSummary::componentTypeId))
            .setter(setter(Builder::componentTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()).build();

    private static final SdkField<String> DEFINED_IN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definedIn").getter(getter(ComponentSummary::definedIn)).setter(setter(Builder::definedIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definedIn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ComponentSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, ComponentPropertyGroupResponse>> PROPERTY_GROUPS_FIELD = SdkField
            .<Map<String, ComponentPropertyGroupResponse>> builder(MarshallingType.MAP)
            .memberName("propertyGroups")
            .getter(getter(ComponentSummary::propertyGroups))
            .setter(setter(Builder::propertyGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyGroups").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComponentPropertyGroupResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentPropertyGroupResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Status> STATUS_FIELD = SdkField.<Status> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(ComponentSummary::status)).setter(setter(Builder::status)).constructor(Status::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SYNC_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("syncSource").getter(getter(ComponentSummary::syncSource)).setter(setter(Builder::syncSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncSource").build()).build();

    private static final SdkField<String> COMPONENT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentPath").getter(getter(ComponentSummary::componentPath)).setter(setter(Builder::componentPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD,
            COMPONENT_TYPE_ID_FIELD, DEFINED_IN_FIELD, DESCRIPTION_FIELD, PROPERTY_GROUPS_FIELD, STATUS_FIELD, SYNC_SOURCE_FIELD,
            COMPONENT_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String componentName;

    private final String componentTypeId;

    private final String definedIn;

    private final String description;

    private final Map<String, ComponentPropertyGroupResponse> propertyGroups;

    private final Status status;

    private final String syncSource;

    private final String componentPath;

    private ComponentSummary(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.componentTypeId = builder.componentTypeId;
        this.definedIn = builder.definedIn;
        this.description = builder.description;
        this.propertyGroups = builder.propertyGroups;
        this.status = builder.status;
        this.syncSource = builder.syncSource;
        this.componentPath = builder.componentPath;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The ID of the component type.
     * </p>
     * 
     * @return The ID of the component type.
     */
    public final String componentTypeId() {
        return componentTypeId;
    }

    /**
     * <p>
     * The name of the property definition set in the request.
     * </p>
     * 
     * @return The name of the property definition set in the request.
     */
    public final String definedIn() {
        return definedIn;
    }

    /**
     * <p>
     * The description of the component request.
     * </p>
     * 
     * @return The description of the component request.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyGroups() {
        return propertyGroups != null && !(propertyGroups instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The property groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyGroups} method.
     * </p>
     * 
     * @return The property groups.
     */
    public final Map<String, ComponentPropertyGroupResponse> propertyGroups() {
        return propertyGroups;
    }

    /**
     * <p>
     * The status of the component type.
     * </p>
     * 
     * @return The status of the component type.
     */
    public final Status status() {
        return status;
    }

    /**
     * <p>
     * The <code>syncSource</code> of the sync job, if this entity was created by a sync job.
     * </p>
     * 
     * @return The <code>syncSource</code> of the sync job, if this entity was created by a sync job.
     */
    public final String syncSource() {
        return syncSource;
    }

    /**
     * <p>
     * This string specifies the path to the composite component, starting from the top-level component.
     * </p>
     * 
     * @return This string specifies the path to the composite component, starting from the top-level component.
     */
    public final String componentPath() {
        return componentPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(definedIn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyGroups() ? propertyGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(syncSource());
        hashCode = 31 * hashCode + Objects.hashCode(componentPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentSummary)) {
            return false;
        }
        ComponentSummary other = (ComponentSummary) obj;
        return Objects.equals(componentName(), other.componentName())
                && Objects.equals(componentTypeId(), other.componentTypeId()) && Objects.equals(definedIn(), other.definedIn())
                && Objects.equals(description(), other.description()) && hasPropertyGroups() == other.hasPropertyGroups()
                && Objects.equals(propertyGroups(), other.propertyGroups()) && Objects.equals(status(), other.status())
                && Objects.equals(syncSource(), other.syncSource()) && Objects.equals(componentPath(), other.componentPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentSummary").add("ComponentName", componentName())
                .add("ComponentTypeId", componentTypeId()).add("DefinedIn", definedIn()).add("Description", description())
                .add("PropertyGroups", hasPropertyGroups() ? propertyGroups() : null).add("Status", status())
                .add("SyncSource", syncSource()).add("ComponentPath", componentPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "componentTypeId":
            return Optional.ofNullable(clazz.cast(componentTypeId()));
        case "definedIn":
            return Optional.ofNullable(clazz.cast(definedIn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "propertyGroups":
            return Optional.ofNullable(clazz.cast(propertyGroups()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "syncSource":
            return Optional.ofNullable(clazz.cast(syncSource()));
        case "componentPath":
            return Optional.ofNullable(clazz.cast(componentPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentSummary, T> g) {
        return obj -> g.apply((ComponentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentSummary> {
        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param componentName
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The ID of the component type.
         * </p>
         * 
         * @param componentTypeId
         *        The ID of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTypeId(String componentTypeId);

        /**
         * <p>
         * The name of the property definition set in the request.
         * </p>
         * 
         * @param definedIn
         *        The name of the property definition set in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definedIn(String definedIn);

        /**
         * <p>
         * The description of the component request.
         * </p>
         * 
         * @param description
         *        The description of the component request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The property groups.
         * </p>
         * 
         * @param propertyGroups
         *        The property groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyGroups(Map<String, ComponentPropertyGroupResponse> propertyGroups);

        /**
         * <p>
         * The status of the component type.
         * </p>
         * 
         * @param status
         *        The status of the component type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Status status);

        /**
         * <p>
         * The status of the component type.
         * </p>
         * This is a convenience method that creates an instance of the {@link Status.Builder} avoiding the need to
         * create one manually via {@link Status#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Status.Builder#build()} is called immediately and its result is
         * passed to {@link #status(Status)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link Status.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(Status)
         */
        default Builder status(Consumer<Status.Builder> status) {
            return status(Status.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The <code>syncSource</code> of the sync job, if this entity was created by a sync job.
         * </p>
         * 
         * @param syncSource
         *        The <code>syncSource</code> of the sync job, if this entity was created by a sync job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncSource(String syncSource);

        /**
         * <p>
         * This string specifies the path to the composite component, starting from the top-level component.
         * </p>
         * 
         * @param componentPath
         *        This string specifies the path to the composite component, starting from the top-level component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentPath(String componentPath);
    }

    static final class BuilderImpl implements Builder {
        private String componentName;

        private String componentTypeId;

        private String definedIn;

        private String description;

        private Map<String, ComponentPropertyGroupResponse> propertyGroups = DefaultSdkAutoConstructMap.getInstance();

        private Status status;

        private String syncSource;

        private String componentPath;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentSummary model) {
            componentName(model.componentName);
            componentTypeId(model.componentTypeId);
            definedIn(model.definedIn);
            description(model.description);
            propertyGroups(model.propertyGroups);
            status(model.status);
            syncSource(model.syncSource);
            componentPath(model.componentPath);
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentTypeId() {
            return componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final String getDefinedIn() {
            return definedIn;
        }

        public final void setDefinedIn(String definedIn) {
            this.definedIn = definedIn;
        }

        @Override
        public final Builder definedIn(String definedIn) {
            this.definedIn = definedIn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, ComponentPropertyGroupResponse.Builder> getPropertyGroups() {
            Map<String, ComponentPropertyGroupResponse.Builder> result = ComponentPropertyGroupResponsesCopier
                    .copyToBuilder(this.propertyGroups);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyGroups(Map<String, ComponentPropertyGroupResponse.BuilderImpl> propertyGroups) {
            this.propertyGroups = ComponentPropertyGroupResponsesCopier.copyFromBuilder(propertyGroups);
        }

        @Override
        public final Builder propertyGroups(Map<String, ComponentPropertyGroupResponse> propertyGroups) {
            this.propertyGroups = ComponentPropertyGroupResponsesCopier.copy(propertyGroups);
            return this;
        }

        public final Status.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(Status.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(Status status) {
            this.status = status;
            return this;
        }

        public final String getSyncSource() {
            return syncSource;
        }

        public final void setSyncSource(String syncSource) {
            this.syncSource = syncSource;
        }

        @Override
        public final Builder syncSource(String syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        public final String getComponentPath() {
            return componentPath;
        }

        public final void setComponentPath(String componentPath) {
            this.componentPath = componentPath;
        }

        @Override
        public final Builder componentPath(String componentPath) {
            this.componentPath = componentPath;
            return this;
        }

        @Override
        public ComponentSummary build() {
            return new ComponentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
