/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The FPorts for the position information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Positioning implements SdkPojo, Serializable, ToCopyableBuilder<Positioning.Builder, Positioning> {
    private static final SdkField<Integer> CLOCK_SYNC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ClockSync").getter(getter(Positioning::clockSync)).setter(setter(Builder::clockSync))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClockSync").build()).build();

    private static final SdkField<Integer> STREAM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Stream").getter(getter(Positioning::stream)).setter(setter(Builder::stream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stream").build()).build();

    private static final SdkField<Integer> GNSS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Gnss")
            .getter(getter(Positioning::gnss)).setter(setter(Builder::gnss))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gnss").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOCK_SYNC_FIELD,
            STREAM_FIELD, GNSS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer clockSync;

    private final Integer stream;

    private final Integer gnss;

    private Positioning(BuilderImpl builder) {
        this.clockSync = builder.clockSync;
        this.stream = builder.stream;
        this.gnss = builder.gnss;
    }

    /**
     * Returns the value of the ClockSync property for this object.
     * 
     * @return The value of the ClockSync property for this object.
     */
    public final Integer clockSync() {
        return clockSync;
    }

    /**
     * Returns the value of the Stream property for this object.
     * 
     * @return The value of the Stream property for this object.
     */
    public final Integer stream() {
        return stream;
    }

    /**
     * Returns the value of the Gnss property for this object.
     * 
     * @return The value of the Gnss property for this object.
     */
    public final Integer gnss() {
        return gnss;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clockSync());
        hashCode = 31 * hashCode + Objects.hashCode(stream());
        hashCode = 31 * hashCode + Objects.hashCode(gnss());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Positioning)) {
            return false;
        }
        Positioning other = (Positioning) obj;
        return Objects.equals(clockSync(), other.clockSync()) && Objects.equals(stream(), other.stream())
                && Objects.equals(gnss(), other.gnss());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Positioning").add("ClockSync", clockSync()).add("Stream", stream()).add("Gnss", gnss()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClockSync":
            return Optional.ofNullable(clazz.cast(clockSync()));
        case "Stream":
            return Optional.ofNullable(clazz.cast(stream()));
        case "Gnss":
            return Optional.ofNullable(clazz.cast(gnss()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Positioning, T> g) {
        return obj -> g.apply((Positioning) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Positioning> {
        /**
         * Sets the value of the ClockSync property for this object.
         *
         * @param clockSync
         *        The new value for the ClockSync property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clockSync(Integer clockSync);

        /**
         * Sets the value of the Stream property for this object.
         *
         * @param stream
         *        The new value for the Stream property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stream(Integer stream);

        /**
         * Sets the value of the Gnss property for this object.
         *
         * @param gnss
         *        The new value for the Gnss property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gnss(Integer gnss);
    }

    static final class BuilderImpl implements Builder {
        private Integer clockSync;

        private Integer stream;

        private Integer gnss;

        private BuilderImpl() {
        }

        private BuilderImpl(Positioning model) {
            clockSync(model.clockSync);
            stream(model.stream);
            gnss(model.gnss);
        }

        public final Integer getClockSync() {
            return clockSync;
        }

        public final void setClockSync(Integer clockSync) {
            this.clockSync = clockSync;
        }

        @Override
        public final Builder clockSync(Integer clockSync) {
            this.clockSync = clockSync;
            return this;
        }

        public final Integer getStream() {
            return stream;
        }

        public final void setStream(Integer stream) {
            this.stream = stream;
        }

        @Override
        public final Builder stream(Integer stream) {
            this.stream = stream;
            return this;
        }

        public final Integer getGnss() {
            return gnss;
        }

        public final void setGnss(Integer gnss) {
            this.gnss = gnss;
        }

        @Override
        public final Builder gnss(Integer gnss) {
            this.gnss = gnss;
            return this;
        }

        @Override
        public Positioning build() {
            return new Positioning(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
