/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * UpdateWirelessGatewayTaskCreate object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWirelessGatewayTaskCreate implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateWirelessGatewayTaskCreate.Builder, UpdateWirelessGatewayTaskCreate> {
    private static final SdkField<String> UPDATE_DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateDataSource").getter(getter(UpdateWirelessGatewayTaskCreate::updateDataSource))
            .setter(setter(Builder::updateDataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDataSource").build()).build();

    private static final SdkField<String> UPDATE_DATA_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateDataRole").getter(getter(UpdateWirelessGatewayTaskCreate::updateDataRole))
            .setter(setter(Builder::updateDataRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDataRole").build()).build();

    private static final SdkField<LoRaWANUpdateGatewayTaskCreate> LO_RA_WAN_FIELD = SdkField
            .<LoRaWANUpdateGatewayTaskCreate> builder(MarshallingType.SDK_POJO).memberName("LoRaWAN")
            .getter(getter(UpdateWirelessGatewayTaskCreate::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANUpdateGatewayTaskCreate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_DATA_SOURCE_FIELD,
            UPDATE_DATA_ROLE_FIELD, LO_RA_WAN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String updateDataSource;

    private final String updateDataRole;

    private final LoRaWANUpdateGatewayTaskCreate loRaWAN;

    private UpdateWirelessGatewayTaskCreate(BuilderImpl builder) {
        this.updateDataSource = builder.updateDataSource;
        this.updateDataRole = builder.updateDataRole;
        this.loRaWAN = builder.loRaWAN;
    }

    /**
     * <p>
     * The link to the S3 bucket.
     * </p>
     * 
     * @return The link to the S3 bucket.
     */
    public final String updateDataSource() {
        return updateDataSource;
    }

    /**
     * <p>
     * The IAM role used to read data from the S3 bucket.
     * </p>
     * 
     * @return The IAM role used to read data from the S3 bucket.
     */
    public final String updateDataRole() {
        return updateDataRole;
    }

    /**
     * <p>
     * The properties that relate to the LoRaWAN wireless gateway.
     * </p>
     * 
     * @return The properties that relate to the LoRaWAN wireless gateway.
     */
    public final LoRaWANUpdateGatewayTaskCreate loRaWAN() {
        return loRaWAN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(updateDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(updateDataRole());
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWirelessGatewayTaskCreate)) {
            return false;
        }
        UpdateWirelessGatewayTaskCreate other = (UpdateWirelessGatewayTaskCreate) obj;
        return Objects.equals(updateDataSource(), other.updateDataSource())
                && Objects.equals(updateDataRole(), other.updateDataRole()) && Objects.equals(loRaWAN(), other.loRaWAN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWirelessGatewayTaskCreate").add("UpdateDataSource", updateDataSource())
                .add("UpdateDataRole", updateDataRole()).add("LoRaWAN", loRaWAN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdateDataSource":
            return Optional.ofNullable(clazz.cast(updateDataSource()));
        case "UpdateDataRole":
            return Optional.ofNullable(clazz.cast(updateDataRole()));
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWirelessGatewayTaskCreate, T> g) {
        return obj -> g.apply((UpdateWirelessGatewayTaskCreate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateWirelessGatewayTaskCreate> {
        /**
         * <p>
         * The link to the S3 bucket.
         * </p>
         * 
         * @param updateDataSource
         *        The link to the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDataSource(String updateDataSource);

        /**
         * <p>
         * The IAM role used to read data from the S3 bucket.
         * </p>
         * 
         * @param updateDataRole
         *        The IAM role used to read data from the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDataRole(String updateDataRole);

        /**
         * <p>
         * The properties that relate to the LoRaWAN wireless gateway.
         * </p>
         * 
         * @param loRaWAN
         *        The properties that relate to the LoRaWAN wireless gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANUpdateGatewayTaskCreate loRaWAN);

        /**
         * <p>
         * The properties that relate to the LoRaWAN wireless gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoRaWANUpdateGatewayTaskCreate.Builder}
         * avoiding the need to create one manually via {@link LoRaWANUpdateGatewayTaskCreate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoRaWANUpdateGatewayTaskCreate.Builder#build()} is called
         * immediately and its result is passed to {@link #loRaWAN(LoRaWANUpdateGatewayTaskCreate)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANUpdateGatewayTaskCreate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANUpdateGatewayTaskCreate)
         */
        default Builder loRaWAN(Consumer<LoRaWANUpdateGatewayTaskCreate.Builder> loRaWAN) {
            return loRaWAN(LoRaWANUpdateGatewayTaskCreate.builder().applyMutation(loRaWAN).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String updateDataSource;

        private String updateDataRole;

        private LoRaWANUpdateGatewayTaskCreate loRaWAN;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWirelessGatewayTaskCreate model) {
            updateDataSource(model.updateDataSource);
            updateDataRole(model.updateDataRole);
            loRaWAN(model.loRaWAN);
        }

        public final String getUpdateDataSource() {
            return updateDataSource;
        }

        public final void setUpdateDataSource(String updateDataSource) {
            this.updateDataSource = updateDataSource;
        }

        @Override
        public final Builder updateDataSource(String updateDataSource) {
            this.updateDataSource = updateDataSource;
            return this;
        }

        public final String getUpdateDataRole() {
            return updateDataRole;
        }

        public final void setUpdateDataRole(String updateDataRole) {
            this.updateDataRole = updateDataRole;
        }

        @Override
        public final Builder updateDataRole(String updateDataRole) {
            this.updateDataRole = updateDataRole;
            return this;
        }

        public final LoRaWANUpdateGatewayTaskCreate.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANUpdateGatewayTaskCreate.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANUpdateGatewayTaskCreate loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        @Override
        public UpdateWirelessGatewayTaskCreate build() {
            return new UpdateWirelessGatewayTaskCreate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
