/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Session keys for ABP v1.1
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionKeysAbpV1_1 implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionKeysAbpV1_1.Builder, SessionKeysAbpV1_1> {
    private static final SdkField<String> F_NWK_S_INT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FNwkSIntKey").getter(getter(SessionKeysAbpV1_1::fNwkSIntKey)).setter(setter(Builder::fNwkSIntKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FNwkSIntKey").build()).build();

    private static final SdkField<String> S_NWK_S_INT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SNwkSIntKey").getter(getter(SessionKeysAbpV1_1::sNwkSIntKey)).setter(setter(Builder::sNwkSIntKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNwkSIntKey").build()).build();

    private static final SdkField<String> NWK_S_ENC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NwkSEncKey").getter(getter(SessionKeysAbpV1_1::nwkSEncKey)).setter(setter(Builder::nwkSEncKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NwkSEncKey").build()).build();

    private static final SdkField<String> APP_S_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppSKey").getter(getter(SessionKeysAbpV1_1::appSKey)).setter(setter(Builder::appSKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppSKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(F_NWK_S_INT_KEY_FIELD,
            S_NWK_S_INT_KEY_FIELD, NWK_S_ENC_KEY_FIELD, APP_S_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fNwkSIntKey;

    private final String sNwkSIntKey;

    private final String nwkSEncKey;

    private final String appSKey;

    private SessionKeysAbpV1_1(BuilderImpl builder) {
        this.fNwkSIntKey = builder.fNwkSIntKey;
        this.sNwkSIntKey = builder.sNwkSIntKey;
        this.nwkSEncKey = builder.nwkSEncKey;
        this.appSKey = builder.appSKey;
    }

    /**
     * <p>
     * The FNwkSIntKey value.
     * </p>
     * 
     * @return The FNwkSIntKey value.
     */
    public final String fNwkSIntKey() {
        return fNwkSIntKey;
    }

    /**
     * <p>
     * The SNwkSIntKey value.
     * </p>
     * 
     * @return The SNwkSIntKey value.
     */
    public final String sNwkSIntKey() {
        return sNwkSIntKey;
    }

    /**
     * <p>
     * The NwkSEncKey value.
     * </p>
     * 
     * @return The NwkSEncKey value.
     */
    public final String nwkSEncKey() {
        return nwkSEncKey;
    }

    /**
     * <p>
     * The AppSKey value.
     * </p>
     * 
     * @return The AppSKey value.
     */
    public final String appSKey() {
        return appSKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fNwkSIntKey());
        hashCode = 31 * hashCode + Objects.hashCode(sNwkSIntKey());
        hashCode = 31 * hashCode + Objects.hashCode(nwkSEncKey());
        hashCode = 31 * hashCode + Objects.hashCode(appSKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionKeysAbpV1_1)) {
            return false;
        }
        SessionKeysAbpV1_1 other = (SessionKeysAbpV1_1) obj;
        return Objects.equals(fNwkSIntKey(), other.fNwkSIntKey()) && Objects.equals(sNwkSIntKey(), other.sNwkSIntKey())
                && Objects.equals(nwkSEncKey(), other.nwkSEncKey()) && Objects.equals(appSKey(), other.appSKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionKeysAbpV1_1").add("FNwkSIntKey", fNwkSIntKey()).add("SNwkSIntKey", sNwkSIntKey())
                .add("NwkSEncKey", nwkSEncKey()).add("AppSKey", appSKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FNwkSIntKey":
            return Optional.ofNullable(clazz.cast(fNwkSIntKey()));
        case "SNwkSIntKey":
            return Optional.ofNullable(clazz.cast(sNwkSIntKey()));
        case "NwkSEncKey":
            return Optional.ofNullable(clazz.cast(nwkSEncKey()));
        case "AppSKey":
            return Optional.ofNullable(clazz.cast(appSKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionKeysAbpV1_1, T> g) {
        return obj -> g.apply((SessionKeysAbpV1_1) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionKeysAbpV1_1> {
        /**
         * <p>
         * The FNwkSIntKey value.
         * </p>
         * 
         * @param fNwkSIntKey
         *        The FNwkSIntKey value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fNwkSIntKey(String fNwkSIntKey);

        /**
         * <p>
         * The SNwkSIntKey value.
         * </p>
         * 
         * @param sNwkSIntKey
         *        The SNwkSIntKey value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sNwkSIntKey(String sNwkSIntKey);

        /**
         * <p>
         * The NwkSEncKey value.
         * </p>
         * 
         * @param nwkSEncKey
         *        The NwkSEncKey value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nwkSEncKey(String nwkSEncKey);

        /**
         * <p>
         * The AppSKey value.
         * </p>
         * 
         * @param appSKey
         *        The AppSKey value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appSKey(String appSKey);
    }

    static final class BuilderImpl implements Builder {
        private String fNwkSIntKey;

        private String sNwkSIntKey;

        private String nwkSEncKey;

        private String appSKey;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionKeysAbpV1_1 model) {
            fNwkSIntKey(model.fNwkSIntKey);
            sNwkSIntKey(model.sNwkSIntKey);
            nwkSEncKey(model.nwkSEncKey);
            appSKey(model.appSKey);
        }

        public final String getFNwkSIntKey() {
            return fNwkSIntKey;
        }

        public final void setFNwkSIntKey(String fNwkSIntKey) {
            this.fNwkSIntKey = fNwkSIntKey;
        }

        @Override
        public final Builder fNwkSIntKey(String fNwkSIntKey) {
            this.fNwkSIntKey = fNwkSIntKey;
            return this;
        }

        public final String getSNwkSIntKey() {
            return sNwkSIntKey;
        }

        public final void setSNwkSIntKey(String sNwkSIntKey) {
            this.sNwkSIntKey = sNwkSIntKey;
        }

        @Override
        public final Builder sNwkSIntKey(String sNwkSIntKey) {
            this.sNwkSIntKey = sNwkSIntKey;
            return this;
        }

        public final String getNwkSEncKey() {
            return nwkSEncKey;
        }

        public final void setNwkSEncKey(String nwkSEncKey) {
            this.nwkSEncKey = nwkSEncKey;
        }

        @Override
        public final Builder nwkSEncKey(String nwkSEncKey) {
            this.nwkSEncKey = nwkSEncKey;
            return this;
        }

        public final String getAppSKey() {
            return appSKey;
        }

        public final void setAppSKey(String appSKey) {
            this.appSKey = appSKey;
        }

        @Override
        public final Builder appSKey(String appSKey) {
            this.appSKey = appSKey;
            return this;
        }

        @Override
        public SessionKeysAbpV1_1 build() {
            return new SessionKeysAbpV1_1(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
