/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Complex data type that defines destination-configuration objects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationConfiguration.Builder, DestinationConfiguration> {
    private static final SdkField<ChannelDestinationConfiguration> CHANNEL_FIELD = SdkField
            .<ChannelDestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("channel")
            .getter(getter(DestinationConfiguration::channel)).setter(setter(Builder::channel))
            .constructor(ChannelDestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DestinationConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<S3DestinationConfiguration> S3_FIELD = SdkField
            .<S3DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("s3")
            .getter(getter(DestinationConfiguration::s3)).setter(setter(Builder::s3))
            .constructor(S3DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD, NAME_FIELD,
            S3_FIELD));

    private static final long serialVersionUID = 1L;

    private final ChannelDestinationConfiguration channel;

    private final String name;

    private final S3DestinationConfiguration s3;

    private DestinationConfiguration(BuilderImpl builder) {
        this.channel = builder.channel;
        this.name = builder.name;
        this.s3 = builder.s3;
    }

    /**
     * <p>
     * An IVS channel to be used for broadcasting, for server-side composition. Either a <code>channel</code> or an
     * <code>s3</code> must be specified.
     * </p>
     * 
     * @return An IVS channel to be used for broadcasting, for server-side composition. Either a <code>channel</code> or
     *         an <code>s3</code> must be specified.
     */
    public final ChannelDestinationConfiguration channel() {
        return channel;
    }

    /**
     * <p>
     * Name that can be specified to help identify the destination.
     * </p>
     * 
     * @return Name that can be specified to help identify the destination.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An S3 storage configuration to be used for recording video data. Either a <code>channel</code> or an
     * <code>s3</code> must be specified.
     * </p>
     * 
     * @return An S3 storage configuration to be used for recording video data. Either a <code>channel</code> or an
     *         <code>s3</code> must be specified.
     */
    public final S3DestinationConfiguration s3() {
        return s3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channel());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationConfiguration)) {
            return false;
        }
        DestinationConfiguration other = (DestinationConfiguration) obj;
        return Objects.equals(channel(), other.channel()) && Objects.equals(name(), other.name())
                && Objects.equals(s3(), other.s3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationConfiguration").add("Channel", channel()).add("Name", name()).add("S3", s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channel":
            return Optional.ofNullable(clazz.cast(channel()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "s3":
            return Optional.ofNullable(clazz.cast(s3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationConfiguration, T> g) {
        return obj -> g.apply((DestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationConfiguration> {
        /**
         * <p>
         * An IVS channel to be used for broadcasting, for server-side composition. Either a <code>channel</code> or an
         * <code>s3</code> must be specified.
         * </p>
         * 
         * @param channel
         *        An IVS channel to be used for broadcasting, for server-side composition. Either a <code>channel</code>
         *        or an <code>s3</code> must be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channel(ChannelDestinationConfiguration channel);

        /**
         * <p>
         * An IVS channel to be used for broadcasting, for server-side composition. Either a <code>channel</code> or an
         * <code>s3</code> must be specified.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChannelDestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link ChannelDestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChannelDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #channel(ChannelDestinationConfiguration)}.
         * 
         * @param channel
         *        a consumer that will call methods on {@link ChannelDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channel(ChannelDestinationConfiguration)
         */
        default Builder channel(Consumer<ChannelDestinationConfiguration.Builder> channel) {
            return channel(ChannelDestinationConfiguration.builder().applyMutation(channel).build());
        }

        /**
         * <p>
         * Name that can be specified to help identify the destination.
         * </p>
         * 
         * @param name
         *        Name that can be specified to help identify the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An S3 storage configuration to be used for recording video data. Either a <code>channel</code> or an
         * <code>s3</code> must be specified.
         * </p>
         * 
         * @param s3
         *        An S3 storage configuration to be used for recording video data. Either a <code>channel</code> or an
         *        <code>s3</code> must be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3DestinationConfiguration s3);

        /**
         * <p>
         * An S3 storage configuration to be used for recording video data. Either a <code>channel</code> or an
         * <code>s3</code> must be specified.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link S3DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3(S3DestinationConfiguration)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3DestinationConfiguration)
         */
        default Builder s3(Consumer<S3DestinationConfiguration.Builder> s3) {
            return s3(S3DestinationConfiguration.builder().applyMutation(s3).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ChannelDestinationConfiguration channel;

        private String name;

        private S3DestinationConfiguration s3;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationConfiguration model) {
            channel(model.channel);
            name(model.name);
            s3(model.s3);
        }

        public final ChannelDestinationConfiguration.Builder getChannel() {
            return channel != null ? channel.toBuilder() : null;
        }

        public final void setChannel(ChannelDestinationConfiguration.BuilderImpl channel) {
            this.channel = channel != null ? channel.build() : null;
        }

        @Override
        public final Builder channel(ChannelDestinationConfiguration channel) {
            this.channel = channel;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final S3DestinationConfiguration.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(S3DestinationConfiguration.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3DestinationConfiguration s3) {
            this.s3 = s3;
            return this;
        }

        @Override
        public DestinationConfiguration build() {
            return new DestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
