/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object specifying the status of a Destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Destination implements SdkPojo, Serializable, ToCopyableBuilder<Destination.Builder, Destination> {
    private static final SdkField<DestinationConfiguration> CONFIGURATION_FIELD = SdkField
            .<DestinationConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(Destination::configuration)).setter(setter(Builder::configuration))
            .constructor(DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<DestinationDetail> DETAIL_FIELD = SdkField
            .<DestinationDetail> builder(MarshallingType.SDK_POJO).memberName("detail").getter(getter(Destination::detail))
            .setter(setter(Builder::detail)).constructor(DestinationDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detail").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(Destination::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Destination::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(Destination::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(Destination::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD,
            DETAIL_FIELD, END_TIME_FIELD, ID_FIELD, START_TIME_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final DestinationConfiguration configuration;

    private final DestinationDetail detail;

    private final Instant endTime;

    private final String id;

    private final Instant startTime;

    private final String state;

    private Destination(BuilderImpl builder) {
        this.configuration = builder.configuration;
        this.detail = builder.detail;
        this.endTime = builder.endTime;
        this.id = builder.id;
        this.startTime = builder.startTime;
        this.state = builder.state;
    }

    /**
     * <p>
     * Configuration used to create this destination.
     * </p>
     * 
     * @return Configuration used to create this destination.
     */
    public final DestinationConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * Optional details regarding the status of the destination.
     * </p>
     * 
     * @return Optional details regarding the status of the destination.
     */
    public final DestinationDetail detail() {
        return detail;
    }

    /**
     * <p>
     * UTC time of the destination end. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     * 
     * @return UTC time of the destination end. This is an ISO 8601 timestamp; <i>note that this is returned as a
     *         string</i>.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Unique identifier for this destination, assigned by IVS.
     * </p>
     * 
     * @return Unique identifier for this destination, assigned by IVS.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * UTC time of the destination start. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     * 
     * @return UTC time of the destination start. This is an ISO 8601 timestamp; <i>note that this is returned as a
     *         string</i>.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * State of the Composition Destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DestinationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return State of the Composition Destination.
     * @see DestinationState
     */
    public final DestinationState state() {
        return DestinationState.fromValue(state);
    }

    /**
     * <p>
     * State of the Composition Destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DestinationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return State of the Composition Destination.
     * @see DestinationState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(detail());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination) obj;
        return Objects.equals(configuration(), other.configuration()) && Objects.equals(detail(), other.detail())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(id(), other.id())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Destination").add("Configuration", configuration()).add("Detail", detail())
                .add("EndTime", endTime()).add("Id", id()).add("StartTime", startTime()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "detail":
            return Optional.ofNullable(clazz.cast(detail()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Destination, T> g) {
        return obj -> g.apply((Destination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Destination> {
        /**
         * <p>
         * Configuration used to create this destination.
         * </p>
         * 
         * @param configuration
         *        Configuration used to create this destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(DestinationConfiguration configuration);

        /**
         * <p>
         * Configuration used to create this destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link DestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(DestinationConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(DestinationConfiguration)
         */
        default Builder configuration(Consumer<DestinationConfiguration.Builder> configuration) {
            return configuration(DestinationConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * Optional details regarding the status of the destination.
         * </p>
         * 
         * @param detail
         *        Optional details regarding the status of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detail(DestinationDetail detail);

        /**
         * <p>
         * Optional details regarding the status of the destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationDetail.Builder} avoiding the
         * need to create one manually via {@link DestinationDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #detail(DestinationDetail)}.
         * 
         * @param detail
         *        a consumer that will call methods on {@link DestinationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detail(DestinationDetail)
         */
        default Builder detail(Consumer<DestinationDetail.Builder> detail) {
            return detail(DestinationDetail.builder().applyMutation(detail).build());
        }

        /**
         * <p>
         * UTC time of the destination end. This is an ISO 8601 timestamp; <i>note that this is returned as a
         * string</i>.
         * </p>
         * 
         * @param endTime
         *        UTC time of the destination end. This is an ISO 8601 timestamp; <i>note that this is returned as a
         *        string</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Unique identifier for this destination, assigned by IVS.
         * </p>
         * 
         * @param id
         *        Unique identifier for this destination, assigned by IVS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * UTC time of the destination start. This is an ISO 8601 timestamp; <i>note that this is returned as a
         * string</i>.
         * </p>
         * 
         * @param startTime
         *        UTC time of the destination start. This is an ISO 8601 timestamp; <i>note that this is returned as a
         *        string</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * State of the Composition Destination.
         * </p>
         * 
         * @param state
         *        State of the Composition Destination.
         * @see DestinationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationState
         */
        Builder state(String state);

        /**
         * <p>
         * State of the Composition Destination.
         * </p>
         * 
         * @param state
         *        State of the Composition Destination.
         * @see DestinationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationState
         */
        Builder state(DestinationState state);
    }

    static final class BuilderImpl implements Builder {
        private DestinationConfiguration configuration;

        private DestinationDetail detail;

        private Instant endTime;

        private String id;

        private Instant startTime;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            configuration(model.configuration);
            detail(model.detail);
            endTime(model.endTime);
            id(model.id);
            startTime(model.startTime);
            state(model.state);
        }

        public final DestinationConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(DestinationConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(DestinationConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final DestinationDetail.Builder getDetail() {
            return detail != null ? detail.toBuilder() : null;
        }

        public final void setDetail(DestinationDetail.BuilderImpl detail) {
            this.detail = detail != null ? detail.build() : null;
        }

        @Override
        public final Builder detail(DestinationDetail detail) {
            this.detail = detail;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DestinationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public Destination build() {
            return new Destination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
