/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteReplicatorRequest extends KafkaRequest implements
        ToCopyableBuilder<DeleteReplicatorRequest.Builder, DeleteReplicatorRequest> {
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(DeleteReplicatorRequest::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("currentVersion").build())
            .build();

    private static final SdkField<String> REPLICATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicatorArn").getter(getter(DeleteReplicatorRequest::replicatorArn))
            .setter(setter(Builder::replicatorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("replicatorArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_VERSION_FIELD,
            REPLICATOR_ARN_FIELD));

    private final String currentVersion;

    private final String replicatorArn;

    private DeleteReplicatorRequest(BuilderImpl builder) {
        super(builder);
        this.currentVersion = builder.currentVersion;
        this.replicatorArn = builder.replicatorArn;
    }

    /**
     * <p>
     * The current version of the replicator.
     * </p>
     * 
     * @return The current version of the replicator.
     */
    public final String currentVersion() {
        return currentVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replicator to be deleted.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replicator to be deleted.
     */
    public final String replicatorArn() {
        return replicatorArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(replicatorArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteReplicatorRequest)) {
            return false;
        }
        DeleteReplicatorRequest other = (DeleteReplicatorRequest) obj;
        return Objects.equals(currentVersion(), other.currentVersion()) && Objects.equals(replicatorArn(), other.replicatorArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteReplicatorRequest").add("CurrentVersion", currentVersion())
                .add("ReplicatorArn", replicatorArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "ReplicatorArn":
            return Optional.ofNullable(clazz.cast(replicatorArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteReplicatorRequest, T> g) {
        return obj -> g.apply((DeleteReplicatorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteReplicatorRequest> {
        /**
         * <p>
         * The current version of the replicator.
         * </p>
         * 
         * @param currentVersion
         *        The current version of the replicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replicator to be deleted.
         * </p>
         * 
         * @param replicatorArn
         *        The Amazon Resource Name (ARN) of the replicator to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatorArn(String replicatorArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KafkaRequest.BuilderImpl implements Builder {
        private String currentVersion;

        private String replicatorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteReplicatorRequest model) {
            super(model);
            currentVersion(model.currentVersion);
            replicatorArn(model.replicatorArn);
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final String getReplicatorArn() {
            return replicatorArn;
        }

        public final void setReplicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
        }

        @Override
        public final Builder replicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteReplicatorRequest build() {
            return new DeleteReplicatorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
