/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Indicates whether you want to turn on or turn off the JMX Exporter.
 * </p>
 * 
 */
@Generated("software.amazon.awssdk:codegen")
public final class JmxExporter implements SdkPojo, Serializable, ToCopyableBuilder<JmxExporter.Builder, JmxExporter> {
    private static final SdkField<Boolean> ENABLED_IN_BROKER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnabledInBroker").getter(getter(JmxExporter::enabledInBroker)).setter(setter(Builder::enabledInBroker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledInBroker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_IN_BROKER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabledInBroker;

    private JmxExporter(BuilderImpl builder) {
        this.enabledInBroker = builder.enabledInBroker;
    }

    /**
     *
     * <p>
     * Indicates whether you want to turn on or turn off the JMX Exporter.
     * </p>
     * 
     * @return <p>
     *         Indicates whether you want to turn on or turn off the JMX Exporter.
     *         </p>
     */
    public final Boolean enabledInBroker() {
        return enabledInBroker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabledInBroker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JmxExporter)) {
            return false;
        }
        JmxExporter other = (JmxExporter) obj;
        return Objects.equals(enabledInBroker(), other.enabledInBroker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JmxExporter").add("EnabledInBroker", enabledInBroker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnabledInBroker":
            return Optional.ofNullable(clazz.cast(enabledInBroker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JmxExporter, T> g) {
        return obj -> g.apply((JmxExporter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JmxExporter> {
        /**
         *
         * <p>
         * Indicates whether you want to turn on or turn off the JMX Exporter.
         * </p>
         * 
         * @param enabledInBroker
         *        <p>
         *        Indicates whether you want to turn on or turn off the JMX Exporter.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledInBroker(Boolean enabledInBroker);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabledInBroker;

        private BuilderImpl() {
        }

        private BuilderImpl(JmxExporter model) {
            enabledInBroker(model.enabledInBroker);
        }

        public final Boolean getEnabledInBroker() {
            return enabledInBroker;
        }

        public final void setEnabledInBroker(Boolean enabledInBroker) {
            this.enabledInBroker = enabledInBroker;
        }

        @Override
        public final Builder enabledInBroker(Boolean enabledInBroker) {
            this.enabledInBroker = enabledInBroker;
            return this;
        }

        @Override
        public JmxExporter build() {
            return new JmxExporter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
