/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of the Apache Kafka cluster to which the connector is connected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApacheKafkaClusterDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ApacheKafkaClusterDescription.Builder, ApacheKafkaClusterDescription> {
    private static final SdkField<String> BOOTSTRAP_SERVERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bootstrapServers").getter(getter(ApacheKafkaClusterDescription::bootstrapServers))
            .setter(setter(Builder::bootstrapServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootstrapServers").build()).build();

    private static final SdkField<VpcDescription> VPC_FIELD = SdkField.<VpcDescription> builder(MarshallingType.SDK_POJO)
            .memberName("vpc").getter(getter(ApacheKafkaClusterDescription::vpc)).setter(setter(Builder::vpc))
            .constructor(VpcDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOTSTRAP_SERVERS_FIELD,
            VPC_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bootstrapServers;

    private final VpcDescription vpc;

    private ApacheKafkaClusterDescription(BuilderImpl builder) {
        this.bootstrapServers = builder.bootstrapServers;
        this.vpc = builder.vpc;
    }

    /**
     * <p>
     * The bootstrap servers of the cluster.
     * </p>
     * 
     * @return The bootstrap servers of the cluster.
     */
    public final String bootstrapServers() {
        return bootstrapServers;
    }

    /**
     * <p>
     * Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
     * </p>
     * 
     * @return Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
     */
    public final VpcDescription vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bootstrapServers());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApacheKafkaClusterDescription)) {
            return false;
        }
        ApacheKafkaClusterDescription other = (ApacheKafkaClusterDescription) obj;
        return Objects.equals(bootstrapServers(), other.bootstrapServers()) && Objects.equals(vpc(), other.vpc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApacheKafkaClusterDescription").add("BootstrapServers", bootstrapServers()).add("Vpc", vpc())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bootstrapServers":
            return Optional.ofNullable(clazz.cast(bootstrapServers()));
        case "vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApacheKafkaClusterDescription, T> g) {
        return obj -> g.apply((ApacheKafkaClusterDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApacheKafkaClusterDescription> {
        /**
         * <p>
         * The bootstrap servers of the cluster.
         * </p>
         * 
         * @param bootstrapServers
         *        The bootstrap servers of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapServers(String bootstrapServers);

        /**
         * <p>
         * Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
         * </p>
         * 
         * @param vpc
         *        Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(VpcDescription vpc);

        /**
         * <p>
         * Details of an Amazon VPC which has network connectivity to the Apache Kafka cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcDescription.Builder} avoiding the need
         * to create one manually via {@link VpcDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #vpc(VpcDescription)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link VpcDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(VpcDescription)
         */
        default Builder vpc(Consumer<VpcDescription.Builder> vpc) {
            return vpc(VpcDescription.builder().applyMutation(vpc).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String bootstrapServers;

        private VpcDescription vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(ApacheKafkaClusterDescription model) {
            bootstrapServers(model.bootstrapServers);
            vpc(model.vpc);
        }

        public final String getBootstrapServers() {
            return bootstrapServers;
        }

        public final void setBootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
        }

        @Override
        public final Builder bootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            return this;
        }

        public final VpcDescription.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        public final void setVpc(VpcDescription.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(VpcDescription vpc) {
            this.vpc = vpc;
            return this;
        }

        @Override
        public ApacheKafkaClusterDescription build() {
            return new ApacheKafkaClusterDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
