/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a custom plugin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomPluginDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomPluginDescription.Builder, CustomPluginDescription> {
    private static final SdkField<String> CUSTOM_PLUGIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customPluginArn").getter(getter(CustomPluginDescription::customPluginArn))
            .setter(setter(Builder::customPluginArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPluginArn").build()).build();

    private static final SdkField<Long> REVISION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("revision")
            .getter(getter(CustomPluginDescription::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_PLUGIN_ARN_FIELD,
            REVISION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String customPluginArn;

    private final Long revision;

    private CustomPluginDescription(BuilderImpl builder) {
        this.customPluginArn = builder.customPluginArn;
        this.revision = builder.revision;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom plugin.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom plugin.
     */
    public final String customPluginArn() {
        return customPluginArn;
    }

    /**
     * <p>
     * The revision of the custom plugin.
     * </p>
     * 
     * @return The revision of the custom plugin.
     */
    public final Long revision() {
        return revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customPluginArn());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomPluginDescription)) {
            return false;
        }
        CustomPluginDescription other = (CustomPluginDescription) obj;
        return Objects.equals(customPluginArn(), other.customPluginArn()) && Objects.equals(revision(), other.revision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomPluginDescription").add("CustomPluginArn", customPluginArn()).add("Revision", revision())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customPluginArn":
            return Optional.ofNullable(clazz.cast(customPluginArn()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomPluginDescription, T> g) {
        return obj -> g.apply((CustomPluginDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomPluginDescription> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom plugin.
         * </p>
         * 
         * @param customPluginArn
         *        The Amazon Resource Name (ARN) of the custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPluginArn(String customPluginArn);

        /**
         * <p>
         * The revision of the custom plugin.
         * </p>
         * 
         * @param revision
         *        The revision of the custom plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(Long revision);
    }

    static final class BuilderImpl implements Builder {
        private String customPluginArn;

        private Long revision;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomPluginDescription model) {
            customPluginArn(model.customPluginArn);
            revision(model.revision);
        }

        public final String getCustomPluginArn() {
            return customPluginArn;
        }

        public final void setCustomPluginArn(String customPluginArn) {
            this.customPluginArn = customPluginArn;
        }

        @Override
        public final Builder customPluginArn(String customPluginArn) {
            this.customPluginArn = customPluginArn;
            return this;
        }

        public final Long getRevision() {
            return revision;
        }

        public final void setRevision(Long revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(Long revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public CustomPluginDescription build() {
            return new CustomPluginDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
