/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessControlConfigurationRequest extends KendraRequest implements
        ToCopyableBuilder<CreateAccessControlConfigurationRequest.Builder, CreateAccessControlConfigurationRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexId").getter(getter(CreateAccessControlConfigurationRequest::indexId))
            .setter(setter(Builder::indexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateAccessControlConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateAccessControlConfigurationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Principal>> ACCESS_CONTROL_LIST_FIELD = SdkField
            .<List<Principal>> builder(MarshallingType.LIST)
            .memberName("AccessControlList")
            .getter(getter(CreateAccessControlConfigurationRequest::accessControlList))
            .setter(setter(Builder::accessControlList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Principal> builder(MarshallingType.SDK_POJO)
                                            .constructor(Principal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<HierarchicalPrincipal>> HIERARCHICAL_ACCESS_CONTROL_LIST_FIELD = SdkField
            .<List<HierarchicalPrincipal>> builder(MarshallingType.LIST)
            .memberName("HierarchicalAccessControlList")
            .getter(getter(CreateAccessControlConfigurationRequest::hierarchicalAccessControlList))
            .setter(setter(Builder::hierarchicalAccessControlList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchicalAccessControlList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HierarchicalPrincipal> builder(MarshallingType.SDK_POJO)
                                            .constructor(HierarchicalPrincipal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateAccessControlConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, ACCESS_CONTROL_LIST_FIELD, HIERARCHICAL_ACCESS_CONTROL_LIST_FIELD, CLIENT_TOKEN_FIELD));

    private final String indexId;

    private final String name;

    private final String description;

    private final List<Principal> accessControlList;

    private final List<HierarchicalPrincipal> hierarchicalAccessControlList;

    private final String clientToken;

    private CreateAccessControlConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.name = builder.name;
        this.description = builder.description;
        this.accessControlList = builder.accessControlList;
        this.hierarchicalAccessControlList = builder.hierarchicalAccessControlList;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The identifier of the index to create an access control configuration for your documents.
     * </p>
     * 
     * @return The identifier of the index to create an access control configuration for your documents.
     */
    public final String indexId() {
        return indexId;
    }

    /**
     * <p>
     * A name for the access control configuration.
     * </p>
     * 
     * @return A name for the access control configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description for the access control configuration.
     * </p>
     * 
     * @return A description for the access control configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessControlList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessControlList() {
        return accessControlList != null && !(accessControlList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information on principals (users and/or groups) and which documents they should have access to. This is useful
     * for user context filtering, where search results are filtered based on the user or their group access to
     * documents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessControlList} method.
     * </p>
     * 
     * @return Information on principals (users and/or groups) and which documents they should have access to. This is
     *         useful for user context filtering, where search results are filtered based on the user or their group
     *         access to documents.
     */
    public final List<Principal> accessControlList() {
        return accessControlList;
    }

    /**
     * For responses, this returns true if the service returned a value for the HierarchicalAccessControlList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasHierarchicalAccessControlList() {
        return hierarchicalAccessControlList != null && !(hierarchicalAccessControlList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists that
     * define the hierarchy for which documents users should have access to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHierarchicalAccessControlList} method.
     * </p>
     * 
     * @return The list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists
     *         that define the hierarchy for which documents users should have access to.
     */
    public final List<HierarchicalPrincipal> hierarchicalAccessControlList() {
        return hierarchicalAccessControlList;
    }

    /**
     * <p>
     * A token that you provide to identify the request to create an access control configuration. Multiple calls to the
     * <code>CreateAccessControlConfiguration</code> API with the same client token will create only one access control
     * configuration.
     * </p>
     * 
     * @return A token that you provide to identify the request to create an access control configuration. Multiple
     *         calls to the <code>CreateAccessControlConfiguration</code> API with the same client token will create
     *         only one access control configuration.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessControlList() ? accessControlList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasHierarchicalAccessControlList() ? hierarchicalAccessControlList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessControlConfigurationRequest)) {
            return false;
        }
        CreateAccessControlConfigurationRequest other = (CreateAccessControlConfigurationRequest) obj;
        return Objects.equals(indexId(), other.indexId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && hasAccessControlList() == other.hasAccessControlList()
                && Objects.equals(accessControlList(), other.accessControlList())
                && hasHierarchicalAccessControlList() == other.hasHierarchicalAccessControlList()
                && Objects.equals(hierarchicalAccessControlList(), other.hierarchicalAccessControlList())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateAccessControlConfigurationRequest")
                .add("IndexId", indexId())
                .add("Name", name())
                .add("Description", description())
                .add("AccessControlList", hasAccessControlList() ? accessControlList() : null)
                .add("HierarchicalAccessControlList", hasHierarchicalAccessControlList() ? hierarchicalAccessControlList() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexId":
            return Optional.ofNullable(clazz.cast(indexId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AccessControlList":
            return Optional.ofNullable(clazz.cast(accessControlList()));
        case "HierarchicalAccessControlList":
            return Optional.ofNullable(clazz.cast(hierarchicalAccessControlList()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessControlConfigurationRequest, T> g) {
        return obj -> g.apply((CreateAccessControlConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAccessControlConfigurationRequest> {
        /**
         * <p>
         * The identifier of the index to create an access control configuration for your documents.
         * </p>
         * 
         * @param indexId
         *        The identifier of the index to create an access control configuration for your documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexId(String indexId);

        /**
         * <p>
         * A name for the access control configuration.
         * </p>
         * 
         * @param name
         *        A name for the access control configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description for the access control configuration.
         * </p>
         * 
         * @param description
         *        A description for the access control configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information on principals (users and/or groups) and which documents they should have access to. This is
         * useful for user context filtering, where search results are filtered based on the user or their group access
         * to documents.
         * </p>
         * 
         * @param accessControlList
         *        Information on principals (users and/or groups) and which documents they should have access to. This
         *        is useful for user context filtering, where search results are filtered based on the user or their
         *        group access to documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlList(Collection<Principal> accessControlList);

        /**
         * <p>
         * Information on principals (users and/or groups) and which documents they should have access to. This is
         * useful for user context filtering, where search results are filtered based on the user or their group access
         * to documents.
         * </p>
         * 
         * @param accessControlList
         *        Information on principals (users and/or groups) and which documents they should have access to. This
         *        is useful for user context filtering, where search results are filtered based on the user or their
         *        group access to documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlList(Principal... accessControlList);

        /**
         * <p>
         * Information on principals (users and/or groups) and which documents they should have access to. This is
         * useful for user context filtering, where search results are filtered based on the user or their group access
         * to documents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.Principal.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kendra.model.Principal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.Principal.Builder#build()} is called immediately and its
         * result is passed to {@link #accessControlList(List<Principal>)}.
         * 
         * @param accessControlList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.Principal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessControlList(java.util.Collection<Principal>)
         */
        Builder accessControlList(Consumer<Principal.Builder>... accessControlList);

        /**
         * <p>
         * The list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists
         * that define the hierarchy for which documents users should have access to.
         * </p>
         * 
         * @param hierarchicalAccessControlList
         *        The list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a>
         *        lists that define the hierarchy for which documents users should have access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchicalAccessControlList(Collection<HierarchicalPrincipal> hierarchicalAccessControlList);

        /**
         * <p>
         * The list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists
         * that define the hierarchy for which documents users should have access to.
         * </p>
         * 
         * @param hierarchicalAccessControlList
         *        The list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a>
         *        lists that define the hierarchy for which documents users should have access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchicalAccessControlList(HierarchicalPrincipal... hierarchicalAccessControlList);

        /**
         * <p>
         * The list of <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html">principal</a> lists
         * that define the hierarchy for which documents users should have access to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.HierarchicalPrincipal.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.kendra.model.HierarchicalPrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.HierarchicalPrincipal.Builder#build()} is called
         * immediately and its result is passed to {@link #hierarchicalAccessControlList(List<HierarchicalPrincipal>)}.
         * 
         * @param hierarchicalAccessControlList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.HierarchicalPrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hierarchicalAccessControlList(java.util.Collection<HierarchicalPrincipal>)
         */
        Builder hierarchicalAccessControlList(Consumer<HierarchicalPrincipal.Builder>... hierarchicalAccessControlList);

        /**
         * <p>
         * A token that you provide to identify the request to create an access control configuration. Multiple calls to
         * the <code>CreateAccessControlConfiguration</code> API with the same client token will create only one access
         * control configuration.
         * </p>
         * 
         * @param clientToken
         *        A token that you provide to identify the request to create an access control configuration. Multiple
         *        calls to the <code>CreateAccessControlConfiguration</code> API with the same client token will create
         *        only one access control configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KendraRequest.BuilderImpl implements Builder {
        private String indexId;

        private String name;

        private String description;

        private List<Principal> accessControlList = DefaultSdkAutoConstructList.getInstance();

        private List<HierarchicalPrincipal> hierarchicalAccessControlList = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessControlConfigurationRequest model) {
            super(model);
            indexId(model.indexId);
            name(model.name);
            description(model.description);
            accessControlList(model.accessControlList);
            hierarchicalAccessControlList(model.hierarchicalAccessControlList);
            clientToken(model.clientToken);
        }

        public final String getIndexId() {
            return indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Principal.Builder> getAccessControlList() {
            List<Principal.Builder> result = PrincipalListCopier.copyToBuilder(this.accessControlList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessControlList(Collection<Principal.BuilderImpl> accessControlList) {
            this.accessControlList = PrincipalListCopier.copyFromBuilder(accessControlList);
        }

        @Override
        public final Builder accessControlList(Collection<Principal> accessControlList) {
            this.accessControlList = PrincipalListCopier.copy(accessControlList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlList(Principal... accessControlList) {
            accessControlList(Arrays.asList(accessControlList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessControlList(Consumer<Principal.Builder>... accessControlList) {
            accessControlList(Stream.of(accessControlList).map(c -> Principal.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<HierarchicalPrincipal.Builder> getHierarchicalAccessControlList() {
            List<HierarchicalPrincipal.Builder> result = HierarchicalPrincipalListCopier
                    .copyToBuilder(this.hierarchicalAccessControlList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHierarchicalAccessControlList(
                Collection<HierarchicalPrincipal.BuilderImpl> hierarchicalAccessControlList) {
            this.hierarchicalAccessControlList = HierarchicalPrincipalListCopier.copyFromBuilder(hierarchicalAccessControlList);
        }

        @Override
        public final Builder hierarchicalAccessControlList(Collection<HierarchicalPrincipal> hierarchicalAccessControlList) {
            this.hierarchicalAccessControlList = HierarchicalPrincipalListCopier.copy(hierarchicalAccessControlList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchicalAccessControlList(HierarchicalPrincipal... hierarchicalAccessControlList) {
            hierarchicalAccessControlList(Arrays.asList(hierarchicalAccessControlList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchicalAccessControlList(
                Consumer<HierarchicalPrincipal.Builder>... hierarchicalAccessControlList) {
            hierarchicalAccessControlList(Stream.of(hierarchicalAccessControlList)
                    .map(c -> HierarchicalPrincipal.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccessControlConfigurationRequest build() {
            return new CreateAccessControlConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
