/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendraranking;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.kendraranking.model.CreateRescoreExecutionPlanRequest;
import software.amazon.awssdk.services.kendraranking.model.CreateRescoreExecutionPlanResponse;
import software.amazon.awssdk.services.kendraranking.model.DeleteRescoreExecutionPlanRequest;
import software.amazon.awssdk.services.kendraranking.model.DeleteRescoreExecutionPlanResponse;
import software.amazon.awssdk.services.kendraranking.model.DescribeRescoreExecutionPlanRequest;
import software.amazon.awssdk.services.kendraranking.model.DescribeRescoreExecutionPlanResponse;
import software.amazon.awssdk.services.kendraranking.model.ListRescoreExecutionPlansRequest;
import software.amazon.awssdk.services.kendraranking.model.ListRescoreExecutionPlansResponse;
import software.amazon.awssdk.services.kendraranking.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kendraranking.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.kendraranking.model.RescoreRequest;
import software.amazon.awssdk.services.kendraranking.model.RescoreResponse;
import software.amazon.awssdk.services.kendraranking.model.TagResourceRequest;
import software.amazon.awssdk.services.kendraranking.model.TagResourceResponse;
import software.amazon.awssdk.services.kendraranking.model.UntagResourceRequest;
import software.amazon.awssdk.services.kendraranking.model.UntagResourceResponse;
import software.amazon.awssdk.services.kendraranking.model.UpdateRescoreExecutionPlanRequest;
import software.amazon.awssdk.services.kendraranking.model.UpdateRescoreExecutionPlanResponse;
import software.amazon.awssdk.services.kendraranking.paginators.ListRescoreExecutionPlansPublisher;

/**
 * Service client for accessing Kendra Ranking asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon Kendra Intelligent Ranking uses Amazon Kendra semantic search capabilities to intelligently re-rank a search
 * service's results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface KendraRankingAsyncClient extends AwsClient {
    String SERVICE_NAME = "kendra-ranking";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "kendra-ranking";

    /**
     * <p>
     * Creates a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used
     * for provisioning the <code>Rescore</code> API. You set the number of capacity units that you require for Amazon
     * Kendra Intelligent Ranking to rescore or re-rank a search service's results.
     * </p>
     * <p>
     * For an example of using the <code>CreateRescoreExecutionPlan</code> API, including using the Python and Java
     * SDKs, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/search-service-rerank.html">Semantically ranking
     * a search service's results</a>.
     * </p>
     *
     * @param createRescoreExecutionPlanRequest
     * @return A Java Future containing the result of the CreateRescoreExecutionPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistencies with your
     *         resources and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra Intelligent
     *         Ranking service. Please see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>
     *         for more information, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about
     *         an increase of limits.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.CreateRescoreExecutionPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/CreateRescoreExecutionPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRescoreExecutionPlanResponse> createRescoreExecutionPlan(
            CreateRescoreExecutionPlanRequest createRescoreExecutionPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used
     * for provisioning the <code>Rescore</code> API. You set the number of capacity units that you require for Amazon
     * Kendra Intelligent Ranking to rescore or re-rank a search service's results.
     * </p>
     * <p>
     * For an example of using the <code>CreateRescoreExecutionPlan</code> API, including using the Python and Java
     * SDKs, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/search-service-rerank.html">Semantically ranking
     * a search service's results</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRescoreExecutionPlanRequest.Builder} avoiding
     * the need to create one manually via {@link CreateRescoreExecutionPlanRequest#builder()}
     * </p>
     *
     * @param createRescoreExecutionPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kendraranking.model.CreateRescoreExecutionPlanRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateRescoreExecutionPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistencies with your
     *         resources and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra Intelligent
     *         Ranking service. Please see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>
     *         for more information, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about
     *         an increase of limits.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.CreateRescoreExecutionPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/CreateRescoreExecutionPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRescoreExecutionPlanResponse> createRescoreExecutionPlan(
            Consumer<CreateRescoreExecutionPlanRequest.Builder> createRescoreExecutionPlanRequest) {
        return createRescoreExecutionPlan(CreateRescoreExecutionPlanRequest.builder()
                .applyMutation(createRescoreExecutionPlanRequest).build());
    }

    /**
     * <p>
     * Deletes a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used
     * for provisioning the <code>Rescore</code> API.
     * </p>
     *
     * @param deleteRescoreExecutionPlanRequest
     * @return A Java Future containing the result of the DeleteRescoreExecutionPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistencies with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn't exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.DeleteRescoreExecutionPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/DeleteRescoreExecutionPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRescoreExecutionPlanResponse> deleteRescoreExecutionPlan(
            DeleteRescoreExecutionPlanRequest deleteRescoreExecutionPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used
     * for provisioning the <code>Rescore</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRescoreExecutionPlanRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteRescoreExecutionPlanRequest#builder()}
     * </p>
     *
     * @param deleteRescoreExecutionPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kendraranking.model.DeleteRescoreExecutionPlanRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteRescoreExecutionPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistencies with your
     *         resources and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn't exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.DeleteRescoreExecutionPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/DeleteRescoreExecutionPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRescoreExecutionPlanResponse> deleteRescoreExecutionPlan(
            Consumer<DeleteRescoreExecutionPlanRequest.Builder> deleteRescoreExecutionPlanRequest) {
        return deleteRescoreExecutionPlan(DeleteRescoreExecutionPlanRequest.builder()
                .applyMutation(deleteRescoreExecutionPlanRequest).build());
    }

    /**
     * <p>
     * Gets information about a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking
     * resource used for provisioning the <code>Rescore</code> API.
     * </p>
     *
     * @param describeRescoreExecutionPlanRequest
     * @return A Java Future containing the result of the DescribeRescoreExecutionPlan operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn't exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.DescribeRescoreExecutionPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/DescribeRescoreExecutionPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRescoreExecutionPlanResponse> describeRescoreExecutionPlan(
            DescribeRescoreExecutionPlanRequest describeRescoreExecutionPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking
     * resource used for provisioning the <code>Rescore</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRescoreExecutionPlanRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRescoreExecutionPlanRequest#builder()}
     * </p>
     *
     * @param describeRescoreExecutionPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kendraranking.model.DescribeRescoreExecutionPlanRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeRescoreExecutionPlan operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn't exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.DescribeRescoreExecutionPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/DescribeRescoreExecutionPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRescoreExecutionPlanResponse> describeRescoreExecutionPlan(
            Consumer<DescribeRescoreExecutionPlanRequest.Builder> describeRescoreExecutionPlanRequest) {
        return describeRescoreExecutionPlan(DescribeRescoreExecutionPlanRequest.builder()
                .applyMutation(describeRescoreExecutionPlanRequest).build());
    }

    /**
     * <p>
     * Lists your rescore execution plans. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource
     * used for provisioning the <code>Rescore</code> API.
     * </p>
     *
     * @param listRescoreExecutionPlansRequest
     * @return A Java Future containing the result of the ListRescoreExecutionPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.ListRescoreExecutionPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/ListRescoreExecutionPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRescoreExecutionPlansResponse> listRescoreExecutionPlans(
            ListRescoreExecutionPlansRequest listRescoreExecutionPlansRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your rescore execution plans. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource
     * used for provisioning the <code>Rescore</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRescoreExecutionPlansRequest.Builder} avoiding
     * the need to create one manually via {@link ListRescoreExecutionPlansRequest#builder()}
     * </p>
     *
     * @param listRescoreExecutionPlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kendraranking.model.ListRescoreExecutionPlansRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListRescoreExecutionPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.ListRescoreExecutionPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/ListRescoreExecutionPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRescoreExecutionPlansResponse> listRescoreExecutionPlans(
            Consumer<ListRescoreExecutionPlansRequest.Builder> listRescoreExecutionPlansRequest) {
        return listRescoreExecutionPlans(ListRescoreExecutionPlansRequest.builder()
                .applyMutation(listRescoreExecutionPlansRequest).build());
    }

    /**
     * <p>
     * Lists your rescore execution plans. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource
     * used for provisioning the <code>Rescore</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRescoreExecutionPlans(software.amazon.awssdk.services.kendraranking.model.ListRescoreExecutionPlansRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendraranking.paginators.ListRescoreExecutionPlansPublisher publisher = client.listRescoreExecutionPlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendraranking.paginators.ListRescoreExecutionPlansPublisher publisher = client.listRescoreExecutionPlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendraranking.model.ListRescoreExecutionPlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendraranking.model.ListRescoreExecutionPlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRescoreExecutionPlans(software.amazon.awssdk.services.kendraranking.model.ListRescoreExecutionPlansRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRescoreExecutionPlansRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.ListRescoreExecutionPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/ListRescoreExecutionPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRescoreExecutionPlansPublisher listRescoreExecutionPlansPaginator(
            ListRescoreExecutionPlansRequest listRescoreExecutionPlansRequest) {
        return new ListRescoreExecutionPlansPublisher(this, listRescoreExecutionPlansRequest);
    }

    /**
     * <p>
     * Lists your rescore execution plans. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource
     * used for provisioning the <code>Rescore</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRescoreExecutionPlans(software.amazon.awssdk.services.kendraranking.model.ListRescoreExecutionPlansRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendraranking.paginators.ListRescoreExecutionPlansPublisher publisher = client.listRescoreExecutionPlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kendraranking.paginators.ListRescoreExecutionPlansPublisher publisher = client.listRescoreExecutionPlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.kendraranking.model.ListRescoreExecutionPlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.kendraranking.model.ListRescoreExecutionPlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRescoreExecutionPlans(software.amazon.awssdk.services.kendraranking.model.ListRescoreExecutionPlansRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRescoreExecutionPlansRequest.Builder} avoiding
     * the need to create one manually via {@link ListRescoreExecutionPlansRequest#builder()}
     * </p>
     *
     * @param listRescoreExecutionPlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kendraranking.model.ListRescoreExecutionPlansRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.ListRescoreExecutionPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/ListRescoreExecutionPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRescoreExecutionPlansPublisher listRescoreExecutionPlansPaginator(
            Consumer<ListRescoreExecutionPlansRequest.Builder> listRescoreExecutionPlansRequest) {
        return listRescoreExecutionPlansPaginator(ListRescoreExecutionPlansRequest.builder()
                .applyMutation(listRescoreExecutionPlansRequest).build());
    }

    /**
     * <p>
     * Gets a list of tags associated with a specified resource. A rescore execution plan is an example of a resource
     * that can have tags associated with it.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The request information for listing tags associated with a rescore execution plan. A rescore execution
     *        plan is an Amazon Kendra Intelligent Ranking resource used for provisioning the <code>Rescore</code> API.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use is unavailable. Please check you have
     *         provided the correct resource information and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of tags associated with a specified resource. A rescore execution plan is an example of a resource
     * that can have tags associated with it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kendraranking.model.ListTagsForResourceRequest.Builder} to create a
     *        request. The request information for listing tags associated with a rescore execution plan. A rescore
     *        execution plan is an Amazon Kendra Intelligent Ranking resource used for provisioning the
     *        <code>Rescore</code> API.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use is unavailable. Please check you have
     *         provided the correct resource information and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Rescores or re-ranks search results from a search service such as OpenSearch (self managed). You use the semantic
     * search capabilities of Amazon Kendra Intelligent Ranking to improve the search service's results.
     * </p>
     *
     * @param rescoreRequest
     * @return A Java Future containing the result of the Rescore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistencies with your
     *         resources and try again.</li>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn't exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.Rescore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/Rescore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RescoreResponse> rescore(RescoreRequest rescoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rescores or re-ranks search results from a search service such as OpenSearch (self managed). You use the semantic
     * search capabilities of Amazon Kendra Intelligent Ranking to improve the search service's results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RescoreRequest.Builder} avoiding the need to create
     * one manually via {@link RescoreRequest#builder()}
     * </p>
     *
     * @param rescoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kendraranking.model.RescoreRequest.Builder} to create a request.
     * @return A Java Future containing the result of the Rescore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistencies with your
     *         resources and try again.</li>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn't exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.Rescore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/Rescore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RescoreResponse> rescore(Consumer<RescoreRequest.Builder> rescoreRequest) {
        return rescore(RescoreRequest.builder().applyMutation(rescoreRequest).build());
    }

    /**
     * <p>
     * Adds a specified tag to a specified rescore execution plan. A rescore execution plan is an Amazon Kendra
     * Intelligent Ranking resource used for provisioning the <code>Rescore</code> API. If the tag already exists, the
     * existing value is replaced with the new value.
     * </p>
     *
     * @param tagResourceRequest
     *        The request information for tagging a rescore execution plan. A rescore execution plan is an Amazon Kendra
     *        Intelligent Ranking resource used for provisioning the <code>Rescore</code> API.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use is unavailable. Please check you have
     *         provided the correct resource information and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a specified tag to a specified rescore execution plan. A rescore execution plan is an Amazon Kendra
     * Intelligent Ranking resource used for provisioning the <code>Rescore</code> API. If the tag already exists, the
     * existing value is replaced with the new value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kendraranking.model.TagResourceRequest.Builder} to create a
     *        request. The request information for tagging a rescore execution plan. A rescore execution plan is an
     *        Amazon Kendra Intelligent Ranking resource used for provisioning the <code>Rescore</code> API.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use is unavailable. Please check you have
     *         provided the correct resource information and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking
     * resource used for provisioning the <code>Rescore</code> operation.
     * </p>
     *
     * @param untagResourceRequest
     *        The request information to remove a tag from a rescore execution plan. A rescore execution plan is an
     *        Amazon Kendra Intelligent Ranking resource used for provisioning the <code>Rescore</code> API.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use is unavailable. Please check you have
     *         provided the correct resource information and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking
     * resource used for provisioning the <code>Rescore</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kendraranking.model.UntagResourceRequest.Builder} to create a
     *        request. The request information to remove a tag from a rescore execution plan. A rescore execution plan
     *        is an Amazon Kendra Intelligent Ranking resource used for provisioning the <code>Rescore</code> API.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>ResourceUnavailableException The resource you want to use is unavailable. Please check you have
     *         provided the correct resource information and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used
     * for provisioning the <code>Rescore</code> API. You can update the number of capacity units you require for Amazon
     * Kendra Intelligent Ranking to rescore or re-rank a search service's results.
     * </p>
     *
     * @param updateRescoreExecutionPlanRequest
     * @return A Java Future containing the result of the UpdateRescoreExecutionPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn't exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra Intelligent
     *         Ranking service. Please see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>
     *         for more information, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about
     *         an increase of limits.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistencies with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.UpdateRescoreExecutionPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/UpdateRescoreExecutionPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRescoreExecutionPlanResponse> updateRescoreExecutionPlan(
            UpdateRescoreExecutionPlanRequest updateRescoreExecutionPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a rescore execution plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource used
     * for provisioning the <code>Rescore</code> API. You can update the number of capacity units you require for Amazon
     * Kendra Intelligent Ranking to rescore or re-rank a search service's results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRescoreExecutionPlanRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateRescoreExecutionPlanRequest#builder()}
     * </p>
     *
     * @param updateRescoreExecutionPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kendraranking.model.UpdateRescoreExecutionPlanRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateRescoreExecutionPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
     *         Ranking service. Please provide the correct input and try again.</li>
     *         <li>ResourceNotFoundException The resource you want to use doesn't exist. Please check you have provided
     *         the correct resource and try again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling. Please reduce the number of
     *         requests and try again.</li>
     *         <li>AccessDeniedException You don’t have sufficient access to perform this action. Please ensure you have
     *         the required permission policies and user accounts and try again.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the set limits for your Amazon Kendra Intelligent
     *         Ranking service. Please see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas</a>
     *         for more information, or contact <a href="http://aws.amazon.com/contact-us/">Support</a> to inquire about
     *         an increase of limits.</li>
     *         <li>ConflictException A conflict occurred with the request. Please fix any inconsistencies with your
     *         resources and try again.</li>
     *         <li>InternalServerException An issue occurred with the internal server used for your Amazon Kendra
     *         Intelligent Ranking service. Please wait a few minutes and try again, or contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for help.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>KendraRankingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample KendraRankingAsyncClient.UpdateRescoreExecutionPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/UpdateRescoreExecutionPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRescoreExecutionPlanResponse> updateRescoreExecutionPlan(
            Consumer<UpdateRescoreExecutionPlanRequest.Builder> updateRescoreExecutionPlanRequest) {
        return updateRescoreExecutionPlan(UpdateRescoreExecutionPlanRequest.builder()
                .applyMutation(updateRescoreExecutionPlanRequest).build());
    }

    @Override
    default KendraRankingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link KendraRankingAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static KendraRankingAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link KendraRankingAsyncClient}.
     */
    static KendraRankingAsyncClientBuilder builder() {
        return new DefaultKendraRankingAsyncClientBuilder();
    }
}
