/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTableRequest extends KeyspacesRequest implements
        ToCopyableBuilder<UpdateTableRequest.Builder, UpdateTableRequest> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyspaceName").getter(getter(UpdateTableRequest::keyspaceName)).setter(setter(Builder::keyspaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableName").getter(getter(UpdateTableRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()).build();

    private static final SdkField<List<ColumnDefinition>> ADD_COLUMNS_FIELD = SdkField
            .<List<ColumnDefinition>> builder(MarshallingType.LIST)
            .memberName("addColumns")
            .getter(getter(UpdateTableRequest::addColumns))
            .setter(setter(Builder::addColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CapacitySpecification> CAPACITY_SPECIFICATION_FIELD = SdkField
            .<CapacitySpecification> builder(MarshallingType.SDK_POJO).memberName("capacitySpecification")
            .getter(getter(UpdateTableRequest::capacitySpecification)).setter(setter(Builder::capacitySpecification))
            .constructor(CapacitySpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacitySpecification").build())
            .build();

    private static final SdkField<EncryptionSpecification> ENCRYPTION_SPECIFICATION_FIELD = SdkField
            .<EncryptionSpecification> builder(MarshallingType.SDK_POJO).memberName("encryptionSpecification")
            .getter(getter(UpdateTableRequest::encryptionSpecification)).setter(setter(Builder::encryptionSpecification))
            .constructor(EncryptionSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionSpecification").build())
            .build();

    private static final SdkField<PointInTimeRecovery> POINT_IN_TIME_RECOVERY_FIELD = SdkField
            .<PointInTimeRecovery> builder(MarshallingType.SDK_POJO).memberName("pointInTimeRecovery")
            .getter(getter(UpdateTableRequest::pointInTimeRecovery)).setter(setter(Builder::pointInTimeRecovery))
            .constructor(PointInTimeRecovery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pointInTimeRecovery").build())
            .build();

    private static final SdkField<TimeToLive> TTL_FIELD = SdkField.<TimeToLive> builder(MarshallingType.SDK_POJO)
            .memberName("ttl").getter(getter(UpdateTableRequest::ttl)).setter(setter(Builder::ttl))
            .constructor(TimeToLive::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()).build();

    private static final SdkField<Integer> DEFAULT_TIME_TO_LIVE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("defaultTimeToLive").getter(getter(UpdateTableRequest::defaultTimeToLive))
            .setter(setter(Builder::defaultTimeToLive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultTimeToLive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD,
            TABLE_NAME_FIELD, ADD_COLUMNS_FIELD, CAPACITY_SPECIFICATION_FIELD, ENCRYPTION_SPECIFICATION_FIELD,
            POINT_IN_TIME_RECOVERY_FIELD, TTL_FIELD, DEFAULT_TIME_TO_LIVE_FIELD));

    private final String keyspaceName;

    private final String tableName;

    private final List<ColumnDefinition> addColumns;

    private final CapacitySpecification capacitySpecification;

    private final EncryptionSpecification encryptionSpecification;

    private final PointInTimeRecovery pointInTimeRecovery;

    private final TimeToLive ttl;

    private final Integer defaultTimeToLive;

    private UpdateTableRequest(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.tableName = builder.tableName;
        this.addColumns = builder.addColumns;
        this.capacitySpecification = builder.capacitySpecification;
        this.encryptionSpecification = builder.encryptionSpecification;
        this.pointInTimeRecovery = builder.pointInTimeRecovery;
        this.ttl = builder.ttl;
        this.defaultTimeToLive = builder.defaultTimeToLive;
    }

    /**
     * <p>
     * The name of the keyspace the specified table is stored in.
     * </p>
     * 
     * @return The name of the keyspace the specified table is stored in.
     */
    public final String keyspaceName() {
        return keyspaceName;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddColumns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAddColumns() {
        return addColumns != null && !(addColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For each column to be added to the specified table:
     * </p>
     * <p>
     * • <code>name</code> - The name of the column.
     * </p>
     * <p>
     * • <code>type</code> - An Amazon Keyspaces data type. For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in
     * the <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddColumns} method.
     * </p>
     * 
     * @return For each column to be added to the specified table:</p>
     *         <p>
     *         • <code>name</code> - The name of the column.
     *         </p>
     *         <p>
     *         • <code>type</code> - An Amazon Keyspaces data type. For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data
     *         types</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     */
    public final List<ColumnDefinition> addColumns() {
        return addColumns;
    }

    /**
     * <p>
     * Modifies the read/write throughput capacity mode for the table. The options are:
     * </p>
     * <p>
     * • <code>throughputMode:PAY_PER_REQUEST</code> and
     * </p>
     * <p>
     * • <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code> and
     * <code>writeCapacityUnits</code> as input.
     * </p>
     * <p>
     * The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity
     * modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * 
     * @return Modifies the read/write throughput capacity mode for the table. The options are:</p>
     *         <p>
     *         • <code>throughputMode:PAY_PER_REQUEST</code> and
     *         </p>
     *         <p>
     *         • <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires
     *         <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.
     *         </p>
     *         <p>
     *         The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write
     *         capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     */
    public final CapacitySpecification capacitySpecification() {
        return capacitySpecification;
    }

    /**
     * <p>
     * Modifies the encryption settings of the table. You can choose one of the following KMS key (KMS key):
     * </p>
     * <p>
     * • <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces.
     * </p>
     * <p>
     * • <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and
     * managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource Name
     * (ARN) format as input.
     * </p>
     * <p>
     * The default is <code>AWS_OWNED_KMS_KEY</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in the
     * <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * 
     * @return Modifies the encryption settings of the table. You can choose one of the following KMS key (KMS key):</p>
     *         <p>
     *         • <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces.
     *         </p>
     *         <p>
     *         • <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned,
     *         and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon
     *         Resource Name (ARN) format as input.
     *         </p>
     *         <p>
     *         The default is <code>AWS_OWNED_KMS_KEY</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a>
     *         in the <i>Amazon Keyspaces Developer Guide</i>.
     */
    public final EncryptionSpecification encryptionSpecification() {
        return encryptionSpecification;
    }

    /**
     * <p>
     * Modifies the <code>pointInTimeRecovery</code> settings of the table. The options are:
     * </p>
     * <p>
     * • <code>ENABLED</code>
     * </p>
     * <p>
     * • <code>DISABLED</code>
     * </p>
     * <p>
     * If it's not specified, the default is <code>DISABLED</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a>
     * in the <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * 
     * @return Modifies the <code>pointInTimeRecovery</code> settings of the table. The options are:</p>
     *         <p>
     *         • <code>ENABLED</code>
     *         </p>
     *         <p>
     *         • <code>DISABLED</code>
     *         </p>
     *         <p>
     *         If it's not specified, the default is <code>DISABLED</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time
     *         recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     */
    public final PointInTimeRecovery pointInTimeRecovery() {
        return pointInTimeRecovery;
    }

    /**
     * <p>
     * Modifies Time to Live custom settings for the table. The options are:
     * </p>
     * <p>
     * • <code>status:enabled</code>
     * </p>
     * <p>
     * • <code>status:disabled</code>
     * </p>
     * <p>
     * The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the
     * table.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data
     * by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * 
     * @return Modifies Time to Live custom settings for the table. The options are:</p>
     *         <p>
     *         • <code>status:enabled</code>
     *         </p>
     *         <p>
     *         • <code>status:disabled</code>
     *         </p>
     *         <p>
     *         The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for
     *         the table.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon
     *         Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     */
    public final TimeToLive ttl() {
        return ttl;
    }

    /**
     * <p>
     * The default Time to Live setting in seconds for the table.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl"
     * >Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     * </p>
     * 
     * @return The default Time to Live setting in seconds for the table.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl"
     *         >Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.
     */
    public final Integer defaultTimeToLive() {
        return defaultTimeToLive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddColumns() ? addColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(capacitySpecification());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(pointInTimeRecovery());
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTimeToLive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest other = (UpdateTableRequest) obj;
        return Objects.equals(keyspaceName(), other.keyspaceName()) && Objects.equals(tableName(), other.tableName())
                && hasAddColumns() == other.hasAddColumns() && Objects.equals(addColumns(), other.addColumns())
                && Objects.equals(capacitySpecification(), other.capacitySpecification())
                && Objects.equals(encryptionSpecification(), other.encryptionSpecification())
                && Objects.equals(pointInTimeRecovery(), other.pointInTimeRecovery()) && Objects.equals(ttl(), other.ttl())
                && Objects.equals(defaultTimeToLive(), other.defaultTimeToLive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTableRequest").add("KeyspaceName", keyspaceName()).add("TableName", tableName())
                .add("AddColumns", hasAddColumns() ? addColumns() : null).add("CapacitySpecification", capacitySpecification())
                .add("EncryptionSpecification", encryptionSpecification()).add("PointInTimeRecovery", pointInTimeRecovery())
                .add("Ttl", ttl()).add("DefaultTimeToLive", defaultTimeToLive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyspaceName":
            return Optional.ofNullable(clazz.cast(keyspaceName()));
        case "tableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "addColumns":
            return Optional.ofNullable(clazz.cast(addColumns()));
        case "capacitySpecification":
            return Optional.ofNullable(clazz.cast(capacitySpecification()));
        case "encryptionSpecification":
            return Optional.ofNullable(clazz.cast(encryptionSpecification()));
        case "pointInTimeRecovery":
            return Optional.ofNullable(clazz.cast(pointInTimeRecovery()));
        case "ttl":
            return Optional.ofNullable(clazz.cast(ttl()));
        case "defaultTimeToLive":
            return Optional.ofNullable(clazz.cast(defaultTimeToLive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableRequest, T> g) {
        return obj -> g.apply((UpdateTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KeyspacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTableRequest> {
        /**
         * <p>
         * The name of the keyspace the specified table is stored in.
         * </p>
         * 
         * @param keyspaceName
         *        The name of the keyspace the specified table is stored in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyspaceName(String keyspaceName);

        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * For each column to be added to the specified table:
         * </p>
         * <p>
         * • <code>name</code> - The name of the column.
         * </p>
         * <p>
         * • <code>type</code> - An Amazon Keyspaces data type. For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a>
         * in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param addColumns
         *        For each column to be added to the specified table:</p>
         *        <p>
         *        • <code>name</code> - The name of the column.
         *        </p>
         *        <p>
         *        • <code>type</code> - An Amazon Keyspaces data type. For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data
         *        types</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addColumns(Collection<ColumnDefinition> addColumns);

        /**
         * <p>
         * For each column to be added to the specified table:
         * </p>
         * <p>
         * • <code>name</code> - The name of the column.
         * </p>
         * <p>
         * • <code>type</code> - An Amazon Keyspaces data type. For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a>
         * in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param addColumns
         *        For each column to be added to the specified table:</p>
         *        <p>
         *        • <code>name</code> - The name of the column.
         *        </p>
         *        <p>
         *        • <code>type</code> - An Amazon Keyspaces data type. For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data
         *        types</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addColumns(ColumnDefinition... addColumns);

        /**
         * <p>
         * For each column to be added to the specified table:
         * </p>
         * <p>
         * • <code>name</code> - The name of the column.
         * </p>
         * <p>
         * • <code>type</code> - An Amazon Keyspaces data type. For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a>
         * in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.keyspaces.model.ColumnDefinition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.keyspaces.model.ColumnDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.keyspaces.model.ColumnDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #addColumns(List<ColumnDefinition>)}.
         * 
         * @param addColumns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.keyspaces.model.ColumnDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addColumns(java.util.Collection<ColumnDefinition>)
         */
        Builder addColumns(Consumer<ColumnDefinition.Builder>... addColumns);

        /**
         * <p>
         * Modifies the read/write throughput capacity mode for the table. The options are:
         * </p>
         * <p>
         * • <code>throughputMode:PAY_PER_REQUEST</code> and
         * </p>
         * <p>
         * • <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code>
         * and <code>writeCapacityUnits</code> as input.
         * </p>
         * <p>
         * The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity
         * modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param capacitySpecification
         *        Modifies the read/write throughput capacity mode for the table. The options are:</p>
         *        <p>
         *        • <code>throughputMode:PAY_PER_REQUEST</code> and
         *        </p>
         *        <p>
         *        • <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires
         *        <code>readCapacityUnits</code> and <code>writeCapacityUnits</code> as input.
         *        </p>
         *        <p>
         *        The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write
         *        capacity modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacitySpecification(CapacitySpecification capacitySpecification);

        /**
         * <p>
         * Modifies the read/write throughput capacity mode for the table. The options are:
         * </p>
         * <p>
         * • <code>throughputMode:PAY_PER_REQUEST</code> and
         * </p>
         * <p>
         * • <code>throughputMode:PROVISIONED</code> - Provisioned capacity mode requires <code>readCapacityUnits</code>
         * and <code>writeCapacityUnits</code> as input.
         * </p>
         * <p>
         * The default is <code>throughput_mode:PAY_PER_REQUEST</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity
         * modes</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacitySpecification.Builder} avoiding
         * the need to create one manually via {@link CapacitySpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacitySpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #capacitySpecification(CapacitySpecification)}.
         * 
         * @param capacitySpecification
         *        a consumer that will call methods on {@link CapacitySpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacitySpecification(CapacitySpecification)
         */
        default Builder capacitySpecification(Consumer<CapacitySpecification.Builder> capacitySpecification) {
            return capacitySpecification(CapacitySpecification.builder().applyMutation(capacitySpecification).build());
        }

        /**
         * <p>
         * Modifies the encryption settings of the table. You can choose one of the following KMS key (KMS key):
         * </p>
         * <p>
         * • <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces.
         * </p>
         * <p>
         * • <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and
         * managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource
         * Name (ARN) format as input.
         * </p>
         * <p>
         * The default is <code>AWS_OWNED_KMS_KEY</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in
         * the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param encryptionSpecification
         *        Modifies the encryption settings of the table. You can choose one of the following KMS key (KMS
         *        key):</p>
         *        <p>
         *        • <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces.
         *        </p>
         *        <p>
         *        • <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created,
         *        owned, and managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in
         *        Amazon Resource Name (ARN) format as input.
         *        </p>
         *        <p>
         *        The default is <code>AWS_OWNED_KMS_KEY</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at
         *        rest</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionSpecification(EncryptionSpecification encryptionSpecification);

        /**
         * <p>
         * Modifies the encryption settings of the table. You can choose one of the following KMS key (KMS key):
         * </p>
         * <p>
         * • <code>type:AWS_OWNED_KMS_KEY</code> - This key is owned by Amazon Keyspaces.
         * </p>
         * <p>
         * • <code>type:CUSTOMER_MANAGED_KMS_KEY</code> - This key is stored in your account and is created, owned, and
         * managed by you. This option requires the <code>kms_key_identifier</code> of the KMS key in Amazon Resource
         * Name (ARN) format as input.
         * </p>
         * <p>
         * The default is <code>AWS_OWNED_KMS_KEY</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest</a> in
         * the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionSpecification.Builder} avoiding
         * the need to create one manually via {@link EncryptionSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionSpecification(EncryptionSpecification)}.
         * 
         * @param encryptionSpecification
         *        a consumer that will call methods on {@link EncryptionSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionSpecification(EncryptionSpecification)
         */
        default Builder encryptionSpecification(Consumer<EncryptionSpecification.Builder> encryptionSpecification) {
            return encryptionSpecification(EncryptionSpecification.builder().applyMutation(encryptionSpecification).build());
        }

        /**
         * <p>
         * Modifies the <code>pointInTimeRecovery</code> settings of the table. The options are:
         * </p>
         * <p>
         * • <code>ENABLED</code>
         * </p>
         * <p>
         * • <code>DISABLED</code>
         * </p>
         * <p>
         * If it's not specified, the default is <code>DISABLED</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time
         * recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param pointInTimeRecovery
         *        Modifies the <code>pointInTimeRecovery</code> settings of the table. The options are:</p>
         *        <p>
         *        • <code>ENABLED</code>
         *        </p>
         *        <p>
         *        • <code>DISABLED</code>
         *        </p>
         *        <p>
         *        If it's not specified, the default is <code>DISABLED</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time
         *        recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pointInTimeRecovery(PointInTimeRecovery pointInTimeRecovery);

        /**
         * <p>
         * Modifies the <code>pointInTimeRecovery</code> settings of the table. The options are:
         * </p>
         * <p>
         * • <code>ENABLED</code>
         * </p>
         * <p>
         * • <code>DISABLED</code>
         * </p>
         * <p>
         * If it's not specified, the default is <code>DISABLED</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time
         * recovery</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PointInTimeRecovery.Builder} avoiding the
         * need to create one manually via {@link PointInTimeRecovery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PointInTimeRecovery.Builder#build()} is called immediately and
         * its result is passed to {@link #pointInTimeRecovery(PointInTimeRecovery)}.
         * 
         * @param pointInTimeRecovery
         *        a consumer that will call methods on {@link PointInTimeRecovery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pointInTimeRecovery(PointInTimeRecovery)
         */
        default Builder pointInTimeRecovery(Consumer<PointInTimeRecovery.Builder> pointInTimeRecovery) {
            return pointInTimeRecovery(PointInTimeRecovery.builder().applyMutation(pointInTimeRecovery).build());
        }

        /**
         * <p>
         * Modifies Time to Live custom settings for the table. The options are:
         * </p>
         * <p>
         * • <code>status:enabled</code>
         * </p>
         * <p>
         * • <code>status:disabled</code>
         * </p>
         * <p>
         * The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the
         * table.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring
         * data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param ttl
         *        Modifies Time to Live custom settings for the table. The options are:</p>
         *        <p>
         *        • <code>status:enabled</code>
         *        </p>
         *        <p>
         *        • <code>status:disabled</code>
         *        </p>
         *        <p>
         *        The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it
         *        for the table.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring data by using Amazon
         *        Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(TimeToLive ttl);

        /**
         * <p>
         * Modifies Time to Live custom settings for the table. The options are:
         * </p>
         * <p>
         * • <code>status:enabled</code>
         * </p>
         * <p>
         * • <code>status:disabled</code>
         * </p>
         * <p>
         * The default is <code>status:disabled</code>. After <code>ttl</code> is enabled, you can't disable it for the
         * table.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html">Expiring
         * data by using Amazon Keyspaces Time to Live (TTL)</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeToLive.Builder} avoiding the need to
         * create one manually via {@link TimeToLive#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeToLive.Builder#build()} is called immediately and its result
         * is passed to {@link #ttl(TimeToLive)}.
         * 
         * @param ttl
         *        a consumer that will call methods on {@link TimeToLive.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ttl(TimeToLive)
         */
        default Builder ttl(Consumer<TimeToLive.Builder> ttl) {
            return ttl(TimeToLive.builder().applyMutation(ttl).build());
        }

        /**
         * <p>
         * The default Time to Live setting in seconds for the table.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl"
         * >Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * </p>
         * 
         * @param defaultTimeToLive
         *        The default Time to Live setting in seconds for the table.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl"
         *        >Setting the default TTL value for a table</a> in the <i>Amazon Keyspaces Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultTimeToLive(Integer defaultTimeToLive);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KeyspacesRequest.BuilderImpl implements Builder {
        private String keyspaceName;

        private String tableName;

        private List<ColumnDefinition> addColumns = DefaultSdkAutoConstructList.getInstance();

        private CapacitySpecification capacitySpecification;

        private EncryptionSpecification encryptionSpecification;

        private PointInTimeRecovery pointInTimeRecovery;

        private TimeToLive ttl;

        private Integer defaultTimeToLive;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableRequest model) {
            super(model);
            keyspaceName(model.keyspaceName);
            tableName(model.tableName);
            addColumns(model.addColumns);
            capacitySpecification(model.capacitySpecification);
            encryptionSpecification(model.encryptionSpecification);
            pointInTimeRecovery(model.pointInTimeRecovery);
            ttl(model.ttl);
            defaultTimeToLive(model.defaultTimeToLive);
        }

        public final String getKeyspaceName() {
            return keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final List<ColumnDefinition.Builder> getAddColumns() {
            List<ColumnDefinition.Builder> result = ColumnDefinitionListCopier.copyToBuilder(this.addColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddColumns(Collection<ColumnDefinition.BuilderImpl> addColumns) {
            this.addColumns = ColumnDefinitionListCopier.copyFromBuilder(addColumns);
        }

        @Override
        public final Builder addColumns(Collection<ColumnDefinition> addColumns) {
            this.addColumns = ColumnDefinitionListCopier.copy(addColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addColumns(ColumnDefinition... addColumns) {
            addColumns(Arrays.asList(addColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addColumns(Consumer<ColumnDefinition.Builder>... addColumns) {
            addColumns(Stream.of(addColumns).map(c -> ColumnDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final CapacitySpecification.Builder getCapacitySpecification() {
            return capacitySpecification != null ? capacitySpecification.toBuilder() : null;
        }

        public final void setCapacitySpecification(CapacitySpecification.BuilderImpl capacitySpecification) {
            this.capacitySpecification = capacitySpecification != null ? capacitySpecification.build() : null;
        }

        @Override
        public final Builder capacitySpecification(CapacitySpecification capacitySpecification) {
            this.capacitySpecification = capacitySpecification;
            return this;
        }

        public final EncryptionSpecification.Builder getEncryptionSpecification() {
            return encryptionSpecification != null ? encryptionSpecification.toBuilder() : null;
        }

        public final void setEncryptionSpecification(EncryptionSpecification.BuilderImpl encryptionSpecification) {
            this.encryptionSpecification = encryptionSpecification != null ? encryptionSpecification.build() : null;
        }

        @Override
        public final Builder encryptionSpecification(EncryptionSpecification encryptionSpecification) {
            this.encryptionSpecification = encryptionSpecification;
            return this;
        }

        public final PointInTimeRecovery.Builder getPointInTimeRecovery() {
            return pointInTimeRecovery != null ? pointInTimeRecovery.toBuilder() : null;
        }

        public final void setPointInTimeRecovery(PointInTimeRecovery.BuilderImpl pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery != null ? pointInTimeRecovery.build() : null;
        }

        @Override
        public final Builder pointInTimeRecovery(PointInTimeRecovery pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery;
            return this;
        }

        public final TimeToLive.Builder getTtl() {
            return ttl != null ? ttl.toBuilder() : null;
        }

        public final void setTtl(TimeToLive.BuilderImpl ttl) {
            this.ttl = ttl != null ? ttl.build() : null;
        }

        @Override
        public final Builder ttl(TimeToLive ttl) {
            this.ttl = ttl;
            return this;
        }

        public final Integer getDefaultTimeToLive() {
            return defaultTimeToLive;
        }

        public final void setDefaultTimeToLive(Integer defaultTimeToLive) {
            this.defaultTimeToLive = defaultTimeToLive;
        }

        @Override
        public final Builder defaultTimeToLive(Integer defaultTimeToLive) {
            this.defaultTimeToLive = defaultTimeToLive;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTableRequest build() {
            return new UpdateTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
