/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.launchwizard.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkloadsResponse extends LaunchWizardResponse implements
        ToCopyableBuilder<ListWorkloadsResponse.Builder, ListWorkloadsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListWorkloadsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<WorkloadDataSummary>> WORKLOADS_FIELD = SdkField
            .<List<WorkloadDataSummary>> builder(MarshallingType.LIST)
            .memberName("workloads")
            .getter(getter(ListWorkloadsResponse::workloads))
            .setter(setter(Builder::workloads))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloads").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkloadDataSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkloadDataSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            WORKLOADS_FIELD));

    private final String nextToken;

    private final List<WorkloadDataSummary> workloads;

    private ListWorkloadsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workloads = builder.workloads;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Workloads property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorkloads() {
        return workloads != null && !(workloads instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the workloads.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkloads} method.
     * </p>
     * 
     * @return Information about the workloads.
     */
    public final List<WorkloadDataSummary> workloads() {
        return workloads;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkloads() ? workloads() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkloadsResponse)) {
            return false;
        }
        ListWorkloadsResponse other = (ListWorkloadsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasWorkloads() == other.hasWorkloads()
                && Objects.equals(workloads(), other.workloads());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkloadsResponse").add("NextToken", nextToken())
                .add("Workloads", hasWorkloads() ? workloads() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "workloads":
            return Optional.ofNullable(clazz.cast(workloads()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkloadsResponse, T> g) {
        return obj -> g.apply((ListWorkloadsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LaunchWizardResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWorkloadsResponse> {
        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the workloads.
         * </p>
         * 
         * @param workloads
         *        Information about the workloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloads(Collection<WorkloadDataSummary> workloads);

        /**
         * <p>
         * Information about the workloads.
         * </p>
         * 
         * @param workloads
         *        Information about the workloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloads(WorkloadDataSummary... workloads);

        /**
         * <p>
         * Information about the workloads.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.launchwizard.model.WorkloadDataSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.launchwizard.model.WorkloadDataSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.launchwizard.model.WorkloadDataSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #workloads(List<WorkloadDataSummary>)}.
         * 
         * @param workloads
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.launchwizard.model.WorkloadDataSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workloads(java.util.Collection<WorkloadDataSummary>)
         */
        Builder workloads(Consumer<WorkloadDataSummary.Builder>... workloads);
    }

    static final class BuilderImpl extends LaunchWizardResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<WorkloadDataSummary> workloads = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkloadsResponse model) {
            super(model);
            nextToken(model.nextToken);
            workloads(model.workloads);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WorkloadDataSummary.Builder> getWorkloads() {
            List<WorkloadDataSummary.Builder> result = WorkloadDataSummaryListCopier.copyToBuilder(this.workloads);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkloads(Collection<WorkloadDataSummary.BuilderImpl> workloads) {
            this.workloads = WorkloadDataSummaryListCopier.copyFromBuilder(workloads);
        }

        @Override
        public final Builder workloads(Collection<WorkloadDataSummary> workloads) {
            this.workloads = WorkloadDataSummaryListCopier.copy(workloads);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloads(WorkloadDataSummary... workloads) {
            workloads(Arrays.asList(workloads));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloads(Consumer<WorkloadDataSummary.Builder>... workloads) {
            workloads(Stream.of(workloads).map(c -> WorkloadDataSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkloadsResponse build() {
            return new ListWorkloadsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
