/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.launchwizard;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.launchwizard.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.launchwizard.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.launchwizard.model.DeleteDeploymentRequest;
import software.amazon.awssdk.services.launchwizard.model.DeleteDeploymentResponse;
import software.amazon.awssdk.services.launchwizard.model.GetDeploymentRequest;
import software.amazon.awssdk.services.launchwizard.model.GetDeploymentResponse;
import software.amazon.awssdk.services.launchwizard.model.GetWorkloadRequest;
import software.amazon.awssdk.services.launchwizard.model.GetWorkloadResponse;
import software.amazon.awssdk.services.launchwizard.model.InternalServerException;
import software.amazon.awssdk.services.launchwizard.model.LaunchWizardException;
import software.amazon.awssdk.services.launchwizard.model.ListDeploymentEventsRequest;
import software.amazon.awssdk.services.launchwizard.model.ListDeploymentEventsResponse;
import software.amazon.awssdk.services.launchwizard.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.launchwizard.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.launchwizard.model.ListWorkloadDeploymentPatternsRequest;
import software.amazon.awssdk.services.launchwizard.model.ListWorkloadDeploymentPatternsResponse;
import software.amazon.awssdk.services.launchwizard.model.ListWorkloadsRequest;
import software.amazon.awssdk.services.launchwizard.model.ListWorkloadsResponse;
import software.amazon.awssdk.services.launchwizard.model.ResourceLimitException;
import software.amazon.awssdk.services.launchwizard.model.ResourceNotFoundException;
import software.amazon.awssdk.services.launchwizard.model.ValidationException;
import software.amazon.awssdk.services.launchwizard.paginators.ListDeploymentEventsIterable;
import software.amazon.awssdk.services.launchwizard.paginators.ListDeploymentsIterable;
import software.amazon.awssdk.services.launchwizard.paginators.ListWorkloadDeploymentPatternsIterable;
import software.amazon.awssdk.services.launchwizard.paginators.ListWorkloadsIterable;

/**
 * Service client for accessing AWS Launch Wizard. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Launch Wizard offers a guided way of sizing, configuring, and deploying Amazon Web Services resources for third party
 * applications, such as Microsoft SQL Server Always On and HANA based SAP systems, without the need to manually
 * identify and provision individual Amazon Web Services resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LaunchWizardClient extends AwsClient {
    String SERVICE_NAME = "launchwizard";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "launchwizard";

    /**
     * <p>
     * Creates a deployment for the given workload. Deployments created by this operation are not available in the
     * Launch Wizard console to use the <code>Clone deployment</code> action on.
     * </p>
     *
     * @param createDeploymentRequest
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws ResourceLimitException
     *         You have exceeded an Launch Wizard resource limit. For example, you might have too many deployments in
     *         progress.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         The specified workload or deployment resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/CreateDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeploymentResponse createDeployment(CreateDeploymentRequest createDeploymentRequest)
            throws ResourceLimitException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LaunchWizardException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a deployment for the given workload. Deployments created by this operation are not available in the
     * Launch Wizard console to use the <code>Clone deployment</code> action on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDeploymentRequest#builder()}
     * </p>
     *
     * @param createDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.launchwizard.model.CreateDeploymentRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDeployment operation returned by the service.
     * @throws ResourceLimitException
     *         You have exceeded an Launch Wizard resource limit. For example, you might have too many deployments in
     *         progress.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         The specified workload or deployment resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/CreateDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDeploymentResponse createDeployment(Consumer<CreateDeploymentRequest.Builder> createDeploymentRequest)
            throws ResourceLimitException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LaunchWizardException {
        return createDeployment(CreateDeploymentRequest.builder().applyMutation(createDeploymentRequest).build());
    }

    /**
     * <p>
     * Deletes a deployment.
     * </p>
     *
     * @param deleteDeploymentRequest
     * @return Result of the DeleteDeployment operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         The specified workload or deployment resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.DeleteDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/DeleteDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDeploymentResponse deleteDeployment(DeleteDeploymentRequest deleteDeploymentRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LaunchWizardException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeploymentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDeploymentRequest#builder()}
     * </p>
     *
     * @param deleteDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.launchwizard.model.DeleteDeploymentRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDeployment operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         The specified workload or deployment resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.DeleteDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/DeleteDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDeploymentResponse deleteDeployment(Consumer<DeleteDeploymentRequest.Builder> deleteDeploymentRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LaunchWizardException {
        return deleteDeployment(DeleteDeploymentRequest.builder().applyMutation(deleteDeploymentRequest).build());
    }

    /**
     * <p>
     * Returns information about the deployment.
     * </p>
     *
     * @param getDeploymentRequest
     * @return Result of the GetDeployment operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         The specified workload or deployment resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.GetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/GetDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDeploymentResponse getDeployment(GetDeploymentRequest getDeploymentRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, LaunchWizardException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeploymentRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeploymentRequest#builder()}
     * </p>
     *
     * @param getDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.launchwizard.model.GetDeploymentRequest.Builder} to create a
     *        request.
     * @return Result of the GetDeployment operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         The specified workload or deployment resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.GetDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/GetDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDeploymentResponse getDeployment(Consumer<GetDeploymentRequest.Builder> getDeploymentRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LaunchWizardException {
        return getDeployment(GetDeploymentRequest.builder().applyMutation(getDeploymentRequest).build());
    }

    /**
     * <p>
     * Returns information about a workload.
     * </p>
     *
     * @param getWorkloadRequest
     * @return Result of the GetWorkload operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         The specified workload or deployment resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.GetWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/GetWorkload" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWorkloadResponse getWorkload(GetWorkloadRequest getWorkloadRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, LaunchWizardException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a workload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkloadRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkloadRequest#builder()}
     * </p>
     *
     * @param getWorkloadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.launchwizard.model.GetWorkloadRequest.Builder} to create a request.
     * @return Result of the GetWorkload operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         The specified workload or deployment resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.GetWorkload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/GetWorkload" target="_top">AWS API
     *      Documentation</a>
     */
    default GetWorkloadResponse getWorkload(Consumer<GetWorkloadRequest.Builder> getWorkloadRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LaunchWizardException {
        return getWorkload(GetWorkloadRequest.builder().applyMutation(getWorkloadRequest).build());
    }

    /**
     * <p>
     * Lists the events of a deployment.
     * </p>
     *
     * @param listDeploymentEventsRequest
     * @return Result of the ListDeploymentEvents operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         The specified workload or deployment resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.ListDeploymentEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListDeploymentEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentEventsResponse listDeploymentEvents(ListDeploymentEventsRequest listDeploymentEventsRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LaunchWizardException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the events of a deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentEventsRequest#builder()}
     * </p>
     *
     * @param listDeploymentEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.launchwizard.model.ListDeploymentEventsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDeploymentEvents operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         The specified workload or deployment resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.ListDeploymentEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListDeploymentEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentEventsResponse listDeploymentEvents(
            Consumer<ListDeploymentEventsRequest.Builder> listDeploymentEventsRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, LaunchWizardException {
        return listDeploymentEvents(ListDeploymentEventsRequest.builder().applyMutation(listDeploymentEventsRequest).build());
    }

    /**
     * <p>
     * Lists the events of a deployment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentEvents(software.amazon.awssdk.services.launchwizard.model.ListDeploymentEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.launchwizard.paginators.ListDeploymentEventsIterable responses = client.listDeploymentEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.launchwizard.paginators.ListDeploymentEventsIterable responses = client
     *             .listDeploymentEventsPaginator(request);
     *     for (software.amazon.awssdk.services.launchwizard.model.ListDeploymentEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.launchwizard.paginators.ListDeploymentEventsIterable responses = client.listDeploymentEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentEvents(software.amazon.awssdk.services.launchwizard.model.ListDeploymentEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeploymentEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         The specified workload or deployment resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.ListDeploymentEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListDeploymentEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentEventsIterable listDeploymentEventsPaginator(ListDeploymentEventsRequest listDeploymentEventsRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LaunchWizardException {
        return new ListDeploymentEventsIterable(this, listDeploymentEventsRequest);
    }

    /**
     * <p>
     * Lists the events of a deployment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentEvents(software.amazon.awssdk.services.launchwizard.model.ListDeploymentEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.launchwizard.paginators.ListDeploymentEventsIterable responses = client.listDeploymentEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.launchwizard.paginators.ListDeploymentEventsIterable responses = client
     *             .listDeploymentEventsPaginator(request);
     *     for (software.amazon.awssdk.services.launchwizard.model.ListDeploymentEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.launchwizard.paginators.ListDeploymentEventsIterable responses = client.listDeploymentEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentEvents(software.amazon.awssdk.services.launchwizard.model.ListDeploymentEventsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentEventsRequest#builder()}
     * </p>
     *
     * @param listDeploymentEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.launchwizard.model.ListDeploymentEventsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         The specified workload or deployment resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.ListDeploymentEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListDeploymentEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeploymentEventsIterable listDeploymentEventsPaginator(
            Consumer<ListDeploymentEventsRequest.Builder> listDeploymentEventsRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, LaunchWizardException {
        return listDeploymentEventsPaginator(ListDeploymentEventsRequest.builder().applyMutation(listDeploymentEventsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the deployments that have been created.
     * </p>
     *
     * @param listDeploymentsRequest
     * @return Result of the ListDeployments operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentsResponse listDeployments(ListDeploymentsRequest listDeploymentsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, LaunchWizardException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the deployments that have been created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeploymentsRequest#builder()}
     * </p>
     *
     * @param listDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.launchwizard.model.ListDeploymentsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDeployments operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentsResponse listDeployments(Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, LaunchWizardException {
        return listDeployments(ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest).build());
    }

    /**
     * <p>
     * Lists the deployments that have been created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeployments(software.amazon.awssdk.services.launchwizard.model.ListDeploymentsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.launchwizard.paginators.ListDeploymentsIterable responses = client.listDeploymentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.launchwizard.paginators.ListDeploymentsIterable responses = client
     *             .listDeploymentsPaginator(request);
     *     for (software.amazon.awssdk.services.launchwizard.model.ListDeploymentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.launchwizard.paginators.ListDeploymentsIterable responses = client.listDeploymentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeployments(software.amazon.awssdk.services.launchwizard.model.ListDeploymentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeploymentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentsIterable listDeploymentsPaginator(ListDeploymentsRequest listDeploymentsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, LaunchWizardException {
        return new ListDeploymentsIterable(this, listDeploymentsRequest);
    }

    /**
     * <p>
     * Lists the deployments that have been created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeployments(software.amazon.awssdk.services.launchwizard.model.ListDeploymentsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.launchwizard.paginators.ListDeploymentsIterable responses = client.listDeploymentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.launchwizard.paginators.ListDeploymentsIterable responses = client
     *             .listDeploymentsPaginator(request);
     *     for (software.amazon.awssdk.services.launchwizard.model.ListDeploymentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.launchwizard.paginators.ListDeploymentsIterable responses = client.listDeploymentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeployments(software.amazon.awssdk.services.launchwizard.model.ListDeploymentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeploymentsRequest#builder()}
     * </p>
     *
     * @param listDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.launchwizard.model.ListDeploymentsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentsIterable listDeploymentsPaginator(Consumer<ListDeploymentsRequest.Builder> listDeploymentsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, LaunchWizardException {
        return listDeploymentsPaginator(ListDeploymentsRequest.builder().applyMutation(listDeploymentsRequest).build());
    }

    /**
     * <p>
     * Lists the workload deployment patterns.
     * </p>
     *
     * @param listWorkloadDeploymentPatternsRequest
     * @return Result of the ListWorkloadDeploymentPatterns operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         The specified workload or deployment resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.ListWorkloadDeploymentPatterns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListWorkloadDeploymentPatterns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadDeploymentPatternsResponse listWorkloadDeploymentPatterns(
            ListWorkloadDeploymentPatternsRequest listWorkloadDeploymentPatternsRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, LaunchWizardException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the workload deployment patterns.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadDeploymentPatternsRequest.Builder}
     * avoiding the need to create one manually via {@link ListWorkloadDeploymentPatternsRequest#builder()}
     * </p>
     *
     * @param listWorkloadDeploymentPatternsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.launchwizard.model.ListWorkloadDeploymentPatternsRequest.Builder}
     *        to create a request.
     * @return Result of the ListWorkloadDeploymentPatterns operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         The specified workload or deployment resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.ListWorkloadDeploymentPatterns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListWorkloadDeploymentPatterns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadDeploymentPatternsResponse listWorkloadDeploymentPatterns(
            Consumer<ListWorkloadDeploymentPatternsRequest.Builder> listWorkloadDeploymentPatternsRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LaunchWizardException {
        return listWorkloadDeploymentPatterns(ListWorkloadDeploymentPatternsRequest.builder()
                .applyMutation(listWorkloadDeploymentPatternsRequest).build());
    }

    /**
     * <p>
     * Lists the workload deployment patterns.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkloadDeploymentPatterns(software.amazon.awssdk.services.launchwizard.model.ListWorkloadDeploymentPatternsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.launchwizard.paginators.ListWorkloadDeploymentPatternsIterable responses = client.listWorkloadDeploymentPatternsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.launchwizard.paginators.ListWorkloadDeploymentPatternsIterable responses = client
     *             .listWorkloadDeploymentPatternsPaginator(request);
     *     for (software.amazon.awssdk.services.launchwizard.model.ListWorkloadDeploymentPatternsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.launchwizard.paginators.ListWorkloadDeploymentPatternsIterable responses = client.listWorkloadDeploymentPatternsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadDeploymentPatterns(software.amazon.awssdk.services.launchwizard.model.ListWorkloadDeploymentPatternsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkloadDeploymentPatternsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         The specified workload or deployment resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.ListWorkloadDeploymentPatterns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListWorkloadDeploymentPatterns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadDeploymentPatternsIterable listWorkloadDeploymentPatternsPaginator(
            ListWorkloadDeploymentPatternsRequest listWorkloadDeploymentPatternsRequest) throws InternalServerException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, LaunchWizardException {
        return new ListWorkloadDeploymentPatternsIterable(this, listWorkloadDeploymentPatternsRequest);
    }

    /**
     * <p>
     * Lists the workload deployment patterns.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkloadDeploymentPatterns(software.amazon.awssdk.services.launchwizard.model.ListWorkloadDeploymentPatternsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.launchwizard.paginators.ListWorkloadDeploymentPatternsIterable responses = client.listWorkloadDeploymentPatternsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.launchwizard.paginators.ListWorkloadDeploymentPatternsIterable responses = client
     *             .listWorkloadDeploymentPatternsPaginator(request);
     *     for (software.amazon.awssdk.services.launchwizard.model.ListWorkloadDeploymentPatternsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.launchwizard.paginators.ListWorkloadDeploymentPatternsIterable responses = client.listWorkloadDeploymentPatternsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloadDeploymentPatterns(software.amazon.awssdk.services.launchwizard.model.ListWorkloadDeploymentPatternsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadDeploymentPatternsRequest.Builder}
     * avoiding the need to create one manually via {@link ListWorkloadDeploymentPatternsRequest#builder()}
     * </p>
     *
     * @param listWorkloadDeploymentPatternsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.launchwizard.model.ListWorkloadDeploymentPatternsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ResourceNotFoundException
     *         The specified workload or deployment resource can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.ListWorkloadDeploymentPatterns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListWorkloadDeploymentPatterns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkloadDeploymentPatternsIterable listWorkloadDeploymentPatternsPaginator(
            Consumer<ListWorkloadDeploymentPatternsRequest.Builder> listWorkloadDeploymentPatternsRequest)
            throws InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LaunchWizardException {
        return listWorkloadDeploymentPatternsPaginator(ListWorkloadDeploymentPatternsRequest.builder()
                .applyMutation(listWorkloadDeploymentPatternsRequest).build());
    }

    /**
     * <p>
     * Lists the workloads.
     * </p>
     *
     * @param listWorkloadsRequest
     * @return Result of the ListWorkloads operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.ListWorkloads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListWorkloads" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkloadsResponse listWorkloads(ListWorkloadsRequest listWorkloadsRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, LaunchWizardException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the workloads.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkloadsRequest#builder()}
     * </p>
     *
     * @param listWorkloadsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.launchwizard.model.ListWorkloadsRequest.Builder} to create a
     *        request.
     * @return Result of the ListWorkloads operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.ListWorkloads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListWorkloads" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkloadsResponse listWorkloads(Consumer<ListWorkloadsRequest.Builder> listWorkloadsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, LaunchWizardException {
        return listWorkloads(ListWorkloadsRequest.builder().applyMutation(listWorkloadsRequest).build());
    }

    /**
     * <p>
     * Lists the workloads.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkloads(software.amazon.awssdk.services.launchwizard.model.ListWorkloadsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.launchwizard.paginators.ListWorkloadsIterable responses = client.listWorkloadsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.launchwizard.paginators.ListWorkloadsIterable responses = client
     *             .listWorkloadsPaginator(request);
     *     for (software.amazon.awssdk.services.launchwizard.model.ListWorkloadsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.launchwizard.paginators.ListWorkloadsIterable responses = client.listWorkloadsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloads(software.amazon.awssdk.services.launchwizard.model.ListWorkloadsRequest)} operation.</b>
     * </p>
     *
     * @param listWorkloadsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.ListWorkloads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListWorkloads" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkloadsIterable listWorkloadsPaginator(ListWorkloadsRequest listWorkloadsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, LaunchWizardException {
        return new ListWorkloadsIterable(this, listWorkloadsRequest);
    }

    /**
     * <p>
     * Lists the workloads.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorkloads(software.amazon.awssdk.services.launchwizard.model.ListWorkloadsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.launchwizard.paginators.ListWorkloadsIterable responses = client.listWorkloadsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.launchwizard.paginators.ListWorkloadsIterable responses = client
     *             .listWorkloadsPaginator(request);
     *     for (software.amazon.awssdk.services.launchwizard.model.ListWorkloadsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.launchwizard.paginators.ListWorkloadsIterable responses = client.listWorkloadsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkloads(software.amazon.awssdk.services.launchwizard.model.ListWorkloadsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkloadsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkloadsRequest#builder()}
     * </p>
     *
     * @param listWorkloadsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.launchwizard.model.ListWorkloadsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details
     *         by posting a question on <a href="https://repost.aws/">re:Post</a>.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LaunchWizardException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LaunchWizardClient.ListWorkloads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/launch-wizard-2018-05-10/ListWorkloads" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkloadsIterable listWorkloadsPaginator(Consumer<ListWorkloadsRequest.Builder> listWorkloadsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, LaunchWizardException {
        return listWorkloadsPaginator(ListWorkloadsRequest.builder().applyMutation(listWorkloadsRequest).build());
    }

    /**
     * Create a {@link LaunchWizardClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LaunchWizardClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LaunchWizardClient}.
     */
    static LaunchWizardClientBuilder builder() {
        return new DefaultLaunchWizardClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default LaunchWizardServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
