/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.launchwizard.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the deployment data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentDataSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentDataSummary.Builder, DeploymentDataSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DeploymentDataSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DeploymentDataSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DeploymentDataSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PATTERN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("patternName").getter(getter(DeploymentDataSummary::patternName)).setter(setter(Builder::patternName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patternName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DeploymentDataSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workloadName").getter(getter(DeploymentDataSummary::workloadName)).setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, ID_FIELD,
            NAME_FIELD, PATTERN_NAME_FIELD, STATUS_FIELD, WORKLOAD_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String id;

    private final String name;

    private final String patternName;

    private final String status;

    private final String workloadName;

    private DeploymentDataSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.name = builder.name;
        this.patternName = builder.patternName;
        this.status = builder.status;
        this.workloadName = builder.workloadName;
    }

    /**
     * <p>
     * The time the deployment was created.
     * </p>
     * 
     * @return The time the deployment was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ID of the deployment.
     * </p>
     * 
     * @return The ID of the deployment.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the deployment
     * </p>
     * 
     * @return The name of the deployment
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the workload deployment pattern.
     * </p>
     * 
     * @return The name of the workload deployment pattern.
     */
    public final String patternName() {
        return patternName;
    }

    /**
     * <p>
     * The status of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deployment.
     * @see DeploymentStatus
     */
    public final DeploymentStatus status() {
        return DeploymentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the deployment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deployment.
     * @see DeploymentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The name of the workload.
     * </p>
     * 
     * @return The name of the workload.
     */
    public final String workloadName() {
        return workloadName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(patternName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentDataSummary)) {
            return false;
        }
        DeploymentDataSummary other = (DeploymentDataSummary) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(patternName(), other.patternName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(workloadName(), other.workloadName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentDataSummary").add("CreatedAt", createdAt()).add("Id", id()).add("Name", name())
                .add("PatternName", patternName()).add("Status", statusAsString()).add("WorkloadName", workloadName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "patternName":
            return Optional.ofNullable(clazz.cast(patternName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "workloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentDataSummary, T> g) {
        return obj -> g.apply((DeploymentDataSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentDataSummary> {
        /**
         * <p>
         * The time the deployment was created.
         * </p>
         * 
         * @param createdAt
         *        The time the deployment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ID of the deployment.
         * </p>
         * 
         * @param id
         *        The ID of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the deployment
         * </p>
         * 
         * @param name
         *        The name of the deployment
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the workload deployment pattern.
         * </p>
         * 
         * @param patternName
         *        The name of the workload deployment pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patternName(String patternName);

        /**
         * <p>
         * The status of the deployment.
         * </p>
         * 
         * @param status
         *        The status of the deployment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the deployment.
         * </p>
         * 
         * @param status
         *        The status of the deployment.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(DeploymentStatus status);

        /**
         * <p>
         * The name of the workload.
         * </p>
         * 
         * @param workloadName
         *        The name of the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String id;

        private String name;

        private String patternName;

        private String status;

        private String workloadName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentDataSummary model) {
            createdAt(model.createdAt);
            id(model.id);
            name(model.name);
            patternName(model.patternName);
            status(model.status);
            workloadName(model.workloadName);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPatternName() {
            return patternName;
        }

        public final void setPatternName(String patternName) {
            this.patternName = patternName;
        }

        @Override
        public final Builder patternName(String patternName) {
            this.patternName = patternName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        @Override
        public DeploymentDataSummary build() {
            return new DeploymentDataSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
