/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSlotTypeVersionsResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetSlotTypeVersionsResponse.Builder, GetSlotTypeVersionsResponse> {
    private static final SdkField<List<SlotTypeMetadata>> SLOT_TYPES_FIELD = SdkField
            .<List<SlotTypeMetadata>> builder(MarshallingType.LIST)
            .memberName("slotTypes")
            .getter(getter(GetSlotTypeVersionsResponse::slotTypes))
            .setter(setter(Builder::slotTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SlotTypeMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(SlotTypeMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetSlotTypeVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_TYPES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SlotTypeMetadata> slotTypes;

    private final String nextToken;

    private GetSlotTypeVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.slotTypes = builder.slotTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SlotTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSlotTypes() {
        return slotTypes != null && !(slotTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>SlotTypeMetadata</code> objects, one for each numbered version of the slot type plus one for
     * the <code>$LATEST</code> version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlotTypes} method.
     * </p>
     * 
     * @return An array of <code>SlotTypeMetadata</code> objects, one for each numbered version of the slot type plus
     *         one for the <code>$LATEST</code> version.
     */
    public final List<SlotTypeMetadata> slotTypes() {
        return slotTypes;
    }

    /**
     * <p>
     * A pagination token for fetching the next page of slot type versions. If the response to this call is truncated,
     * Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify the pagination
     * token in the next request.
     * </p>
     * 
     * @return A pagination token for fetching the next page of slot type versions. If the response to this call is
     *         truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions,
     *         specify the pagination token in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSlotTypes() ? slotTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSlotTypeVersionsResponse)) {
            return false;
        }
        GetSlotTypeVersionsResponse other = (GetSlotTypeVersionsResponse) obj;
        return hasSlotTypes() == other.hasSlotTypes() && Objects.equals(slotTypes(), other.slotTypes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSlotTypeVersionsResponse").add("SlotTypes", hasSlotTypes() ? slotTypes() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotTypes":
            return Optional.ofNullable(clazz.cast(slotTypes()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSlotTypeVersionsResponse, T> g) {
        return obj -> g.apply((GetSlotTypeVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelBuildingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSlotTypeVersionsResponse> {
        /**
         * <p>
         * An array of <code>SlotTypeMetadata</code> objects, one for each numbered version of the slot type plus one
         * for the <code>$LATEST</code> version.
         * </p>
         * 
         * @param slotTypes
         *        An array of <code>SlotTypeMetadata</code> objects, one for each numbered version of the slot type plus
         *        one for the <code>$LATEST</code> version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypes(Collection<SlotTypeMetadata> slotTypes);

        /**
         * <p>
         * An array of <code>SlotTypeMetadata</code> objects, one for each numbered version of the slot type plus one
         * for the <code>$LATEST</code> version.
         * </p>
         * 
         * @param slotTypes
         *        An array of <code>SlotTypeMetadata</code> objects, one for each numbered version of the slot type plus
         *        one for the <code>$LATEST</code> version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypes(SlotTypeMetadata... slotTypes);

        /**
         * <p>
         * An array of <code>SlotTypeMetadata</code> objects, one for each numbered version of the slot type plus one
         * for the <code>$LATEST</code> version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.SlotTypeMetadata.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.SlotTypeMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelbuilding.model.SlotTypeMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #slotTypes(List<SlotTypeMetadata>)}.
         * 
         * @param slotTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelbuilding.model.SlotTypeMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotTypes(java.util.Collection<SlotTypeMetadata>)
         */
        Builder slotTypes(Consumer<SlotTypeMetadata.Builder>... slotTypes);

        /**
         * <p>
         * A pagination token for fetching the next page of slot type versions. If the response to this call is
         * truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions, specify
         * the pagination token in the next request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token for fetching the next page of slot type versions. If the response to this call is
         *        truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of versions,
         *        specify the pagination token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private List<SlotTypeMetadata> slotTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSlotTypeVersionsResponse model) {
            super(model);
            slotTypes(model.slotTypes);
            nextToken(model.nextToken);
        }

        public final List<SlotTypeMetadata.Builder> getSlotTypes() {
            List<SlotTypeMetadata.Builder> result = SlotTypeMetadataListCopier.copyToBuilder(this.slotTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlotTypes(Collection<SlotTypeMetadata.BuilderImpl> slotTypes) {
            this.slotTypes = SlotTypeMetadataListCopier.copyFromBuilder(slotTypes);
        }

        @Override
        public final Builder slotTypes(Collection<SlotTypeMetadata> slotTypes) {
            this.slotTypes = SlotTypeMetadataListCopier.copy(slotTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypes(SlotTypeMetadata... slotTypes) {
            slotTypes(Arrays.asList(slotTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypes(Consumer<SlotTypeMetadata.Builder>... slotTypes) {
            slotTypes(Stream.of(slotTypes).map(c -> SlotTypeMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetSlotTypeVersionsResponse build() {
            return new GetSlotTypeVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
