/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration information for the AMAZON.KendraSearchIntent intent. When you use this intent, Amazon Lex
 * searches the specified Amazon Kendra index and returns documents from the index that match the user's utterance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KendraConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KendraConfiguration.Builder, KendraConfiguration> {
    private static final SdkField<String> KENDRA_INDEX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kendraIndex").getter(getter(KendraConfiguration::kendraIndex)).setter(setter(Builder::kendraIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraIndex").build()).build();

    private static final SdkField<Boolean> QUERY_FILTER_STRING_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("queryFilterStringEnabled")
            .getter(getter(KendraConfiguration::queryFilterStringEnabled)).setter(setter(Builder::queryFilterStringEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryFilterStringEnabled").build())
            .build();

    private static final SdkField<String> QUERY_FILTER_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryFilterString").getter(getter(KendraConfiguration::queryFilterString))
            .setter(setter(Builder::queryFilterString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryFilterString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KENDRA_INDEX_FIELD,
            QUERY_FILTER_STRING_ENABLED_FIELD, QUERY_FILTER_STRING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kendraIndex;

    private final Boolean queryFilterStringEnabled;

    private final String queryFilterString;

    private KendraConfiguration(BuilderImpl builder) {
        this.kendraIndex = builder.kendraIndex;
        this.queryFilterStringEnabled = builder.queryFilterStringEnabled;
        this.queryFilterString = builder.queryFilterString;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the AMAZON.KendraSearchIntent intent to
     * search. The index must be in the same account and Region as the Amazon Lex bot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the AMAZON.KendraSearchIntent
     *         intent to search. The index must be in the same account and Region as the Amazon Lex bot.
     */
    public final String kendraIndex() {
        return kendraIndex;
    }

    /**
     * <p>
     * Determines whether the AMAZON.KendraSearchIntent intent uses a custom query string to query the Amazon Kendra
     * index.
     * </p>
     * 
     * @return Determines whether the AMAZON.KendraSearchIntent intent uses a custom query string to query the Amazon
     *         Kendra index.
     */
    public final Boolean queryFilterStringEnabled() {
        return queryFilterStringEnabled;
    }

    /**
     * <p>
     * A query filter that Amazon Lex sends to Amazon Kendra to filter the response from a query. The filter is in the
     * format defined by Amazon Kendra. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/filtering.html">Filtering queries</a>.
     * </p>
     * 
     * @return A query filter that Amazon Lex sends to Amazon Kendra to filter the response from a query. The filter is
     *         in the format defined by Amazon Kendra. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/filtering.html">Filtering queries</a>.
     */
    public final String queryFilterString() {
        return queryFilterString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kendraIndex());
        hashCode = 31 * hashCode + Objects.hashCode(queryFilterStringEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(queryFilterString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KendraConfiguration)) {
            return false;
        }
        KendraConfiguration other = (KendraConfiguration) obj;
        return Objects.equals(kendraIndex(), other.kendraIndex())
                && Objects.equals(queryFilterStringEnabled(), other.queryFilterStringEnabled())
                && Objects.equals(queryFilterString(), other.queryFilterString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KendraConfiguration").add("KendraIndex", kendraIndex())
                .add("QueryFilterStringEnabled", queryFilterStringEnabled()).add("QueryFilterString", queryFilterString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kendraIndex":
            return Optional.ofNullable(clazz.cast(kendraIndex()));
        case "queryFilterStringEnabled":
            return Optional.ofNullable(clazz.cast(queryFilterStringEnabled()));
        case "queryFilterString":
            return Optional.ofNullable(clazz.cast(queryFilterString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KendraConfiguration, T> g) {
        return obj -> g.apply((KendraConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KendraConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the AMAZON.KendraSearchIntent intent
         * to search. The index must be in the same account and Region as the Amazon Lex bot.
         * </p>
         * 
         * @param kendraIndex
         *        The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the AMAZON.KendraSearchIntent
         *        intent to search. The index must be in the same account and Region as the Amazon Lex bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kendraIndex(String kendraIndex);

        /**
         * <p>
         * Determines whether the AMAZON.KendraSearchIntent intent uses a custom query string to query the Amazon Kendra
         * index.
         * </p>
         * 
         * @param queryFilterStringEnabled
         *        Determines whether the AMAZON.KendraSearchIntent intent uses a custom query string to query the Amazon
         *        Kendra index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryFilterStringEnabled(Boolean queryFilterStringEnabled);

        /**
         * <p>
         * A query filter that Amazon Lex sends to Amazon Kendra to filter the response from a query. The filter is in
         * the format defined by Amazon Kendra. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/filtering.html">Filtering queries</a>.
         * </p>
         * 
         * @param queryFilterString
         *        A query filter that Amazon Lex sends to Amazon Kendra to filter the response from a query. The filter
         *        is in the format defined by Amazon Kendra. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/filtering.html">Filtering queries</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryFilterString(String queryFilterString);
    }

    static final class BuilderImpl implements Builder {
        private String kendraIndex;

        private Boolean queryFilterStringEnabled;

        private String queryFilterString;

        private BuilderImpl() {
        }

        private BuilderImpl(KendraConfiguration model) {
            kendraIndex(model.kendraIndex);
            queryFilterStringEnabled(model.queryFilterStringEnabled);
            queryFilterString(model.queryFilterString);
        }

        public final String getKendraIndex() {
            return kendraIndex;
        }

        public final void setKendraIndex(String kendraIndex) {
            this.kendraIndex = kendraIndex;
        }

        @Override
        public final Builder kendraIndex(String kendraIndex) {
            this.kendraIndex = kendraIndex;
            return this;
        }

        public final Boolean getQueryFilterStringEnabled() {
            return queryFilterStringEnabled;
        }

        public final void setQueryFilterStringEnabled(Boolean queryFilterStringEnabled) {
            this.queryFilterStringEnabled = queryFilterStringEnabled;
        }

        @Override
        public final Builder queryFilterStringEnabled(Boolean queryFilterStringEnabled) {
            this.queryFilterStringEnabled = queryFilterStringEnabled;
            return this;
        }

        public final String getQueryFilterString() {
            return queryFilterString;
        }

        public final void setQueryFilterString(String queryFilterString) {
            this.queryFilterString = queryFilterString;
        }

        @Override
        public final Builder queryFilterString(String queryFilterString) {
            this.queryFilterString = queryFilterString;
            return this;
        }

        @Override
        public KendraConfiguration build() {
            return new KendraConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
