/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotTypesResponse;

public class ListSlotTypesIterable
implements SdkIterable<ListSlotTypesResponse> {
    private final LexModelsV2Client client;
    private final ListSlotTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSlotTypesIterable(LexModelsV2Client client, ListSlotTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSlotTypesResponseFetcher();
    }

    public Iterator<ListSlotTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSlotTypesResponseFetcher
    implements SyncPageFetcher<ListSlotTypesResponse> {
        private ListSlotTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListSlotTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSlotTypesResponse nextPage(ListSlotTypesResponse previousPage) {
            if (previousPage == null) {
                return ListSlotTypesIterable.this.client.listSlotTypes(ListSlotTypesIterable.this.firstRequest);
            }
            return ListSlotTypesIterable.this.client.listSlotTypes((ListSlotTypesRequest)((Object)ListSlotTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

