/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the Amazon Bedrock model used to interpret the prompt used in descriptive bot building.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BedrockModelSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<BedrockModelSpecification.Builder, BedrockModelSpecification> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(BedrockModelSpecification::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelArn;

    private BedrockModelSpecification(BuilderImpl builder) {
        this.modelArn = builder.modelArn;
    }

    /**
     * <p>
     * The ARN of the foundation model used in descriptive bot building.
     * </p>
     * 
     * @return The ARN of the foundation model used in descriptive bot building.
     */
    public final String modelArn() {
        return modelArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BedrockModelSpecification)) {
            return false;
        }
        BedrockModelSpecification other = (BedrockModelSpecification) obj;
        return Objects.equals(modelArn(), other.modelArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BedrockModelSpecification").add("ModelArn", modelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BedrockModelSpecification, T> g) {
        return obj -> g.apply((BedrockModelSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BedrockModelSpecification> {
        /**
         * <p>
         * The ARN of the foundation model used in descriptive bot building.
         * </p>
         * 
         * @param modelArn
         *        The ARN of the foundation model used in descriptive bot building.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);
    }

    static final class BuilderImpl implements Builder {
        private String modelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BedrockModelSpecification model) {
            modelArn(model.modelArn);
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        @Override
        public BedrockModelSpecification build() {
            return new BedrockModelSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
