/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResourcePolicyStatementResponse extends LexModelsV2Response implements
        ToCopyableBuilder<CreateResourcePolicyStatementResponse.Builder, CreateResourcePolicyStatementResponse> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(CreateResourcePolicyStatementResponse::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionId").getter(getter(CreateResourcePolicyStatementResponse::revisionId))
            .setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            REVISION_ID_FIELD));

    private final String resourceArn;

    private final String revisionId;

    private CreateResourcePolicyStatementResponse(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The current revision of the resource policy. Use the revision ID to make sure that you are updating the most
     * current version of a resource policy when you add a policy statement to a resource, delete a resource, or update
     * a resource.
     * </p>
     * 
     * @return The current revision of the resource policy. Use the revision ID to make sure that you are updating the
     *         most current version of a resource policy when you add a policy statement to a resource, delete a
     *         resource, or update a resource.
     */
    public final String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourcePolicyStatementResponse)) {
            return false;
        }
        CreateResourcePolicyStatementResponse other = (CreateResourcePolicyStatementResponse) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResourcePolicyStatementResponse").add("ResourceArn", resourceArn())
                .add("RevisionId", revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourcePolicyStatementResponse, T> g) {
        return obj -> g.apply((CreateResourcePolicyStatementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateResourcePolicyStatementResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The current revision of the resource policy. Use the revision ID to make sure that you are updating the most
         * current version of a resource policy when you add a policy statement to a resource, delete a resource, or
         * update a resource.
         * </p>
         * 
         * @param revisionId
         *        The current revision of the resource policy. Use the revision ID to make sure that you are updating
         *        the most current version of a resource policy when you add a policy statement to a resource, delete a
         *        resource, or update a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String resourceArn;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourcePolicyStatementResponse model) {
            super(model);
            resourceArn(model.resourceArn);
            revisionId(model.revisionId);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        @Override
        public CreateResourcePolicyStatementResponse build() {
            return new CreateResourcePolicyStatementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
