/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBotResourceGenerationResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DescribeBotResourceGenerationResponse.Builder, DescribeBotResourceGenerationResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(DescribeBotResourceGenerationResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(DescribeBotResourceGenerationResponse::botVersion))
            .setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(DescribeBotResourceGenerationResponse::localeId))
            .setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<String> GENERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generationId").getter(getter(DescribeBotResourceGenerationResponse::generationId))
            .setter(setter(Builder::generationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationId").build()).build();

    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureReasons")
            .getter(getter(DescribeBotResourceGenerationResponse::failureReasons))
            .setter(setter(Builder::failureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GENERATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generationStatus").getter(getter(DescribeBotResourceGenerationResponse::generationStatusAsString))
            .setter(setter(Builder::generationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationStatus").build()).build();

    private static final SdkField<String> GENERATION_INPUT_PROMPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generationInputPrompt").getter(getter(DescribeBotResourceGenerationResponse::generationInputPrompt))
            .setter(setter(Builder::generationInputPrompt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationInputPrompt").build())
            .build();

    private static final SdkField<String> GENERATED_BOT_LOCALE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generatedBotLocaleUrl").getter(getter(DescribeBotResourceGenerationResponse::generatedBotLocaleUrl))
            .setter(setter(Builder::generatedBotLocaleUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedBotLocaleUrl").build())
            .build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(DescribeBotResourceGenerationResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(DescribeBotResourceGenerationResponse::modelArn))
            .setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(DescribeBotResourceGenerationResponse::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, GENERATION_ID_FIELD, FAILURE_REASONS_FIELD, GENERATION_STATUS_FIELD,
            GENERATION_INPUT_PROMPT_FIELD, GENERATED_BOT_LOCALE_URL_FIELD, CREATION_DATE_TIME_FIELD, MODEL_ARN_FIELD,
            LAST_UPDATED_DATE_TIME_FIELD));

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final String generationId;

    private final List<String> failureReasons;

    private final String generationStatus;

    private final String generationInputPrompt;

    private final String generatedBotLocaleUrl;

    private final Instant creationDateTime;

    private final String modelArn;

    private final Instant lastUpdatedDateTime;

    private DescribeBotResourceGenerationResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.generationId = builder.generationId;
        this.failureReasons = builder.failureReasons;
        this.generationStatus = builder.generationStatus;
        this.generationInputPrompt = builder.generationInputPrompt;
        this.generatedBotLocaleUrl = builder.generatedBotLocaleUrl;
        this.creationDateTime = builder.creationDateTime;
        this.modelArn = builder.modelArn;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The unique identifier of the bot for which the generation request was made.
     * </p>
     * 
     * @return The unique identifier of the bot for which the generation request was made.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot for which the generation request was made.
     * </p>
     * 
     * @return The version of the bot for which the generation request was made.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The locale of the bot for which the generation request was made.
     * </p>
     * 
     * @return The locale of the bot for which the generation request was made.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The generation ID for which to return the generation details.
     * </p>
     * 
     * @return The generation ID for which to return the generation details.
     */
    public final String generationId() {
        return generationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureReasons() {
        return failureReasons != null && !(failureReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of reasons why the generation of bot resources through natural language description failed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureReasons} method.
     * </p>
     * 
     * @return A list of reasons why the generation of bot resources through natural language description failed.
     */
    public final List<String> failureReasons() {
        return failureReasons;
    }

    /**
     * <p>
     * The status of the generation request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #generationStatus}
     * will return {@link GenerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #generationStatusAsString}.
     * </p>
     * 
     * @return The status of the generation request.
     * @see GenerationStatus
     */
    public final GenerationStatus generationStatus() {
        return GenerationStatus.fromValue(generationStatus);
    }

    /**
     * <p>
     * The status of the generation request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #generationStatus}
     * will return {@link GenerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #generationStatusAsString}.
     * </p>
     * 
     * @return The status of the generation request.
     * @see GenerationStatus
     */
    public final String generationStatusAsString() {
        return generationStatus;
    }

    /**
     * <p>
     * The prompt used in the generation request.
     * </p>
     * 
     * @return The prompt used in the generation request.
     */
    public final String generationInputPrompt() {
        return generationInputPrompt;
    }

    /**
     * <p>
     * The Amazon S3 location of the generated bot locale configuration.
     * </p>
     * 
     * @return The Amazon S3 location of the generated bot locale configuration.
     */
    public final String generatedBotLocaleUrl() {
        return generatedBotLocaleUrl;
    }

    /**
     * <p>
     * The date and time at which the item was generated.
     * </p>
     * 
     * @return The date and time at which the item was generated.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The ARN of the model used to generate the bot resources.
     * </p>
     * 
     * @return The ARN of the model used to generate the bot resources.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The date and time at which the generated item was updated.
     * </p>
     * 
     * @return The date and time at which the generated item was updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(generationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureReasons() ? failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(generationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(generationInputPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(generatedBotLocaleUrl());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBotResourceGenerationResponse)) {
            return false;
        }
        DescribeBotResourceGenerationResponse other = (DescribeBotResourceGenerationResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId()) && Objects.equals(generationId(), other.generationId())
                && hasFailureReasons() == other.hasFailureReasons() && Objects.equals(failureReasons(), other.failureReasons())
                && Objects.equals(generationStatusAsString(), other.generationStatusAsString())
                && Objects.equals(generationInputPrompt(), other.generationInputPrompt())
                && Objects.equals(generatedBotLocaleUrl(), other.generatedBotLocaleUrl())
                && Objects.equals(creationDateTime(), other.creationDateTime()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBotResourceGenerationResponse").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("GenerationId", generationId())
                .add("FailureReasons", hasFailureReasons() ? failureReasons() : null)
                .add("GenerationStatus", generationStatusAsString()).add("GenerationInputPrompt", generationInputPrompt())
                .add("GeneratedBotLocaleUrl", generatedBotLocaleUrl()).add("CreationDateTime", creationDateTime())
                .add("ModelArn", modelArn()).add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "generationId":
            return Optional.ofNullable(clazz.cast(generationId()));
        case "failureReasons":
            return Optional.ofNullable(clazz.cast(failureReasons()));
        case "generationStatus":
            return Optional.ofNullable(clazz.cast(generationStatusAsString()));
        case "generationInputPrompt":
            return Optional.ofNullable(clazz.cast(generationInputPrompt()));
        case "generatedBotLocaleUrl":
            return Optional.ofNullable(clazz.cast(generatedBotLocaleUrl()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBotResourceGenerationResponse, T> g) {
        return obj -> g.apply((DescribeBotResourceGenerationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeBotResourceGenerationResponse> {
        /**
         * <p>
         * The unique identifier of the bot for which the generation request was made.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot for which the generation request was made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot for which the generation request was made.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot for which the generation request was made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The locale of the bot for which the generation request was made.
         * </p>
         * 
         * @param localeId
         *        The locale of the bot for which the generation request was made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The generation ID for which to return the generation details.
         * </p>
         * 
         * @param generationId
         *        The generation ID for which to return the generation details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationId(String generationId);

        /**
         * <p>
         * A list of reasons why the generation of bot resources through natural language description failed.
         * </p>
         * 
         * @param failureReasons
         *        A list of reasons why the generation of bot resources through natural language description failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(Collection<String> failureReasons);

        /**
         * <p>
         * A list of reasons why the generation of bot resources through natural language description failed.
         * </p>
         * 
         * @param failureReasons
         *        A list of reasons why the generation of bot resources through natural language description failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReasons(String... failureReasons);

        /**
         * <p>
         * The status of the generation request.
         * </p>
         * 
         * @param generationStatus
         *        The status of the generation request.
         * @see GenerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GenerationStatus
         */
        Builder generationStatus(String generationStatus);

        /**
         * <p>
         * The status of the generation request.
         * </p>
         * 
         * @param generationStatus
         *        The status of the generation request.
         * @see GenerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GenerationStatus
         */
        Builder generationStatus(GenerationStatus generationStatus);

        /**
         * <p>
         * The prompt used in the generation request.
         * </p>
         * 
         * @param generationInputPrompt
         *        The prompt used in the generation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationInputPrompt(String generationInputPrompt);

        /**
         * <p>
         * The Amazon S3 location of the generated bot locale configuration.
         * </p>
         * 
         * @param generatedBotLocaleUrl
         *        The Amazon S3 location of the generated bot locale configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedBotLocaleUrl(String generatedBotLocaleUrl);

        /**
         * <p>
         * The date and time at which the item was generated.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time at which the item was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The ARN of the model used to generate the bot resources.
         * </p>
         * 
         * @param modelArn
         *        The ARN of the model used to generate the bot resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The date and time at which the generated item was updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time at which the generated item was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private String generationId;

        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();

        private String generationStatus;

        private String generationInputPrompt;

        private String generatedBotLocaleUrl;

        private Instant creationDateTime;

        private String modelArn;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBotResourceGenerationResponse model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            generationId(model.generationId);
            failureReasons(model.failureReasons);
            generationStatus(model.generationStatus);
            generationInputPrompt(model.generationInputPrompt);
            generatedBotLocaleUrl(model.generatedBotLocaleUrl);
            creationDateTime(model.creationDateTime);
            modelArn(model.modelArn);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getGenerationId() {
            return generationId;
        }

        public final void setGenerationId(String generationId) {
            this.generationId = generationId;
        }

        @Override
        public final Builder generationId(String generationId) {
            this.generationId = generationId;
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String... failureReasons) {
            failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final String getGenerationStatus() {
            return generationStatus;
        }

        public final void setGenerationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
        }

        @Override
        public final Builder generationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
            return this;
        }

        @Override
        public final Builder generationStatus(GenerationStatus generationStatus) {
            this.generationStatus(generationStatus == null ? null : generationStatus.toString());
            return this;
        }

        public final String getGenerationInputPrompt() {
            return generationInputPrompt;
        }

        public final void setGenerationInputPrompt(String generationInputPrompt) {
            this.generationInputPrompt = generationInputPrompt;
        }

        @Override
        public final Builder generationInputPrompt(String generationInputPrompt) {
            this.generationInputPrompt = generationInputPrompt;
            return this;
        }

        public final String getGeneratedBotLocaleUrl() {
            return generatedBotLocaleUrl;
        }

        public final void setGeneratedBotLocaleUrl(String generatedBotLocaleUrl) {
            this.generatedBotLocaleUrl = generatedBotLocaleUrl;
        }

        @Override
        public final Builder generatedBotLocaleUrl(String generatedBotLocaleUrl) {
            this.generatedBotLocaleUrl = generatedBotLocaleUrl;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public DescribeBotResourceGenerationResponse build() {
            return new DescribeBotResourceGenerationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
