/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains specifications about the Amazon Lex runtime generative AI capabilities from Amazon Bedrock that you can turn
 * on for your bot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuntimeSettings implements SdkPojo, Serializable, ToCopyableBuilder<RuntimeSettings.Builder, RuntimeSettings> {
    private static final SdkField<SlotResolutionImprovementSpecification> SLOT_RESOLUTION_IMPROVEMENT_FIELD = SdkField
            .<SlotResolutionImprovementSpecification> builder(MarshallingType.SDK_POJO).memberName("slotResolutionImprovement")
            .getter(getter(RuntimeSettings::slotResolutionImprovement)).setter(setter(Builder::slotResolutionImprovement))
            .constructor(SlotResolutionImprovementSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotResolutionImprovement").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SLOT_RESOLUTION_IMPROVEMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final SlotResolutionImprovementSpecification slotResolutionImprovement;

    private RuntimeSettings(BuilderImpl builder) {
        this.slotResolutionImprovement = builder.slotResolutionImprovement;
    }

    /**
     * <p>
     * An object containing specifications for the assisted slot resolution feature.
     * </p>
     * 
     * @return An object containing specifications for the assisted slot resolution feature.
     */
    public final SlotResolutionImprovementSpecification slotResolutionImprovement() {
        return slotResolutionImprovement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(slotResolutionImprovement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeSettings)) {
            return false;
        }
        RuntimeSettings other = (RuntimeSettings) obj;
        return Objects.equals(slotResolutionImprovement(), other.slotResolutionImprovement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuntimeSettings").add("SlotResolutionImprovement", slotResolutionImprovement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotResolutionImprovement":
            return Optional.ofNullable(clazz.cast(slotResolutionImprovement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuntimeSettings, T> g) {
        return obj -> g.apply((RuntimeSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuntimeSettings> {
        /**
         * <p>
         * An object containing specifications for the assisted slot resolution feature.
         * </p>
         * 
         * @param slotResolutionImprovement
         *        An object containing specifications for the assisted slot resolution feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotResolutionImprovement(SlotResolutionImprovementSpecification slotResolutionImprovement);

        /**
         * <p>
         * An object containing specifications for the assisted slot resolution feature.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SlotResolutionImprovementSpecification.Builder} avoiding the need to create one manually via
         * {@link SlotResolutionImprovementSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlotResolutionImprovementSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #slotResolutionImprovement(SlotResolutionImprovementSpecification)}.
         * 
         * @param slotResolutionImprovement
         *        a consumer that will call methods on {@link SlotResolutionImprovementSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slotResolutionImprovement(SlotResolutionImprovementSpecification)
         */
        default Builder slotResolutionImprovement(
                Consumer<SlotResolutionImprovementSpecification.Builder> slotResolutionImprovement) {
            return slotResolutionImprovement(SlotResolutionImprovementSpecification.builder()
                    .applyMutation(slotResolutionImprovement).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SlotResolutionImprovementSpecification slotResolutionImprovement;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeSettings model) {
            slotResolutionImprovement(model.slotResolutionImprovement);
        }

        public final SlotResolutionImprovementSpecification.Builder getSlotResolutionImprovement() {
            return slotResolutionImprovement != null ? slotResolutionImprovement.toBuilder() : null;
        }

        public final void setSlotResolutionImprovement(
                SlotResolutionImprovementSpecification.BuilderImpl slotResolutionImprovement) {
            this.slotResolutionImprovement = slotResolutionImprovement != null ? slotResolutionImprovement.build() : null;
        }

        @Override
        public final Builder slotResolutionImprovement(SlotResolutionImprovementSpecification slotResolutionImprovement) {
            this.slotResolutionImprovement = slotResolutionImprovement;
            return this;
        }

        @Override
        public RuntimeSettings build() {
            return new RuntimeSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
