/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about a slot type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotTypeSummary implements SdkPojo, Serializable, ToCopyableBuilder<SlotTypeSummary.Builder, SlotTypeSummary> {
    private static final SdkField<String> SLOT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotTypeId").getter(getter(SlotTypeSummary::slotTypeId)).setter(setter(Builder::slotTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeId").build()).build();

    private static final SdkField<String> SLOT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotTypeName").getter(getter(SlotTypeSummary::slotTypeName)).setter(setter(Builder::slotTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SlotTypeSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PARENT_SLOT_TYPE_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentSlotTypeSignature").getter(getter(SlotTypeSummary::parentSlotTypeSignature))
            .setter(setter(Builder::parentSlotTypeSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentSlotTypeSignature").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(SlotTypeSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> SLOT_TYPE_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotTypeCategory").getter(getter(SlotTypeSummary::slotTypeCategoryAsString))
            .setter(setter(Builder::slotTypeCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeCategory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_TYPE_ID_FIELD,
            SLOT_TYPE_NAME_FIELD, DESCRIPTION_FIELD, PARENT_SLOT_TYPE_SIGNATURE_FIELD, LAST_UPDATED_DATE_TIME_FIELD,
            SLOT_TYPE_CATEGORY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String slotTypeId;

    private final String slotTypeName;

    private final String description;

    private final String parentSlotTypeSignature;

    private final Instant lastUpdatedDateTime;

    private final String slotTypeCategory;

    private SlotTypeSummary(BuilderImpl builder) {
        this.slotTypeId = builder.slotTypeId;
        this.slotTypeName = builder.slotTypeName;
        this.description = builder.description;
        this.parentSlotTypeSignature = builder.parentSlotTypeSignature;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.slotTypeCategory = builder.slotTypeCategory;
    }

    /**
     * <p>
     * The unique identifier assigned to the slot type.
     * </p>
     * 
     * @return The unique identifier assigned to the slot type.
     */
    public final String slotTypeId() {
        return slotTypeId;
    }

    /**
     * <p>
     * The name of the slot type.
     * </p>
     * 
     * @return The name of the slot type.
     */
    public final String slotTypeName() {
        return slotTypeName;
    }

    /**
     * <p>
     * The description of the slot type.
     * </p>
     * 
     * @return The description of the slot type.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * If the slot type is derived from a built-on slot type, the name of the parent slot type.
     * </p>
     * 
     * @return If the slot type is derived from a built-on slot type, the name of the parent slot type.
     */
    public final String parentSlotTypeSignature() {
        return parentSlotTypeSignature;
    }

    /**
     * <p>
     * A timestamp of the date and time that the slot type was last updated.
     * </p>
     * 
     * @return A timestamp of the date and time that the slot type was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * Indicates the type of the slot type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Custom</code> - A slot type that you created using custom values. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/custom-slot-types.html">Creating custom slot types</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Extended</code> - A slot type created by extending the <code>AMAZON.AlphaNumeric</code> built-in slot type.
     * For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/built-in-slot-alphanumerice.html">
     * <code>AMAZON.AlphaNumeric</code> </a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExternalGrammar</code> - A slot type using a custom GRXML grammar to define values. For more information,
     * see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/building-grxml.html">Using a custom grammar slot
     * type</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slotTypeCategory}
     * will return {@link SlotTypeCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #slotTypeCategoryAsString}.
     * </p>
     * 
     * @return Indicates the type of the slot type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Custom</code> - A slot type that you created using custom values. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/custom-slot-types.html">Creating custom slot types</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Extended</code> - A slot type created by extending the <code>AMAZON.AlphaNumeric</code> built-in
     *         slot type. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/built-in-slot-alphanumerice.html">
     *         <code>AMAZON.AlphaNumeric</code> </a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ExternalGrammar</code> - A slot type using a custom GRXML grammar to define values. For more
     *         information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/building-grxml.html">Using a custom
     *         grammar slot type</a>.
     *         </p>
     *         </li>
     * @see SlotTypeCategory
     */
    public final SlotTypeCategory slotTypeCategory() {
        return SlotTypeCategory.fromValue(slotTypeCategory);
    }

    /**
     * <p>
     * Indicates the type of the slot type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Custom</code> - A slot type that you created using custom values. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/custom-slot-types.html">Creating custom slot types</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Extended</code> - A slot type created by extending the <code>AMAZON.AlphaNumeric</code> built-in slot type.
     * For more information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/built-in-slot-alphanumerice.html">
     * <code>AMAZON.AlphaNumeric</code> </a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExternalGrammar</code> - A slot type using a custom GRXML grammar to define values. For more information,
     * see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/building-grxml.html">Using a custom grammar slot
     * type</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slotTypeCategory}
     * will return {@link SlotTypeCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #slotTypeCategoryAsString}.
     * </p>
     * 
     * @return Indicates the type of the slot type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Custom</code> - A slot type that you created using custom values. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/custom-slot-types.html">Creating custom slot types</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Extended</code> - A slot type created by extending the <code>AMAZON.AlphaNumeric</code> built-in
     *         slot type. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/built-in-slot-alphanumerice.html">
     *         <code>AMAZON.AlphaNumeric</code> </a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ExternalGrammar</code> - A slot type using a custom GRXML grammar to define values. For more
     *         information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/building-grxml.html">Using a custom
     *         grammar slot type</a>.
     *         </p>
     *         </li>
     * @see SlotTypeCategory
     */
    public final String slotTypeCategoryAsString() {
        return slotTypeCategory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(slotTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(slotTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(parentSlotTypeSignature());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(slotTypeCategoryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotTypeSummary)) {
            return false;
        }
        SlotTypeSummary other = (SlotTypeSummary) obj;
        return Objects.equals(slotTypeId(), other.slotTypeId()) && Objects.equals(slotTypeName(), other.slotTypeName())
                && Objects.equals(description(), other.description())
                && Objects.equals(parentSlotTypeSignature(), other.parentSlotTypeSignature())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(slotTypeCategoryAsString(), other.slotTypeCategoryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotTypeSummary").add("SlotTypeId", slotTypeId()).add("SlotTypeName", slotTypeName())
                .add("Description", description()).add("ParentSlotTypeSignature", parentSlotTypeSignature())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).add("SlotTypeCategory", slotTypeCategoryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotTypeId":
            return Optional.ofNullable(clazz.cast(slotTypeId()));
        case "slotTypeName":
            return Optional.ofNullable(clazz.cast(slotTypeName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "parentSlotTypeSignature":
            return Optional.ofNullable(clazz.cast(parentSlotTypeSignature()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "slotTypeCategory":
            return Optional.ofNullable(clazz.cast(slotTypeCategoryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlotTypeSummary, T> g) {
        return obj -> g.apply((SlotTypeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotTypeSummary> {
        /**
         * <p>
         * The unique identifier assigned to the slot type.
         * </p>
         * 
         * @param slotTypeId
         *        The unique identifier assigned to the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeId(String slotTypeId);

        /**
         * <p>
         * The name of the slot type.
         * </p>
         * 
         * @param slotTypeName
         *        The name of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeName(String slotTypeName);

        /**
         * <p>
         * The description of the slot type.
         * </p>
         * 
         * @param description
         *        The description of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If the slot type is derived from a built-on slot type, the name of the parent slot type.
         * </p>
         * 
         * @param parentSlotTypeSignature
         *        If the slot type is derived from a built-on slot type, the name of the parent slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentSlotTypeSignature(String parentSlotTypeSignature);

        /**
         * <p>
         * A timestamp of the date and time that the slot type was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        A timestamp of the date and time that the slot type was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * Indicates the type of the slot type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Custom</code> - A slot type that you created using custom values. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/custom-slot-types.html">Creating custom slot types</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Extended</code> - A slot type created by extending the <code>AMAZON.AlphaNumeric</code> built-in slot
         * type. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/built-in-slot-alphanumerice.html">
         * <code>AMAZON.AlphaNumeric</code> </a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ExternalGrammar</code> - A slot type using a custom GRXML grammar to define values. For more
         * information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/building-grxml.html">Using a custom
         * grammar slot type</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param slotTypeCategory
         *        Indicates the type of the slot type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Custom</code> - A slot type that you created using custom values. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/custom-slot-types.html">Creating custom slot
         *        types</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Extended</code> - A slot type created by extending the <code>AMAZON.AlphaNumeric</code> built-in
         *        slot type. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/built-in-slot-alphanumerice.html">
         *        <code>AMAZON.AlphaNumeric</code> </a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ExternalGrammar</code> - A slot type using a custom GRXML grammar to define values. For more
         *        information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/building-grxml.html">Using a
         *        custom grammar slot type</a>.
         *        </p>
         *        </li>
         * @see SlotTypeCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotTypeCategory
         */
        Builder slotTypeCategory(String slotTypeCategory);

        /**
         * <p>
         * Indicates the type of the slot type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Custom</code> - A slot type that you created using custom values. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/custom-slot-types.html">Creating custom slot types</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Extended</code> - A slot type created by extending the <code>AMAZON.AlphaNumeric</code> built-in slot
         * type. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/built-in-slot-alphanumerice.html">
         * <code>AMAZON.AlphaNumeric</code> </a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ExternalGrammar</code> - A slot type using a custom GRXML grammar to define values. For more
         * information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/building-grxml.html">Using a custom
         * grammar slot type</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param slotTypeCategory
         *        Indicates the type of the slot type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Custom</code> - A slot type that you created using custom values. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/custom-slot-types.html">Creating custom slot
         *        types</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Extended</code> - A slot type created by extending the <code>AMAZON.AlphaNumeric</code> built-in
         *        slot type. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/built-in-slot-alphanumerice.html">
         *        <code>AMAZON.AlphaNumeric</code> </a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ExternalGrammar</code> - A slot type using a custom GRXML grammar to define values. For more
         *        information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/building-grxml.html">Using a
         *        custom grammar slot type</a>.
         *        </p>
         *        </li>
         * @see SlotTypeCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotTypeCategory
         */
        Builder slotTypeCategory(SlotTypeCategory slotTypeCategory);
    }

    static final class BuilderImpl implements Builder {
        private String slotTypeId;

        private String slotTypeName;

        private String description;

        private String parentSlotTypeSignature;

        private Instant lastUpdatedDateTime;

        private String slotTypeCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotTypeSummary model) {
            slotTypeId(model.slotTypeId);
            slotTypeName(model.slotTypeName);
            description(model.description);
            parentSlotTypeSignature(model.parentSlotTypeSignature);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            slotTypeCategory(model.slotTypeCategory);
        }

        public final String getSlotTypeId() {
            return slotTypeId;
        }

        public final void setSlotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
        }

        @Override
        public final Builder slotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
            return this;
        }

        public final String getSlotTypeName() {
            return slotTypeName;
        }

        public final void setSlotTypeName(String slotTypeName) {
            this.slotTypeName = slotTypeName;
        }

        @Override
        public final Builder slotTypeName(String slotTypeName) {
            this.slotTypeName = slotTypeName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getParentSlotTypeSignature() {
            return parentSlotTypeSignature;
        }

        public final void setParentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
        }

        @Override
        public final Builder parentSlotTypeSignature(String parentSlotTypeSignature) {
            this.parentSlotTypeSignature = parentSlotTypeSignature;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getSlotTypeCategory() {
            return slotTypeCategory;
        }

        public final void setSlotTypeCategory(String slotTypeCategory) {
            this.slotTypeCategory = slotTypeCategory;
        }

        @Override
        public final Builder slotTypeCategory(String slotTypeCategory) {
            this.slotTypeCategory = slotTypeCategory;
            return this;
        }

        @Override
        public final Builder slotTypeCategory(SlotTypeCategory slotTypeCategory) {
            this.slotTypeCategory(slotTypeCategory == null ? null : slotTypeCategory.toString());
            return this;
        }

        @Override
        public SlotTypeSummary build() {
            return new SlotTypeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
