/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about multiple utterances in the results of a test set execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UtteranceLevelTestResultItem implements SdkPojo, Serializable,
        ToCopyableBuilder<UtteranceLevelTestResultItem.Builder, UtteranceLevelTestResultItem> {
    private static final SdkField<Long> RECORD_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("recordNumber").getter(getter(UtteranceLevelTestResultItem::recordNumber))
            .setter(setter(Builder::recordNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordNumber").build()).build();

    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conversationId").getter(getter(UtteranceLevelTestResultItem::conversationId))
            .setter(setter(Builder::conversationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()).build();

    private static final SdkField<TestSetTurnResult> TURN_RESULT_FIELD = SdkField
            .<TestSetTurnResult> builder(MarshallingType.SDK_POJO).memberName("turnResult")
            .getter(getter(UtteranceLevelTestResultItem::turnResult)).setter(setter(Builder::turnResult))
            .constructor(TestSetTurnResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("turnResult").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_NUMBER_FIELD,
            CONVERSATION_ID_FIELD, TURN_RESULT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long recordNumber;

    private final String conversationId;

    private final TestSetTurnResult turnResult;

    private UtteranceLevelTestResultItem(BuilderImpl builder) {
        this.recordNumber = builder.recordNumber;
        this.conversationId = builder.conversationId;
        this.turnResult = builder.turnResult;
    }

    /**
     * <p>
     * The record number of the result.
     * </p>
     * 
     * @return The record number of the result.
     */
    public final Long recordNumber() {
        return recordNumber;
    }

    /**
     * <p>
     * The unique identifier for the conversation associated with the result.
     * </p>
     * 
     * @return The unique identifier for the conversation associated with the result.
     */
    public final String conversationId() {
        return conversationId;
    }

    /**
     * <p>
     * Contains information about the turn associated with the result.
     * </p>
     * 
     * @return Contains information about the turn associated with the result.
     */
    public final TestSetTurnResult turnResult() {
        return turnResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordNumber());
        hashCode = 31 * hashCode + Objects.hashCode(conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(turnResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceLevelTestResultItem)) {
            return false;
        }
        UtteranceLevelTestResultItem other = (UtteranceLevelTestResultItem) obj;
        return Objects.equals(recordNumber(), other.recordNumber()) && Objects.equals(conversationId(), other.conversationId())
                && Objects.equals(turnResult(), other.turnResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UtteranceLevelTestResultItem").add("RecordNumber", recordNumber())
                .add("ConversationId", conversationId()).add("TurnResult", turnResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recordNumber":
            return Optional.ofNullable(clazz.cast(recordNumber()));
        case "conversationId":
            return Optional.ofNullable(clazz.cast(conversationId()));
        case "turnResult":
            return Optional.ofNullable(clazz.cast(turnResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UtteranceLevelTestResultItem, T> g) {
        return obj -> g.apply((UtteranceLevelTestResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UtteranceLevelTestResultItem> {
        /**
         * <p>
         * The record number of the result.
         * </p>
         * 
         * @param recordNumber
         *        The record number of the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordNumber(Long recordNumber);

        /**
         * <p>
         * The unique identifier for the conversation associated with the result.
         * </p>
         * 
         * @param conversationId
         *        The unique identifier for the conversation associated with the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationId(String conversationId);

        /**
         * <p>
         * Contains information about the turn associated with the result.
         * </p>
         * 
         * @param turnResult
         *        Contains information about the turn associated with the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder turnResult(TestSetTurnResult turnResult);

        /**
         * <p>
         * Contains information about the turn associated with the result.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestSetTurnResult.Builder} avoiding the
         * need to create one manually via {@link TestSetTurnResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestSetTurnResult.Builder#build()} is called immediately and its
         * result is passed to {@link #turnResult(TestSetTurnResult)}.
         * 
         * @param turnResult
         *        a consumer that will call methods on {@link TestSetTurnResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #turnResult(TestSetTurnResult)
         */
        default Builder turnResult(Consumer<TestSetTurnResult.Builder> turnResult) {
            return turnResult(TestSetTurnResult.builder().applyMutation(turnResult).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long recordNumber;

        private String conversationId;

        private TestSetTurnResult turnResult;

        private BuilderImpl() {
        }

        private BuilderImpl(UtteranceLevelTestResultItem model) {
            recordNumber(model.recordNumber);
            conversationId(model.conversationId);
            turnResult(model.turnResult);
        }

        public final Long getRecordNumber() {
            return recordNumber;
        }

        public final void setRecordNumber(Long recordNumber) {
            this.recordNumber = recordNumber;
        }

        @Override
        public final Builder recordNumber(Long recordNumber) {
            this.recordNumber = recordNumber;
            return this;
        }

        public final String getConversationId() {
            return conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final TestSetTurnResult.Builder getTurnResult() {
            return turnResult != null ? turnResult.toBuilder() : null;
        }

        public final void setTurnResult(TestSetTurnResult.BuilderImpl turnResult) {
            this.turnResult = turnResult != null ? turnResult.build() : null;
        }

        @Override
        public final Builder turnResult(TestSetTurnResult turnResult) {
            this.turnResult = turnResult;
            return this;
        }

        @Override
        public UtteranceLevelTestResultItem build() {
            return new UtteranceLevelTestResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
