/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * Internal implementation of {@link LicenseManagerUserSubscriptionsClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultLicenseManagerUserSubscriptionsClientBuilder
        extends
        DefaultLicenseManagerUserSubscriptionsBaseClientBuilder<LicenseManagerUserSubscriptionsClientBuilder, LicenseManagerUserSubscriptionsClient>
        implements LicenseManagerUserSubscriptionsClientBuilder {
    @Override
    protected final LicenseManagerUserSubscriptionsClient buildClient() {
        return new DefaultLicenseManagerUserSubscriptionsClient(super.syncClientConfiguration());
    }
}
