/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an identity provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityProviderSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityProviderSummary.Builder, IdentityProviderSummary> {
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMessage").getter(getter(IdentityProviderSummary::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()).build();

    private static final SdkField<IdentityProvider> IDENTITY_PROVIDER_FIELD = SdkField
            .<IdentityProvider> builder(MarshallingType.SDK_POJO).memberName("IdentityProvider")
            .getter(getter(IdentityProviderSummary::identityProvider)).setter(setter(Builder::identityProvider))
            .constructor(IdentityProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProvider").build()).build();

    private static final SdkField<String> PRODUCT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Product")
            .getter(getter(IdentityProviderSummary::product)).setter(setter(Builder::product))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Product").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(IdentityProviderSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_MESSAGE_FIELD,
            IDENTITY_PROVIDER_FIELD, PRODUCT_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String failureMessage;

    private final IdentityProvider identityProvider;

    private final String product;

    private final String status;

    private IdentityProviderSummary(BuilderImpl builder) {
        this.failureMessage = builder.failureMessage;
        this.identityProvider = builder.identityProvider;
        this.product = builder.product;
        this.status = builder.status;
    }

    /**
     * <p>
     * The failure message associated with an identity provider.
     * </p>
     * 
     * @return The failure message associated with an identity provider.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * An object that specifies details for the identity provider.
     * </p>
     * 
     * @return An object that specifies details for the identity provider.
     */
    public final IdentityProvider identityProvider() {
        return identityProvider;
    }

    /**
     * <p>
     * The name of the user-based subscription product.
     * </p>
     * 
     * @return The name of the user-based subscription product.
     */
    public final String product() {
        return product;
    }

    /**
     * <p>
     * The status of an identity provider.
     * </p>
     * 
     * @return The status of an identity provider.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(identityProvider());
        hashCode = 31 * hashCode + Objects.hashCode(product());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProviderSummary)) {
            return false;
        }
        IdentityProviderSummary other = (IdentityProviderSummary) obj;
        return Objects.equals(failureMessage(), other.failureMessage())
                && Objects.equals(identityProvider(), other.identityProvider()) && Objects.equals(product(), other.product())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityProviderSummary").add("FailureMessage", failureMessage())
                .add("IdentityProvider", identityProvider()).add("Product", product()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "IdentityProvider":
            return Optional.ofNullable(clazz.cast(identityProvider()));
        case "Product":
            return Optional.ofNullable(clazz.cast(product()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityProviderSummary, T> g) {
        return obj -> g.apply((IdentityProviderSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityProviderSummary> {
        /**
         * <p>
         * The failure message associated with an identity provider.
         * </p>
         * 
         * @param failureMessage
         *        The failure message associated with an identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * An object that specifies details for the identity provider.
         * </p>
         * 
         * @param identityProvider
         *        An object that specifies details for the identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProvider(IdentityProvider identityProvider);

        /**
         * <p>
         * An object that specifies details for the identity provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentityProvider.Builder} avoiding the
         * need to create one manually via {@link IdentityProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #identityProvider(IdentityProvider)}.
         * 
         * @param identityProvider
         *        a consumer that will call methods on {@link IdentityProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProvider(IdentityProvider)
         */
        default Builder identityProvider(Consumer<IdentityProvider.Builder> identityProvider) {
            return identityProvider(IdentityProvider.builder().applyMutation(identityProvider).build());
        }

        /**
         * <p>
         * The name of the user-based subscription product.
         * </p>
         * 
         * @param product
         *        The name of the user-based subscription product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder product(String product);

        /**
         * <p>
         * The status of an identity provider.
         * </p>
         * 
         * @param status
         *        The status of an identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String failureMessage;

        private IdentityProvider identityProvider;

        private String product;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProviderSummary model) {
            failureMessage(model.failureMessage);
            identityProvider(model.identityProvider);
            product(model.product);
            status(model.status);
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final IdentityProvider.Builder getIdentityProvider() {
            return identityProvider != null ? identityProvider.toBuilder() : null;
        }

        public final void setIdentityProvider(IdentityProvider.BuilderImpl identityProvider) {
            this.identityProvider = identityProvider != null ? identityProvider.build() : null;
        }

        @Override
        public final Builder identityProvider(IdentityProvider identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        public final String getProduct() {
            return product;
        }

        public final void setProduct(String product) {
            this.product = product;
        }

        @Override
        public final Builder product(String product) {
            this.product = product;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public IdentityProviderSummary build() {
            return new IdentityProviderSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
