/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExportSnapshotRecordsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetExportSnapshotRecordsResponse.Builder, GetExportSnapshotRecordsResponse> {
    private static final SdkField<List<ExportSnapshotRecord>> EXPORT_SNAPSHOT_RECORDS_FIELD = SdkField
            .<List<ExportSnapshotRecord>> builder(MarshallingType.LIST)
            .memberName("exportSnapshotRecords")
            .getter(getter(GetExportSnapshotRecordsResponse::exportSnapshotRecords))
            .setter(setter(Builder::exportSnapshotRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportSnapshotRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExportSnapshotRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExportSnapshotRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextPageToken").getter(getter(GetExportSnapshotRecordsResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_SNAPSHOT_RECORDS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<ExportSnapshotRecord> exportSnapshotRecords;

    private final String nextPageToken;

    private GetExportSnapshotRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.exportSnapshotRecords = builder.exportSnapshotRecords;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExportSnapshotRecords property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExportSnapshotRecords() {
        return exportSnapshotRecords != null && !(exportSnapshotRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects describing the export snapshot records.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExportSnapshotRecords} method.
     * </p>
     * 
     * @return A list of objects describing the export snapshot records.
     */
    public final List<ExportSnapshotRecord> exportSnapshotRecords() {
        return exportSnapshotRecords;
    }

    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * A next page token is not returned if there are no more results to display.
     * </p>
     * <p>
     * To get the next page of results, perform another <code>GetExportSnapshotRecords</code> request and specify the
     * next page token using the <code>pageToken</code> parameter.
     * </p>
     * 
     * @return The token to advance to the next page of results from your request.</p>
     *         <p>
     *         A next page token is not returned if there are no more results to display.
     *         </p>
     *         <p>
     *         To get the next page of results, perform another <code>GetExportSnapshotRecords</code> request and
     *         specify the next page token using the <code>pageToken</code> parameter.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExportSnapshotRecords() ? exportSnapshotRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportSnapshotRecordsResponse)) {
            return false;
        }
        GetExportSnapshotRecordsResponse other = (GetExportSnapshotRecordsResponse) obj;
        return hasExportSnapshotRecords() == other.hasExportSnapshotRecords()
                && Objects.equals(exportSnapshotRecords(), other.exportSnapshotRecords())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExportSnapshotRecordsResponse")
                .add("ExportSnapshotRecords", hasExportSnapshotRecords() ? exportSnapshotRecords() : null)
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportSnapshotRecords":
            return Optional.ofNullable(clazz.cast(exportSnapshotRecords()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExportSnapshotRecordsResponse, T> g) {
        return obj -> g.apply((GetExportSnapshotRecordsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetExportSnapshotRecordsResponse> {
        /**
         * <p>
         * A list of objects describing the export snapshot records.
         * </p>
         * 
         * @param exportSnapshotRecords
         *        A list of objects describing the export snapshot records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportSnapshotRecords(Collection<ExportSnapshotRecord> exportSnapshotRecords);

        /**
         * <p>
         * A list of objects describing the export snapshot records.
         * </p>
         * 
         * @param exportSnapshotRecords
         *        A list of objects describing the export snapshot records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportSnapshotRecords(ExportSnapshotRecord... exportSnapshotRecords);

        /**
         * <p>
         * A list of objects describing the export snapshot records.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecord.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecord.Builder#build()} is called
         * immediately and its result is passed to {@link #exportSnapshotRecords(List<ExportSnapshotRecord>)}.
         * 
         * @param exportSnapshotRecords
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportSnapshotRecords(java.util.Collection<ExportSnapshotRecord>)
         */
        Builder exportSnapshotRecords(Consumer<ExportSnapshotRecord.Builder>... exportSnapshotRecords);

        /**
         * <p>
         * The token to advance to the next page of results from your request.
         * </p>
         * <p>
         * A next page token is not returned if there are no more results to display.
         * </p>
         * <p>
         * To get the next page of results, perform another <code>GetExportSnapshotRecords</code> request and specify
         * the next page token using the <code>pageToken</code> parameter.
         * </p>
         * 
         * @param nextPageToken
         *        The token to advance to the next page of results from your request.</p>
         *        <p>
         *        A next page token is not returned if there are no more results to display.
         *        </p>
         *        <p>
         *        To get the next page of results, perform another <code>GetExportSnapshotRecords</code> request and
         *        specify the next page token using the <code>pageToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<ExportSnapshotRecord> exportSnapshotRecords = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportSnapshotRecordsResponse model) {
            super(model);
            exportSnapshotRecords(model.exportSnapshotRecords);
            nextPageToken(model.nextPageToken);
        }

        public final List<ExportSnapshotRecord.Builder> getExportSnapshotRecords() {
            List<ExportSnapshotRecord.Builder> result = ExportSnapshotRecordListCopier.copyToBuilder(this.exportSnapshotRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExportSnapshotRecords(Collection<ExportSnapshotRecord.BuilderImpl> exportSnapshotRecords) {
            this.exportSnapshotRecords = ExportSnapshotRecordListCopier.copyFromBuilder(exportSnapshotRecords);
        }

        @Override
        public final Builder exportSnapshotRecords(Collection<ExportSnapshotRecord> exportSnapshotRecords) {
            this.exportSnapshotRecords = ExportSnapshotRecordListCopier.copy(exportSnapshotRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportSnapshotRecords(ExportSnapshotRecord... exportSnapshotRecords) {
            exportSnapshotRecords(Arrays.asList(exportSnapshotRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportSnapshotRecords(Consumer<ExportSnapshotRecord.Builder>... exportSnapshotRecords) {
            exportSnapshotRecords(Stream.of(exportSnapshotRecords)
                    .map(c -> ExportSnapshotRecord.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetExportSnapshotRecordsResponse build() {
            return new GetExportSnapshotRecordsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
