/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRetrainingSchedulerResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<DescribeRetrainingSchedulerResponse.Builder, DescribeRetrainingSchedulerResponse> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(DescribeRetrainingSchedulerResponse::modelName))
            .setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArn").getter(getter(DescribeRetrainingSchedulerResponse::modelArn))
            .setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()).build();

    private static final SdkField<Instant> RETRAINING_START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RetrainingStartDate").getter(getter(DescribeRetrainingSchedulerResponse::retrainingStartDate))
            .setter(setter(Builder::retrainingStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingStartDate").build())
            .build();

    private static final SdkField<String> RETRAINING_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RetrainingFrequency").getter(getter(DescribeRetrainingSchedulerResponse::retrainingFrequency))
            .setter(setter(Builder::retrainingFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingFrequency").build())
            .build();

    private static final SdkField<String> LOOKBACK_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LookbackWindow").getter(getter(DescribeRetrainingSchedulerResponse::lookbackWindow))
            .setter(setter(Builder::lookbackWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackWindow").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeRetrainingSchedulerResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> PROMOTE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PromoteMode").getter(getter(DescribeRetrainingSchedulerResponse::promoteModeAsString))
            .setter(setter(Builder::promoteMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromoteMode").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DescribeRetrainingSchedulerResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(DescribeRetrainingSchedulerResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            MODEL_ARN_FIELD, RETRAINING_START_DATE_FIELD, RETRAINING_FREQUENCY_FIELD, LOOKBACK_WINDOW_FIELD, STATUS_FIELD,
            PROMOTE_MODE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private final String modelName;

    private final String modelArn;

    private final Instant retrainingStartDate;

    private final String retrainingFrequency;

    private final String lookbackWindow;

    private final String status;

    private final String promoteMode;

    private final Instant createdAt;

    private final Instant updatedAt;

    private DescribeRetrainingSchedulerResponse(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.retrainingStartDate = builder.retrainingStartDate;
        this.retrainingFrequency = builder.retrainingFrequency;
        this.lookbackWindow = builder.lookbackWindow;
        this.status = builder.status;
        this.promoteMode = builder.promoteMode;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The name of the model that the retraining scheduler is attached to.
     * </p>
     * 
     * @return The name of the model that the retraining scheduler is attached to.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The ARN of the model that the retraining scheduler is attached to.
     * </p>
     * 
     * @return The ARN of the model that the retraining scheduler is attached to.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The start date for the retraining scheduler. Lookout for Equipment truncates the time you provide to the nearest
     * UTC day.
     * </p>
     * 
     * @return The start date for the retraining scheduler. Lookout for Equipment truncates the time you provide to the
     *         nearest UTC day.
     */
    public final Instant retrainingStartDate() {
        return retrainingStartDate;
    }

    /**
     * <p>
     * The frequency at which the model retraining is set. This follows the <a
     * href="https://en.wikipedia.org/wiki/ISO_8601#Durations">ISO 8601</a> guidelines.
     * </p>
     * 
     * @return The frequency at which the model retraining is set. This follows the <a
     *         href="https://en.wikipedia.org/wiki/ISO_8601#Durations">ISO 8601</a> guidelines.
     */
    public final String retrainingFrequency() {
        return retrainingFrequency;
    }

    /**
     * <p>
     * The number of past days of data used for retraining.
     * </p>
     * 
     * @return The number of past days of data used for retraining.
     */
    public final String lookbackWindow() {
        return lookbackWindow;
    }

    /**
     * <p>
     * The status of the retraining scheduler.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RetrainingSchedulerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the retraining scheduler.
     * @see RetrainingSchedulerStatus
     */
    public final RetrainingSchedulerStatus status() {
        return RetrainingSchedulerStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the retraining scheduler.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RetrainingSchedulerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the retraining scheduler.
     * @see RetrainingSchedulerStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Indicates how the service uses new models. In <code>MANAGED</code> mode, new models are used for inference if
     * they have better performance than the current model. In <code>MANUAL</code> mode, the new models are not used
     * until they are <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation"
     * >manually activated</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #promoteMode} will
     * return {@link ModelPromoteMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #promoteModeAsString}.
     * </p>
     * 
     * @return Indicates how the service uses new models. In <code>MANAGED</code> mode, new models are used for
     *         inference if they have better performance than the current model. In <code>MANUAL</code> mode, the new
     *         models are not used until they are <a href=
     *         "https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation"
     *         >manually activated</a>.
     * @see ModelPromoteMode
     */
    public final ModelPromoteMode promoteMode() {
        return ModelPromoteMode.fromValue(promoteMode);
    }

    /**
     * <p>
     * Indicates how the service uses new models. In <code>MANAGED</code> mode, new models are used for inference if
     * they have better performance than the current model. In <code>MANUAL</code> mode, the new models are not used
     * until they are <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation"
     * >manually activated</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #promoteMode} will
     * return {@link ModelPromoteMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #promoteModeAsString}.
     * </p>
     * 
     * @return Indicates how the service uses new models. In <code>MANAGED</code> mode, new models are used for
     *         inference if they have better performance than the current model. In <code>MANUAL</code> mode, the new
     *         models are not used until they are <a href=
     *         "https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation"
     *         >manually activated</a>.
     * @see ModelPromoteMode
     */
    public final String promoteModeAsString() {
        return promoteMode;
    }

    /**
     * <p>
     * Indicates the time and date at which the retraining scheduler was created.
     * </p>
     * 
     * @return Indicates the time and date at which the retraining scheduler was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Indicates the time and date at which the retraining scheduler was updated.
     * </p>
     * 
     * @return Indicates the time and date at which the retraining scheduler was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(retrainingStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(retrainingFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(lookbackWindow());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(promoteModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRetrainingSchedulerResponse)) {
            return false;
        }
        DescribeRetrainingSchedulerResponse other = (DescribeRetrainingSchedulerResponse) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(retrainingStartDate(), other.retrainingStartDate())
                && Objects.equals(retrainingFrequency(), other.retrainingFrequency())
                && Objects.equals(lookbackWindow(), other.lookbackWindow())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(promoteModeAsString(), other.promoteModeAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRetrainingSchedulerResponse").add("ModelName", modelName()).add("ModelArn", modelArn())
                .add("RetrainingStartDate", retrainingStartDate()).add("RetrainingFrequency", retrainingFrequency())
                .add("LookbackWindow", lookbackWindow()).add("Status", statusAsString())
                .add("PromoteMode", promoteModeAsString()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "RetrainingStartDate":
            return Optional.ofNullable(clazz.cast(retrainingStartDate()));
        case "RetrainingFrequency":
            return Optional.ofNullable(clazz.cast(retrainingFrequency()));
        case "LookbackWindow":
            return Optional.ofNullable(clazz.cast(lookbackWindow()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "PromoteMode":
            return Optional.ofNullable(clazz.cast(promoteModeAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRetrainingSchedulerResponse, T> g) {
        return obj -> g.apply((DescribeRetrainingSchedulerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRetrainingSchedulerResponse> {
        /**
         * <p>
         * The name of the model that the retraining scheduler is attached to.
         * </p>
         * 
         * @param modelName
         *        The name of the model that the retraining scheduler is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The ARN of the model that the retraining scheduler is attached to.
         * </p>
         * 
         * @param modelArn
         *        The ARN of the model that the retraining scheduler is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The start date for the retraining scheduler. Lookout for Equipment truncates the time you provide to the
         * nearest UTC day.
         * </p>
         * 
         * @param retrainingStartDate
         *        The start date for the retraining scheduler. Lookout for Equipment truncates the time you provide to
         *        the nearest UTC day.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrainingStartDate(Instant retrainingStartDate);

        /**
         * <p>
         * The frequency at which the model retraining is set. This follows the <a
         * href="https://en.wikipedia.org/wiki/ISO_8601#Durations">ISO 8601</a> guidelines.
         * </p>
         * 
         * @param retrainingFrequency
         *        The frequency at which the model retraining is set. This follows the <a
         *        href="https://en.wikipedia.org/wiki/ISO_8601#Durations">ISO 8601</a> guidelines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrainingFrequency(String retrainingFrequency);

        /**
         * <p>
         * The number of past days of data used for retraining.
         * </p>
         * 
         * @param lookbackWindow
         *        The number of past days of data used for retraining.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lookbackWindow(String lookbackWindow);

        /**
         * <p>
         * The status of the retraining scheduler.
         * </p>
         * 
         * @param status
         *        The status of the retraining scheduler.
         * @see RetrainingSchedulerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrainingSchedulerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the retraining scheduler.
         * </p>
         * 
         * @param status
         *        The status of the retraining scheduler.
         * @see RetrainingSchedulerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrainingSchedulerStatus
         */
        Builder status(RetrainingSchedulerStatus status);

        /**
         * <p>
         * Indicates how the service uses new models. In <code>MANAGED</code> mode, new models are used for inference if
         * they have better performance than the current model. In <code>MANUAL</code> mode, the new models are not used
         * until they are <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation"
         * >manually activated</a>.
         * </p>
         * 
         * @param promoteMode
         *        Indicates how the service uses new models. In <code>MANAGED</code> mode, new models are used for
         *        inference if they have better performance than the current model. In <code>MANUAL</code> mode, the new
         *        models are not used until they are <a href=
         *        "https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation"
         *        >manually activated</a>.
         * @see ModelPromoteMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPromoteMode
         */
        Builder promoteMode(String promoteMode);

        /**
         * <p>
         * Indicates how the service uses new models. In <code>MANAGED</code> mode, new models are used for inference if
         * they have better performance than the current model. In <code>MANUAL</code> mode, the new models are not used
         * until they are <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation"
         * >manually activated</a>.
         * </p>
         * 
         * @param promoteMode
         *        Indicates how the service uses new models. In <code>MANAGED</code> mode, new models are used for
         *        inference if they have better performance than the current model. In <code>MANUAL</code> mode, the new
         *        models are not used until they are <a href=
         *        "https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/versioning-model.html#model-activation"
         *        >manually activated</a>.
         * @see ModelPromoteMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPromoteMode
         */
        Builder promoteMode(ModelPromoteMode promoteMode);

        /**
         * <p>
         * Indicates the time and date at which the retraining scheduler was created.
         * </p>
         * 
         * @param createdAt
         *        Indicates the time and date at which the retraining scheduler was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Indicates the time and date at which the retraining scheduler was updated.
         * </p>
         * 
         * @param updatedAt
         *        Indicates the time and date at which the retraining scheduler was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String modelName;

        private String modelArn;

        private Instant retrainingStartDate;

        private String retrainingFrequency;

        private String lookbackWindow;

        private String status;

        private String promoteMode;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRetrainingSchedulerResponse model) {
            super(model);
            modelName(model.modelName);
            modelArn(model.modelArn);
            retrainingStartDate(model.retrainingStartDate);
            retrainingFrequency(model.retrainingFrequency);
            lookbackWindow(model.lookbackWindow);
            status(model.status);
            promoteMode(model.promoteMode);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Instant getRetrainingStartDate() {
            return retrainingStartDate;
        }

        public final void setRetrainingStartDate(Instant retrainingStartDate) {
            this.retrainingStartDate = retrainingStartDate;
        }

        @Override
        public final Builder retrainingStartDate(Instant retrainingStartDate) {
            this.retrainingStartDate = retrainingStartDate;
            return this;
        }

        public final String getRetrainingFrequency() {
            return retrainingFrequency;
        }

        public final void setRetrainingFrequency(String retrainingFrequency) {
            this.retrainingFrequency = retrainingFrequency;
        }

        @Override
        public final Builder retrainingFrequency(String retrainingFrequency) {
            this.retrainingFrequency = retrainingFrequency;
            return this;
        }

        public final String getLookbackWindow() {
            return lookbackWindow;
        }

        public final void setLookbackWindow(String lookbackWindow) {
            this.lookbackWindow = lookbackWindow;
        }

        @Override
        public final Builder lookbackWindow(String lookbackWindow) {
            this.lookbackWindow = lookbackWindow;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RetrainingSchedulerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getPromoteMode() {
            return promoteMode;
        }

        public final void setPromoteMode(String promoteMode) {
            this.promoteMode = promoteMode;
        }

        @Override
        public final Builder promoteMode(String promoteMode) {
            this.promoteMode = promoteMode;
            return this;
        }

        @Override
        public final Builder promoteMode(ModelPromoteMode promoteMode) {
            this.promoteMode(promoteMode == null ? null : promoteMode.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public DescribeRetrainingSchedulerResponse build() {
            return new DescribeRetrainingSchedulerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
